/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.report.modules.output.pageable.base.pagelayout;

import java.io.Serializable;

public strictfp class SimplePageLayoutCursor
implements Cloneable,
Serializable {
    private long y = 0L;
    private final long pageBottom;
    private long reserved;
    private long pageTop;

    public SimplePageLayoutCursor(long height) {
        this.pageBottom = height;
    }

    public void advance(long amount) {
        if (amount < 0L) {
            throw new IllegalArgumentException("Cannot advance negative");
        }
        this.y += amount;
    }

    public void advanceTo(long amount) {
        if (amount < this.y) {
            throw new IllegalArgumentException("Cannot advance negative");
        }
        this.y = amount;
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public long getPageBottom() {
        return this.pageBottom;
    }

    public long getPageBottomReserved() {
        return this.pageBottom - this.reserved;
    }

    public long getPageTop() {
        return this.pageTop;
    }

    public long getReservedSpace() {
        return this.reserved;
    }

    public long getY() {
        return this.y;
    }

    public boolean isSpaceFor(long height) {
        return this.y + height <= this.pageBottom - this.reserved;
    }

    public void setPageTop(long pageTop) {
        this.pageTop = pageTop;
    }

    public void setReservedSpace(long reserve) {
        if (reserve < 0L) {
            throw new IllegalArgumentException("Cannot free reserved space");
        }
        if (reserve > this.pageBottom) {
            throw new IllegalArgumentException("Cannot reserve more than the available space");
        }
        this.reserved = reserve;
    }

    public String toString() {
        StringBuffer b = new StringBuffer();
        b.append("SimplePageLayoutCursor={y=");
        b.append(this.y);
        b.append(", pagebottom=");
        b.append(this.pageBottom);
        b.append(", reserved=");
        b.append(this.reserved);
        b.append("}");
        return b.toString();
    }
}

