/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.report.modules.output.pageable.graphics;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Paint;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.print.PageFormat;
import java.io.IOException;
import java.net.URL;
import org.jfree.base.log.MemoryUsageMessage;
import org.jfree.report.ImageContainer;
import org.jfree.report.LocalImageContainer;
import org.jfree.report.PageDefinition;
import org.jfree.report.URLImageContainer;
import org.jfree.report.content.DrawableContent;
import org.jfree.report.content.ImageContent;
import org.jfree.report.layout.DefaultSizeCalculator;
import org.jfree.report.layout.SizeCalculator;
import org.jfree.report.modules.output.pageable.base.OutputTargetException;
import org.jfree.report.modules.output.pageable.base.output.AbstractOutputTarget;
import org.jfree.report.resourceloader.ImageFactory;
import org.jfree.report.style.FontDefinition;
import org.jfree.report.util.geom.StrictBounds;
import org.jfree.report.util.geom.StrictGeomUtility;
import org.jfree.ui.Drawable;
import org.jfree.util.Configuration;
import org.jfree.util.Log;
import org.jfree.util.WaitingImageObserver;

public strictfp class G2OutputTarget
extends AbstractOutputTarget {
    private Graphics2D g2;
    private G2State savedState;
    private Shape originalClip;
    private static Graphics2D dummyGraphics;
    private boolean isOpen;
    private FontDefinition fontDefinition;
    private PageFormat currentPageFormat;

    public G2OutputTarget(Graphics2D graphics) {
        this.setGraphics2D(graphics);
    }

    private static void applyStandardRenderingHints(Graphics2D g2) {
        g2.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
        if (DefaultSizeCalculator.getFrcDetector().isAliased()) {
            g2.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        } else {
            g2.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_OFF);
        }
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
    }

    protected void beginPage(PageDefinition page, int index) {
        this.currentPageFormat = page.getPageFormat(index);
        Rectangle2D.Double bounds = new Rectangle2D.Double(this.currentPageFormat.getImageableX(), this.currentPageFormat.getImageableY(), this.currentPageFormat.getImageableWidth() + 1.0, this.currentPageFormat.getImageableHeight() + 1.0);
        this.g2.clip(bounds);
        Rectangle2D pbounds = page.getPagePosition(index);
        this.g2.translate(-pbounds.getX(), -pbounds.getY());
        double ty = this.currentPageFormat.getImageableY();
        double tx = this.currentPageFormat.getImageableX();
        this.g2.transform(AffineTransform.getTranslateInstance(tx, ty));
        this.savedState = this.saveState();
    }

    public void close() {
        this.originalClip = null;
        this.savedState = null;
        this.isOpen = false;
    }

    public void configure(Configuration config) {
    }

    public static Graphics2D createEmptyGraphics() {
        if (dummyGraphics == null) {
            BufferedImage image = new BufferedImage(2, 1, 1);
            dummyGraphics = image.createGraphics();
            G2OutputTarget.applyStandardRenderingHints(dummyGraphics);
        }
        return dummyGraphics;
    }

    public SizeCalculator createTextSizeCalculator(FontDefinition font) {
        return DefaultSizeCalculator.getDefaultSizeCalculator(font);
    }

    protected void drawDrawable(DrawableContent content) {
        Drawable drawable = content.getContent();
        StrictBounds imageArea = content.getImageArea();
        StrictBounds bounds = this.getInternalOperationBounds();
        Graphics2D g2 = (Graphics2D)this.g2.create();
        double imageWidth = StrictGeomUtility.toExternalValue(bounds.getWidth());
        double imageHeight = StrictGeomUtility.toExternalValue(bounds.getHeight());
        Rectangle2D.Double newClipArea = new Rectangle2D.Double(0.0, 0.0, imageWidth, imageHeight);
        g2.clip(newClipArea);
        int imageX = (int)StrictGeomUtility.toExternalValue(imageArea.getX());
        int imageY = (int)StrictGeomUtility.toExternalValue(imageArea.getY());
        g2.translate(-imageX, -imageY);
        StrictBounds drawableBounds = content.getBounds();
        double drawableWidth = StrictGeomUtility.toExternalValue(drawableBounds.getWidth());
        double drawableHeight = StrictGeomUtility.toExternalValue(drawableBounds.getHeight());
        drawable.draw(g2, (Rectangle2D)new Rectangle2D.Double(0.0, 0.0, drawableWidth, drawableHeight));
        g2.dispose();
    }

    protected void drawImage(ImageContent content) {
        Image image = null;
        ImageContainer imageContainer = content.getContent();
        if (imageContainer instanceof LocalImageContainer) {
            LocalImageContainer loImage = (LocalImageContainer)imageContainer;
            image = loImage.getImage();
        }
        if (image == null && imageContainer instanceof URLImageContainer) {
            URLImageContainer urlImageContainer = (URLImageContainer)imageContainer;
            if (!urlImageContainer.isLoadable()) {
                return;
            }
            URL url = urlImageContainer.getSourceURL();
            if (url == null) {
                return;
            }
            try {
                image = ImageFactory.getInstance().createImage(url);
            }
            catch (IOException iOException) {
                Log.warn((Object)("Unable to load image from " + url));
                return;
            }
        }
        if (image == null) {
            return;
        }
        StrictBounds imageArea = content.getImageArea();
        StrictBounds bounds = this.getInternalOperationBounds();
        Shape s = this.g2.getClip();
        AffineTransform transform = this.g2.getTransform();
        try {
            double imageWidth = StrictGeomUtility.toExternalValue(bounds.getWidth());
            double imageHeight = StrictGeomUtility.toExternalValue(bounds.getHeight());
            Rectangle2D.Double newClipArea = new Rectangle2D.Double(0.0, 0.0, imageWidth, imageHeight);
            this.g2.clip(newClipArea);
            double scaleX = (double)bounds.getWidth() / (double)imageArea.getWidth();
            double scaleY = (double)bounds.getHeight() / (double)imageArea.getHeight();
            this.g2.scale(scaleX, scaleY);
            int imageX = (int)StrictGeomUtility.toExternalValue(imageArea.getX());
            int imageY = (int)StrictGeomUtility.toExternalValue(imageArea.getY());
            while (!this.g2.drawImage(image, -imageX, -imageY, null)) {
                WaitingImageObserver obs = new WaitingImageObserver(image);
                obs.waitImageLoaded();
                if (!obs.isError()) continue;
                Log.warn((Object)"The image observer detected an error while loading the Image");
                break;
            }
        }
        catch (Throwable th) {
            Log.warn((Object)new MemoryUsageMessage("Failure at drawImage"));
            Log.warn((Object)th);
        }
        this.g2.setTransform(transform);
        this.g2.setClip(s);
    }

    protected void drawShape(Shape shape) {
        this.g2.draw(shape);
    }

    protected void endPage() throws OutputTargetException {
        Rectangle2D pageBounds = this.getPageBounds();
        this.g2.transform(AffineTransform.getTranslateInstance(0.0 - this.currentPageFormat.getImageableX() + pageBounds.getX(), 0.0 - this.currentPageFormat.getImageableY() + pageBounds.getY()));
        this.g2.setClip(this.originalClip);
        this.restoreState();
    }

    protected void fillShape(Shape shape) {
        this.g2.fill(shape);
    }

    protected FontDefinition getFont() {
        return this.fontDefinition;
    }

    protected Graphics2D getGraphics2D() {
        return this.g2;
    }

    protected Paint getPaint() {
        return this.g2.getPaint();
    }

    protected Stroke getStroke() {
        return this.g2.getStroke();
    }

    public boolean isOpen() {
        return this.isOpen;
    }

    protected boolean isPaintSupported(Paint p) {
        return p != null;
    }

    public void open() throws OutputTargetException {
        this.originalClip = this.g2.getClip();
        this.setFont(new FontDefinition(this.g2.getFont().getName(), this.g2.getFont().getSize()));
        this.isOpen = true;
    }

    protected void printText(String text) {
        Line2D.Float line;
        FontMetrics fm = this.g2.getFontMetrics();
        float baseline = fm.getAscent();
        float cFact = this.getFont().getFont().getSize2D() / (float)fm.getHeight();
        float correctedBaseline = baseline * cFact;
        Stroke stroke = this.getStroke();
        this.g2.setStroke(new BasicStroke(1.0f));
        this.g2.drawString(text, 0.0f, correctedBaseline);
        this.g2.setStroke(stroke);
        if (this.getFont().isUnderline()) {
            float l = (this.getFont().getFont().getSize2D() + correctedBaseline) / 2.0f;
            line = new Line2D.Float(0.0f, l, (float)this.getOperationBounds().getWidth(), l);
            this.g2.draw(line);
        }
        if (this.getFont().isStrikeThrough()) {
            float fontHeight = this.getFont().getFont().getSize2D();
            line = new Line2D.Float(0.0f, fontHeight / 2.0f, (float)this.getOperationBounds().getWidth(), fontHeight / 2.0f);
            this.g2.draw(line);
        }
    }

    private void restoreState() {
        this.savedState.restore(this);
    }

    private G2State saveState() {
        class Org_jfree_report_modules_output_pageable_graphics_G2OutputTarget$1 {
            /* synthetic */ Org_jfree_report_modules_output_pageable_graphics_G2OutputTarget$1() {
            }
        }
        return new G2State(null, this);
    }

    protected void setFont(FontDefinition font) {
        if (font == null) {
            throw new NullPointerException();
        }
        this.fontDefinition = font;
        this.g2.setFont(font.getFont());
    }

    private void setGraphics2D(Graphics2D g2) {
        if (g2 == null) {
            throw new NullPointerException("Graphics must not be null");
        }
        this.g2 = (Graphics2D)g2.create();
        G2OutputTarget.applyStandardRenderingHints(this.g2);
    }

    protected void setInternalOperationBounds(StrictBounds bounds) {
        StrictBounds oldBounds = super.getInternalOperationBounds();
        this.g2.transform(AffineTransform.getTranslateInstance(0.0 - StrictGeomUtility.toExternalValue(oldBounds.getX()), 0.0 - StrictGeomUtility.toExternalValue(oldBounds.getY())));
        super.setInternalOperationBounds(bounds);
        this.g2.transform(AffineTransform.getTranslateInstance(StrictGeomUtility.toExternalValue(bounds.getX()), StrictGeomUtility.toExternalValue(bounds.getY())));
    }

    protected void setPaint(Paint paint) {
        this.g2.setPaint(paint);
    }

    protected void setStroke(Stroke stroke) {
        this.g2.setStroke(stroke);
    }

    private strictfp static final class G2State {
        private Paint mypaint;
        private FontDefinition myfont;
        private Stroke mystroke;
        private AffineTransform mytransform;
        private Color mybackground;
        private Shape myclip;

        /* synthetic */ G2State(1 $0, G2OutputTarget $1) {
            this($1);
        }

        private G2State(G2OutputTarget s) {
            this.save(s);
        }

        protected void restore(G2OutputTarget target) {
            target.setStroke(this.mystroke);
            target.setFont(this.myfont);
            target.setPaint(this.mypaint);
            Graphics2D g2 = target.getGraphics2D();
            g2.setTransform(this.mytransform);
            g2.setBackground(this.mybackground);
            g2.setClip(this.myclip);
        }

        protected void save(G2OutputTarget source) {
            this.mypaint = source.getPaint();
            this.myfont = source.getFont();
            this.mystroke = source.getStroke();
            Graphics2D g2 = source.getGraphics2D();
            this.mytransform = g2.getTransform();
            this.mybackground = g2.getBackground();
            this.myclip = g2.getClip();
        }
    }
}

