/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.report.modules.output.pageable.plaintext;

import java.awt.Paint;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import org.jfree.report.JFreeReportBoot;
import org.jfree.report.PageDefinition;
import org.jfree.report.content.ContentFactory;
import org.jfree.report.content.DefaultContentFactory;
import org.jfree.report.content.DrawableContent;
import org.jfree.report.content.ImageContent;
import org.jfree.report.content.TextContentFactoryModule;
import org.jfree.report.layout.SizeCalculator;
import org.jfree.report.modules.output.pageable.base.OutputTargetException;
import org.jfree.report.modules.output.pageable.base.output.AbstractOutputTarget;
import org.jfree.report.modules.output.pageable.plaintext.PlainTextPage;
import org.jfree.report.modules.output.pageable.plaintext.PrinterDriver;
import org.jfree.report.style.FontDefinition;
import org.jfree.report.util.EncodingSupport;
import org.jfree.report.util.geom.StrictGeomUtility;
import org.jfree.util.Configuration;

public strictfp class PlainTextOutputTarget
extends AbstractOutputTarget {
    public static final String CONFIGURATION_PREFIX = "org.jfree.report.modules.output.pageable.plaintext.";
    public static final String ENCODING_PROPERTY = "Encoding";
    public static final String LINES_PER_INCH = "LinesPerInch";
    public static final String CHARS_PER_INCH = "CharsPerInch";
    public static final String TEXT_OUTPUT_ENCODING = "org.jfree.report.modules.output.pageable.plaintext.Encoding";
    public static final String TEXT_OUTPUT_ENCODING_DEFAULT = EncodingSupport.getPlatformDefaultEncoding();
    private boolean open;
    private FontDefinition font;
    private PlainTextState savedState;
    private PlainTextPage pageBuffer;
    private PrinterDriver driver;
    private String encoding;
    private float characterHeightInPoint;
    private long internalCharacterHeight;
    private float characterWidthInPoint;
    private long internalCharacterWidth;

    public PlainTextOutputTarget(PrinterDriver commandSet) {
        if (commandSet == null) {
            throw new NullPointerException();
        }
        this.driver = commandSet;
        this.characterHeightInPoint = 72.0f / this.driver.getLinesPerInch();
        this.characterWidthInPoint = 72.0f / this.driver.getCharactersPerInch();
        this.internalCharacterHeight = StrictGeomUtility.toInternalValue(this.characterHeightInPoint);
        this.internalCharacterWidth = StrictGeomUtility.toInternalValue(this.characterWidthInPoint);
    }

    public void beginPage(PageDefinition page, int index) {
        this.pageBuffer = new PlainTextPage(page.getPageFormat(index), this.driver, this.encoding);
        class Org_jfree_report_modules_output_pageable_plaintext_PlainTextOutputTarget$1 {
            /* synthetic */ Org_jfree_report_modules_output_pageable_plaintext_PlainTextOutputTarget$1() {
            }
        }
        this.savedState = new PlainTextState(null, this);
    }

    public void close() {
        this.open = false;
    }

    public void configure(Configuration config) {
        if (this.encoding == null) {
            this.encoding = PlainTextOutputTarget.getTextTargetEncoding(config);
        }
    }

    public static int correctedDivisionFloor(float c, float d) {
        c = Math.round(c * 100.0f);
        d = Math.round(d * 100.0f);
        return (int)Math.floor(c / d);
    }

    protected ContentFactory createContentFactory() {
        DefaultContentFactory contentFactory = new DefaultContentFactory();
        contentFactory.addModule(new TextContentFactoryModule());
        return contentFactory;
    }

    public SizeCalculator createTextSizeCalculator(FontDefinition font) throws OutputTargetException {
        return new PlainTextSizeCalculator(this.characterWidthInPoint, this.characterHeightInPoint);
    }

    protected void drawDrawable(DrawableContent drawable) {
    }

    protected void drawImage(ImageContent image) throws OutputTargetException {
    }

    protected void drawShape(Shape shape) {
    }

    public void endPage() throws OutputTargetException {
        try {
            this.pageBuffer.writePage();
        }
        catch (IOException ioe) {
            throw new OutputTargetException("Failed to write the page", ioe);
        }
        this.pageBuffer = null;
    }

    protected void fillShape(Shape shape) {
    }

    public PrinterDriver getDriver() {
        return this.driver;
    }

    public String getEncoding() {
        return this.encoding;
    }

    protected FontDefinition getFont() {
        return this.font;
    }

    public float getHorizontalAlignmentBorder() {
        return this.characterWidthInPoint;
    }

    public long getInternalHorizontalAlignmentBorder() {
        return this.internalCharacterWidth;
    }

    public long getInternalVerticalAlignmentBorder() {
        return this.internalCharacterHeight;
    }

    protected Paint getPaint() {
        return null;
    }

    protected Stroke getStroke() {
        return null;
    }

    public static String getTextTargetEncoding(Configuration config) {
        if (config == null) {
            config = JFreeReportBoot.getInstance().getGlobalConfig();
        }
        return config.getConfigProperty(TEXT_OUTPUT_ENCODING, TEXT_OUTPUT_ENCODING_DEFAULT);
    }

    public float getVerticalAlignmentBorder() {
        return this.characterHeightInPoint;
    }

    public boolean isOpen() {
        return this.open;
    }

    protected boolean isPaintSupported(Paint p) {
        return false;
    }

    public void open() throws OutputTargetException {
        this.open = true;
    }

    protected void printText(String text) {
        Rectangle2D bounds = this.getOperationBounds();
        int x = PlainTextOutputTarget.correctedDivisionFloor((float)bounds.getX(), this.characterWidthInPoint);
        int y = PlainTextOutputTarget.correctedDivisionFloor((float)bounds.getY(), this.characterHeightInPoint);
        int w = PlainTextOutputTarget.correctedDivisionFloor((float)bounds.getWidth(), this.characterWidthInPoint);
        this.pageBuffer.addTextChunk(x, y, w, text, this.getFont());
    }

    protected void restoreState() throws OutputTargetException {
        this.savedState.restore(this);
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    protected void setFont(FontDefinition font) throws OutputTargetException {
        this.font = font;
    }

    protected void setPaint(Paint paint) {
    }

    protected void setStroke(Stroke stroke) throws OutputTargetException {
    }

    private strictfp static final class PlainTextState {
        private Paint mypaint;
        private FontDefinition myfont;
        private Stroke mystroke;

        /* synthetic */ PlainTextState(1 $0, PlainTextOutputTarget $1) {
            this($1);
        }

        private PlainTextState(PlainTextOutputTarget source) {
            this.save(source);
        }

        protected void restore(PlainTextOutputTarget target) throws OutputTargetException {
            target.setStroke(this.mystroke);
            target.setFont(this.myfont);
            target.setPaint(this.mypaint);
        }

        protected void save(PlainTextOutputTarget source) {
            this.mypaint = source.getPaint();
            this.myfont = source.getFont();
            this.mystroke = source.getStroke();
        }
    }

    private strictfp static final class PlainTextSizeCalculator
    implements SizeCalculator {
        private final float characterWidth;
        private final float characterHeight;

        public PlainTextSizeCalculator(float characterWidth, float characterHeight) {
            if (characterHeight <= 0.0f) {
                throw new IllegalArgumentException("The font size is invalid.");
            }
            this.characterWidth = characterWidth;
            this.characterHeight = characterHeight;
        }

        public float getLineHeight() {
            return this.characterHeight;
        }

        public float getStringWidth(String text, int lineStartPos, int endPos) {
            if (lineStartPos < 0) {
                throw new IllegalArgumentException("LineStart < 0");
            }
            if (endPos < lineStartPos) {
                throw new IllegalArgumentException("LineEnd < LineStart");
            }
            if (endPos > text.length()) {
                throw new IllegalArgumentException("EndPos > TextLength");
            }
            return this.characterWidth * (float)(endPos - lineStartPos);
        }
    }
}

