/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.report.modules.output.support.itext;

import com.lowagie.text.DocumentException;
import com.lowagie.text.pdf.BaseFont;
import com.lowagie.text.pdf.DefaultFontMapper;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Properties;
import java.util.StringTokenizer;
import org.jfree.report.JFreeReportBoot;
import org.jfree.report.modules.misc.configstore.base.ConfigFactory;
import org.jfree.report.modules.misc.configstore.base.ConfigStorage;
import org.jfree.report.modules.misc.configstore.base.ConfigStoreException;
import org.jfree.report.util.EncodingSupport;
import org.jfree.report.util.StringUtil;
import org.jfree.util.HashNMap;
import org.jfree.util.Log;

public final class BaseFontFactory
extends DefaultFontMapper {
    public static final String ITEXT_FONT_AUTOINIT = "org.jfree.report.modules.output.support.itext.AutoInit";
    public static final String ITEXT_FONT_AUTOINIT_ONINIT = "onInit";
    public static final String ITEXT_FONT_AUTOINIT_LAZY = "lazy";
    public static final String ITEXT_FONT_AUTOINIT_NEVER = "never";
    public static final String ITEXT_FONT_AUTOINIT_DEFAULT = "lazy";
    public static final String ITEXT_FONT_ENCODING = "org.jfree.report.modules.output.support.itext.Encoding";
    public static final String ITEXT_FONT_ENCODING_DEFAULT = EncodingSupport.getPlatformDefaultEncoding();
    public static final String GC_AFTER_REGISTER = "org.jfree.report.modules.output.support.itext.GCAfterRegister";
    private static final FontPathFilter FONTPATHFILTER = new FontPathFilter();
    private static final String FONTS_STORAGE_PATH = "registered_itext_fonts";
    private static final String KNOWN_FONTS_PATH = "known_itext_font_files";
    private static final String NO_EMBEDDING_FONTS_PATH = "noEmbedding_itext_font_files";
    private static BaseFontFactory fontFactory;
    private final Properties notEmbeddedFonts;
    private final Properties fontsByName = new Properties();
    private boolean initialized;
    private Properties confirmedFiles;

    private BaseFontFactory() {
        this.notEmbeddedFonts = new Properties();
    }

    private void addFont(String font, String encoding) throws DocumentException, IOException {
        BaseFont bfont;
        if (((Hashtable)this.fontsByName).containsValue(font)) {
            return;
        }
        String embedded = "false";
        try {
            bfont = BaseFont.createFont((String)font, (String)encoding, (boolean)true, (boolean)false, null, null);
            embedded = "true";
        }
        catch (DocumentException documentException) {
            bfont = BaseFont.createFont((String)font, (String)encoding, (boolean)false, (boolean)false, null, null);
            Log.info((Object)new Log.SimpleMessage("Font ", (Object)font, (Object)"  cannot be used as embedded font due to licensing restrictions."));
        }
        String[][] fi = bfont.getFullFontName();
        int i = 0;
        while (i < fi.length) {
            String[] ffi = fi[i];
            String knownFontEmbeddedState = this.notEmbeddedFonts.getProperty(font, "false");
            String logicalFontname = ffi[3];
            this.notEmbeddedFonts.setProperty(font, embedded);
            if (!((Hashtable)this.fontsByName).containsKey(logicalFontname) || !knownFontEmbeddedState.equals("true") && !embedded.equals(knownFontEmbeddedState)) {
                this.fontsByName.setProperty(logicalFontname, font);
                Log.debug((Object)new Log.SimpleMessage("Registered truetype font ", (Object)logicalFontname, (Object)"; Embedded=", (Object)embedded, (Object)new Log.SimpleMessage("File=", (Object)font)));
            }
            ++i;
        }
    }

    public static String getDefaultFontEncoding() {
        return JFreeReportBoot.getInstance().getGlobalConfig().getConfigProperty(ITEXT_FONT_ENCODING, ITEXT_FONT_ENCODING_DEFAULT);
    }

    public static synchronized BaseFontFactory getFontFactory() {
        if (fontFactory == null) {
            fontFactory = new BaseFontFactory();
        }
        return fontFactory;
    }

    public String getFontfileForName(String font) {
        if (!this.isInitialized() && this.getPDFTargetAutoInit().equals("lazy")) {
            this.registerDefaultFontPath();
        }
        return this.fontsByName.getProperty(font);
    }

    public String getPDFTargetAutoInit() {
        return JFreeReportBoot.getInstance().getGlobalConfig().getConfigProperty(ITEXT_FONT_AUTOINIT, "lazy");
    }

    public Iterator getRegisteredFonts() {
        return ((Hashtable)this.fontsByName).keySet().iterator();
    }

    public boolean isEmbeddable(String fontFileName) {
        if (!this.isInitialized() && this.getPDFTargetAutoInit().equals("lazy")) {
            this.registerDefaultFontPath();
        }
        return this.notEmbeddedFonts.getProperty(fontFileName, "false").equals("true");
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    public synchronized void registerDefaultFontPath() {
        String encoding;
        ConfigStorage store = ConfigFactory.getInstance().getSystemStorage();
        HashNMap knownFonts = new HashNMap();
        Properties seenFiles = new Properties();
        this.confirmedFiles = new Properties();
        if (store.existsProperties(FONTS_STORAGE_PATH)) {
            try {
                Properties propKnownFonts = store.loadProperties(FONTS_STORAGE_PATH, null);
                Enumeration keys = ((Hashtable)propKnownFonts).keys();
                while (keys.hasMoreElements()) {
                    String fontName = (String)keys.nextElement();
                    String fileName = propKnownFonts.getProperty(fontName);
                    knownFonts.add((Object)fileName, (Object)fontName);
                }
                Properties propEmbedded = store.loadProperties(NO_EMBEDDING_FONTS_PATH, null);
                ((Hashtable)this.notEmbeddedFonts).putAll(propEmbedded);
                Log.info((Object)"Registering fonts for the iText library; using a cached font registry.");
            }
            catch (ConfigStoreException configStoreException) {
                Log.info((Object)"Unable to load font configuration, rebuilding.");
            }
        } else {
            Log.info((Object)"Registering fonts for the iText library.");
        }
        if (store.existsProperties(KNOWN_FONTS_PATH)) {
            try {
                Properties loadedSeenFiles = store.loadProperties(KNOWN_FONTS_PATH, null);
                seenFiles = new Properties();
                Iterator seenFilesIt = ((Hashtable)loadedSeenFiles).keySet().iterator();
                while (seenFilesIt.hasNext()) {
                    Object key = seenFilesIt.next();
                    if (!knownFonts.containsKey(key)) continue;
                    ((Hashtable)seenFiles).put(key, ((Hashtable)loadedSeenFiles).get(key));
                    seenFilesIt.remove();
                }
                Log.debug((Object)("Lost files: " + loadedSeenFiles));
            }
            catch (ConfigStoreException configStoreException) {
                Log.info((Object)"Unable to load known font files, rebuilding.");
            }
        }
        if ((encoding = BaseFontFactory.getDefaultFontEncoding()).equals("Identity-H") || encoding.equals("Identity-V")) {
            encoding = "UTF-16";
        }
        String osname = this.safeSystemGetProperty("os.name", "<protected by system security>");
        String jrepath = this.safeSystemGetProperty("java.home", ".");
        String fs = this.safeSystemGetProperty("file.separator", File.separator);
        Log.debug((Object)("Running on operating system: " + osname));
        Log.debug((Object)("Character encoding used as default: " + encoding));
        if (this.safeSystemGetProperty("mrj.version", null) != null) {
            String userhome = this.safeSystemGetProperty("user.home", ".");
            Log.debug((Object)"Detected MacOS (Property 'mrj.version' is present.");
            this.registerFontPath(new File(String.valueOf(userhome) + "/Library/Fonts"), encoding, knownFonts, seenFiles);
            this.registerFontPath(new File("/Library/Fonts"), encoding, knownFonts, seenFiles);
            this.registerFontPath(new File("/Network/Library/Fonts"), encoding, knownFonts, seenFiles);
            this.registerFontPath(new File("/System/Library/Fonts"), encoding, knownFonts, seenFiles);
        } else if (StringUtil.startsWithIgnoreCase(osname, "windows")) {
            this.registerWindowsFontPath(encoding, knownFonts, seenFiles);
        } else {
            Log.debug((Object)"Assuming unix like file structures");
            this.registerFontPath(new File("/usr/X11R6/lib/X11/fonts"), encoding, knownFonts, seenFiles);
            this.registerFontPath(new File("/usr/share/fonts"), encoding, knownFonts, seenFiles);
        }
        this.registerFontPath(new File(jrepath, "lib" + fs + "fonts"), encoding, knownFonts, seenFiles);
        try {
            store.storeProperties(FONTS_STORAGE_PATH, this.fontsByName);
            store.storeProperties(KNOWN_FONTS_PATH, this.confirmedFiles);
            store.storeProperties(NO_EMBEDDING_FONTS_PATH, this.notEmbeddedFonts);
        }
        catch (ConfigStoreException configStoreException) {
            Log.info((Object)"Failed to store font configuration. This error is non-fatal, the font configuration will be rebuild from scratch, if necessary.");
        }
        Log.info((Object)"Completed font registration.");
        this.initialized = true;
    }

    public synchronized void registerFontFile(String filename, String encoding) {
        block6: {
            if (!(filename.toLowerCase().endsWith(".ttf") || filename.toLowerCase().endsWith(".ttc") || filename.toLowerCase().endsWith(".afm") || filename.toLowerCase().endsWith(".otf"))) {
                return;
            }
            File file = new File(filename);
            if (!file.exists() || !file.isFile() || !file.canRead()) break block6;
            String newAccessTime = String.valueOf(String.valueOf(file.lastModified()) + "," + file.length());
            ((Hashtable)this.confirmedFiles).put(filename, newAccessTime);
            try {
                if (filename.toLowerCase().endsWith(".ttc")) {
                    String[] fontNames = BaseFont.enumerateTTCNames((String)filename);
                    int i = 0;
                    while (i < fontNames.length) {
                        this.addFont(String.valueOf(filename) + "," + i, encoding);
                        ++i;
                    }
                } else {
                    this.addFont(filename, encoding);
                }
            }
            catch (Exception e) {
                Log.warn((Object)new Log.SimpleMessage("Font ", (Object)filename, (Object)" is invalid. Message:", (Object)e.getMessage()));
                this.notEmbeddedFonts.setProperty(filename, "false");
            }
        }
    }

    public synchronized void registerFontPath(File file, String encoding) {
        this.registerFontPath(file, encoding, new HashNMap(), new Properties());
    }

    private synchronized void registerFontPath(File file, String encoding, HashNMap knownFonts, Properties seenFiles) {
        if (file.exists() && file.isDirectory() && file.canRead()) {
            File[] files = file.listFiles(FONTPATHFILTER);
            int i = 0;
            while (i < files.length) {
                File currentFile = files[i];
                if (currentFile.isDirectory()) {
                    this.registerFontPath(currentFile, encoding, knownFonts, seenFiles);
                } else {
                    String fileName = currentFile.toString();
                    String cachedAccessTime = seenFiles.getProperty(fileName);
                    String newAccessTime = String.valueOf(String.valueOf(currentFile.lastModified()) + "," + currentFile.length());
                    if (!newAccessTime.equals(cachedAccessTime) || !((Hashtable)this.notEmbeddedFonts).containsKey(fileName)) {
                        this.registerFontFile(fileName, encoding);
                    } else {
                        Iterator it = knownFonts.getAll((Object)fileName);
                        while (it.hasNext()) {
                            String fontName = (String)it.next();
                            ((Hashtable)this.fontsByName).put(fontName, fileName);
                        }
                        ((Hashtable)this.confirmedFiles).put(fileName, newAccessTime);
                    }
                }
                ++i;
            }
        }
        if (JFreeReportBoot.getInstance().getGlobalConfig().getConfigProperty(GC_AFTER_REGISTER, "true").equals("true")) {
            System.gc();
        }
    }

    private void registerWindowsFontPath(String encoding, HashNMap knownFonts, Properties seenFiles) {
        Log.debug((Object)"Found windows in os name, assuming DOS/Win32 structures");
        String fontPath = null;
        String windirs = this.safeSystemGetProperty("java.library.path", null);
        String fs = this.safeSystemGetProperty("file.separator", File.separator);
        if (windirs != null) {
            StringTokenizer strtok = new StringTokenizer(windirs, this.safeSystemGetProperty("path.separator", File.pathSeparator));
            while (strtok.hasMoreTokens()) {
                String token = strtok.nextToken();
                if (!StringUtil.endsWithIgnoreCase(token, "System32")) continue;
                int lastBackslash = token.lastIndexOf(fs);
                fontPath = String.valueOf(token.substring(0, lastBackslash)) + fs + "Fonts";
                break;
            }
        }
        Log.debug((Object)("Fonts located in \"" + fontPath + "\""));
        if (fontPath != null) {
            File file = new File(fontPath);
            this.registerFontPath(file, encoding, knownFonts, seenFiles);
        }
    }

    private String safeSystemGetProperty(String name, String defaultValue) {
        try {
            return System.getProperty(name, defaultValue);
        }
        catch (SecurityException securityException) {
            return defaultValue;
        }
    }

    public static void setDefaultFontEncoding(String encoding) {
        JFreeReportBoot.getInstance().getEditableConfig().setConfigProperty(ITEXT_FONT_ENCODING, encoding);
    }

    public void setPDFTargetAutoInit(String autoInit) {
        if (!(autoInit == null || autoInit.equals("lazy") || autoInit.equals(ITEXT_FONT_AUTOINIT_NEVER) || autoInit.equals(ITEXT_FONT_AUTOINIT_ONINIT))) {
            throw new IllegalArgumentException("Invalid autoinit value.");
        }
        JFreeReportBoot.getInstance().getEditableConfig().setConfigProperty(ITEXT_FONT_AUTOINIT, String.valueOf(autoInit));
    }

    private static class FontPathFilter
    implements FileFilter {
        public boolean accept(File pathname) {
            if (!pathname.canRead()) {
                return false;
            }
            if (pathname.isDirectory()) {
                return true;
            }
            String name = pathname.getName();
            if (StringUtil.endsWithIgnoreCase(name, ".afm")) {
                return true;
            }
            if (StringUtil.endsWithIgnoreCase(name, ".ttf")) {
                return true;
            }
            if (StringUtil.endsWithIgnoreCase(name, ".ttc")) {
                return true;
            }
            return StringUtil.endsWithIgnoreCase(name, ".otf");
        }
    }
}

