/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.report.modules.output.support.itext;

import com.lowagie.text.pdf.BaseFont;
import org.jfree.report.modules.output.support.itext.BaseFontRecordKey;

public final class BaseFontRecord {
    private BaseFont baseFont;
    private String logicalName;
    private boolean embedded;
    private transient BaseFontRecordKey key;

    public BaseFontRecord(String logicalName, boolean embedded, BaseFont baseFont) {
        if (baseFont == null) {
            throw new NullPointerException("iText-FontDefinition is null.");
        }
        if (logicalName == null) {
            throw new NullPointerException("Logical font name is null.");
        }
        this.baseFont = baseFont;
        this.logicalName = logicalName;
        this.embedded = embedded;
    }

    public BaseFontRecordKey createKey() {
        if (this.key == null) {
            this.key = new BaseFontRecordKey(this.getLogicalName(), this.getEncoding(), this.isEmbedded());
        }
        return this.key;
    }

    public BaseFont getBaseFont() {
        return this.baseFont;
    }

    public String getEncoding() {
        return this.baseFont.getEncoding();
    }

    public String getLogicalName() {
        return this.logicalName;
    }

    public boolean isEmbedded() {
        return this.embedded;
    }
}

