/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.report.modules.output.support.itext;

public final class BaseFontRecordKey {
    private final String logicalName;
    private final String encoding;
    private boolean embedded;
    private int hashCode;

    public BaseFontRecordKey(String logicalName, String encoding, boolean embedded) {
        if (logicalName == null) {
            throw new NullPointerException("Logical font name is null.");
        }
        if (encoding == null) {
            throw new NullPointerException("Encoding is null.");
        }
        this.logicalName = logicalName;
        this.encoding = encoding;
        this.embedded = embedded;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof BaseFontRecordKey)) {
            return false;
        }
        BaseFontRecordKey key = (BaseFontRecordKey)o;
        if (this.embedded != key.embedded) {
            return false;
        }
        if (!this.logicalName.equals(key.logicalName)) {
            return false;
        }
        return this.encoding.equals(key.encoding);
    }

    public int hashCode() {
        if (this.hashCode == 0) {
            int result = this.embedded ? 0 : 1;
            result = 29 * result + this.logicalName.hashCode();
            this.hashCode = result = 29 * result + this.encoding.hashCode();
        }
        return this.hashCode;
    }

    public String toString() {
        return "FontKey={name=" + this.logicalName + "; encoding=" + this.encoding + "; embedded=" + this.embedded + "}";
    }
}

