/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.report.modules.output.support.itext;

import com.lowagie.text.DocumentException;
import com.lowagie.text.pdf.BaseFont;
import com.lowagie.text.pdf.FontMapper;
import java.awt.Font;
import java.io.IOException;
import java.util.Map;
import java.util.WeakHashMap;
import org.jfree.report.modules.output.support.itext.BaseFontCreateException;
import org.jfree.report.modules.output.support.itext.BaseFontFactory;
import org.jfree.report.modules.output.support.itext.BaseFontRecord;
import org.jfree.report.modules.output.support.itext.BaseFontRecordKey;
import org.jfree.report.style.FontDefinition;
import org.jfree.report.util.StringUtil;
import org.jfree.util.Log;

public class BaseFontSupport
implements FontMapper {
    private final Map baseFonts = new WeakHashMap();
    private String defaultEncoding;

    public BaseFontSupport() {
        this("Identity-H");
    }

    public BaseFontSupport(String defaultEncoding) {
        this.defaultEncoding = defaultEncoding;
    }

    public BaseFont awtToPdf(Font font) {
        boolean embed = false;
        String encoding = this.getDefaultEncoding();
        FontDefinition fdef = new FontDefinition(font.getName(), font.getSize(), font.isBold(), font.isItalic(), false, false, encoding, false);
        try {
            BaseFontRecord record = this.createBaseFont(fdef, encoding, false);
            return record.getBaseFont();
        }
        catch (Exception e) {
            throw new BaseFontCreateException("Unable to create font: " + font, e);
        }
    }

    public void close() {
        this.baseFonts.clear();
    }

    public BaseFontRecord createBaseFont(FontDefinition font, String encoding, boolean embedded) throws BaseFontCreateException {
        BaseFontRecord fontRecord;
        if (font == null) {
            throw new NullPointerException("Font definition is null.");
        }
        if (encoding == null) {
            throw new NullPointerException("Encoding is null");
        }
        String logicalName = font.getFontName();
        boolean bold = false;
        boolean italic = false;
        if (StringUtil.endsWithIgnoreCase(logicalName, "bolditalic") || font.isBold() && font.isItalic()) {
            bold = true;
            italic = true;
        } else if (StringUtil.endsWithIgnoreCase(logicalName, "bold") || font.isBold()) {
            bold = true;
        } else if (StringUtil.endsWithIgnoreCase(logicalName, "italic") || font.isItalic()) {
            italic = true;
        }
        String fontKey = font.isCourier() ? this.createCourierName(bold, italic) : (font.isSerif() ? this.createSerifName(bold, italic) : (font.isSansSerif() ? this.createSansSerifName(bold, italic) : logicalName));
        String stringEncoding = encoding;
        if (encoding.equals("Identity-H") || encoding.equals("Identity-V")) {
            stringEncoding = "utf-8";
        }
        if ((fontRecord = this.getFromCache(fontKey, encoding, embedded)) != null) {
            return fontRecord;
        }
        fontRecord = this.getFromCache(fontKey, stringEncoding, embedded);
        if (fontRecord != null) {
            return fontRecord;
        }
        BaseFontFactory factory = BaseFontFactory.getFontFactory();
        try {
            String filename = BaseFontFactory.getFontFactory().getFontfileForName(fontKey);
            if (filename != null) {
                boolean embeddedOverride = embedded;
                if (embedded && !factory.isEmbeddable(filename)) {
                    Log.warn((Object)("License of font forbids embedded usage for font: " + fontKey));
                    embeddedOverride = false;
                }
                if ((fontRecord = this.createFontFromTTF(font, filename, encoding, stringEncoding, embeddedOverride)) != null) {
                    this.putToCache(new BaseFontRecordKey(fontKey, encoding, embedded), fontRecord);
                    return fontRecord;
                }
            } else {
                BaseFont f = BaseFont.createFont((String)fontKey, (String)stringEncoding, (boolean)embedded, (boolean)false, null, null);
                if (f != null) {
                    fontRecord = new BaseFontRecord(fontKey, embedded, f);
                    this.putToCache(fontRecord);
                    return fontRecord;
                }
            }
        }
        catch (Exception e) {
            Log.warn((Object)new Log.SimpleMessage("BaseFont.createFont failed. Key = ", (Object)fontKey, (Object)": ", (Object)e.getMessage()));
        }
        try {
            fontRecord = this.getFromCache("Helvetica", stringEncoding, embedded);
            if (fontRecord != null) {
                this.putToCache(new BaseFontRecordKey(fontKey, encoding, embedded), fontRecord);
                return fontRecord;
            }
            BaseFont f = BaseFont.createFont((String)"Helvetica", (String)stringEncoding, (boolean)embedded, (boolean)false, null, null);
            if (f != null) {
                fontRecord = new BaseFontRecord("Helvetica", embedded, f);
                this.putToCache(fontRecord);
                this.putToCache(new BaseFontRecordKey(fontKey, encoding, embedded), fontRecord);
                return fontRecord;
            }
        }
        catch (Exception e) {
            Log.warn((Object)"BaseFont.createFont for FALLBACK failed.", (Exception)e);
            throw new BaseFontCreateException("Null font = " + fontKey);
        }
        throw new BaseFontCreateException("BaseFont creation failed, null font: " + fontKey);
    }

    private String createCourierName(boolean bold, boolean italic) {
        if (bold && italic) {
            return "Courier-BoldOblique";
        }
        if (bold) {
            return "Courier-Bold";
        }
        if (italic) {
            return "Courier-Oblique";
        }
        return "Courier";
    }

    private BaseFontRecord createFontFromTTF(FontDefinition font, String filename, String encoding, String stringEncoding, boolean embedded) throws IOException, DocumentException {
        BaseFont f;
        if (!StringUtil.endsWithIgnoreCase(filename, ".ttf") && !StringUtil.endsWithIgnoreCase(filename, ".ttc")) {
            return null;
        }
        String fontKey = filename;
        if (font.isBold() && font.isItalic()) {
            fontKey = String.valueOf(fontKey) + ",BoldItalic";
        } else if (font.isBold()) {
            fontKey = String.valueOf(fontKey) + ",Bold";
        } else if (font.isItalic()) {
            fontKey = String.valueOf(fontKey) + ",Italic";
        }
        BaseFontRecord fontRec = this.getFromCache(fontKey, encoding, embedded);
        if (fontRec != null) {
            return fontRec;
        }
        try {
            f = BaseFont.createFont((String)fontKey, (String)encoding, (boolean)embedded, (boolean)false, null, null);
        }
        catch (DocumentException documentException) {
            f = BaseFont.createFont((String)fontKey, (String)stringEncoding, (boolean)embedded, (boolean)false, null, null);
        }
        BaseFontRecord record = new BaseFontRecord(fontKey, embedded, f);
        this.putToCache(record);
        return record;
    }

    private String createSansSerifName(boolean bold, boolean italic) {
        if (bold && italic) {
            return "Helvetica-BoldOblique";
        }
        if (bold) {
            return "Helvetica-Bold";
        }
        if (italic) {
            return "Helvetica-Oblique";
        }
        return "Helvetica";
    }

    private String createSerifName(boolean bold, boolean italic) {
        if (bold && italic) {
            return "Times-BoldItalic";
        }
        if (bold) {
            return "Times-Bold";
        }
        if (italic) {
            return "Times-Italic";
        }
        return "Times-Roman";
    }

    public String getDefaultEncoding() {
        return this.defaultEncoding;
    }

    private String getFontName(BaseFont font) {
        String[][] names = font.getFullFontName();
        if (names.length == 1) {
            return names[0][3];
        }
        String nameExtr = null;
        int k = 0;
        while (k < names.length) {
            String[] name = names[k];
            if (name[0].equals("1") && name[1].equals("0")) {
                nameExtr = name[3];
            } else if (name[2].equals("1033")) {
                nameExtr = name[3];
                break;
            }
            ++k;
        }
        if (nameExtr == null) {
            return nameExtr;
        }
        return names[0][3];
    }

    private BaseFontRecord getFromCache(String fontKey, String encoding, boolean embedded) {
        BaseFontRecordKey key = new BaseFontRecordKey(fontKey, encoding, embedded);
        BaseFontRecord r = (BaseFontRecord)this.baseFonts.get(key);
        if (r != null) {
            return r;
        }
        return null;
    }

    public Font pdfToAwt(BaseFont font, int size) {
        String logicalName = this.getFontName(font);
        boolean bold = false;
        boolean italic = false;
        if (StringUtil.endsWithIgnoreCase(logicalName, "bolditalic")) {
            bold = true;
            italic = true;
        } else if (StringUtil.endsWithIgnoreCase(logicalName, "bold")) {
            bold = true;
        } else if (StringUtil.endsWithIgnoreCase(logicalName, "italic")) {
            italic = true;
        }
        FontDefinition fdef = new FontDefinition(logicalName, size, bold, italic, false, false, font.getEncoding(), font.isEmbedded());
        return fdef.getFont();
    }

    private void putToCache(BaseFontRecord record) {
        BaseFontRecordKey key = record.createKey();
        this.putToCache(key, record);
    }

    private void putToCache(BaseFontRecordKey key, BaseFontRecord record) {
        this.baseFonts.put(key, record);
    }

    public void setDefaultEncoding(String defaultEncoding) {
        if (defaultEncoding == null) {
            throw new NullPointerException("DefaultEncoding is null.");
        }
        this.defaultEncoding = defaultEncoding;
    }
}

