/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.report.modules.output.table.base;

import java.awt.Color;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import org.jfree.report.content.EmptyContent;
import org.jfree.report.modules.output.meta.MetaElement;
import org.jfree.report.modules.output.table.base.GenericObjectTable;
import org.jfree.report.modules.output.table.base.TableCellBackground;
import org.jfree.report.modules.output.table.base.TableRectangle;
import org.jfree.report.util.InstanceID;
import org.jfree.report.util.geom.StrictBounds;
import org.jfree.util.ObjectUtilities;

public class SheetLayout {
    private static final boolean UPPER_BOUNDS = true;
    private static final boolean LOWER_BOUNDS = false;
    private final boolean strict;
    private final TreeMap xBounds = new TreeMap();
    private final TreeMap yBounds = new TreeMap();
    private GenericObjectTable backend;
    private GenericObjectTable objectIdTable;
    private boolean lastColumnCutIsSignificant;
    private boolean lastRowCutIsSignificant;
    private long xMaxBounds;
    private long yMaxBounds;
    private Long xMaxBoundsKey;
    private Long yMaxBoundsKey;
    private transient StrictBounds workBounds;
    private Long[] yKeysArray;
    private Long[] xKeysArray;
    private static final Long[] EMPTY_LONG_ARRAY = new Long[0];
    private static final Long ZERO = new Long(0L);

    public SheetLayout(boolean strict) {
        this.strict = strict;
        this.xMaxBounds = 0L;
        this.yMaxBounds = 0L;
        this.yMaxBoundsKey = ZERO;
        this.xMaxBoundsKey = ZERO;
        this.backend = new GenericObjectTable(20, 5);
        this.objectIdTable = new GenericObjectTable(20, 5);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void add(MetaElement element) {
        boolean isAnchor;
        StrictBounds bounds = element.getBounds();
        boolean isBackground = element instanceof TableCellBackground;
        if (bounds.getWidth() == 0L && bounds.getHeight() == 0L) {
            if (!isBackground) return;
            TableCellBackground bgr = (TableCellBackground)element;
            if (!bgr.hasAnchors()) return;
            isAnchor = true;
        } else {
            isAnchor = false;
        }
        long elementRightX = bounds.getWidth() + bounds.getX();
        long elementBottomY = bounds.getHeight() + bounds.getY();
        this.ensureXMapping(bounds.getX(), false);
        this.ensureYMapping(bounds.getY(), false);
        boolean aux = !isBackground && !this.isStrict();
        this.ensureXMapping(elementRightX, aux);
        this.ensureYMapping(elementBottomY, aux);
        if (this.xMaxBounds < elementRightX) {
            this.xMaxBounds = elementRightX;
            this.xMaxBoundsKey = new Long(this.xMaxBounds);
        }
        if (this.yMaxBounds < elementBottomY) {
            this.yMaxBounds = elementBottomY;
            this.yMaxBoundsKey = new Long(this.yMaxBounds);
        }
        SortedMap ySet = this.yBounds.subMap(new Long(bounds.getY()), new Long(elementBottomY + 1L));
        SortedMap xSet = this.xBounds.subMap(new Long(bounds.getX()), new Long(elementRightX + 1L));
        Map.Entry[] yKeys = ySet.entrySet().toArray(new Map.Entry[ySet.size()]);
        Map.Entry[] xKeys = xSet.entrySet().toArray(new Map.Entry[xSet.size()]);
        if (isBackground) {
            TableCellBackground background = (TableCellBackground)element;
            if (isAnchor) {
                this.processAnchorBackground(yKeys[0], xKeys[0], background);
                return;
            } else if (yKeys.length == 1 || bounds.getHeight() == 0L) {
                this.processHorizontalLine(yKeys[0], xKeys, background);
                return;
            } else if (xKeys.length == 1 || bounds.getWidth() == 0L) {
                this.processVerticalLine(yKeys, xKeys[0], background);
                return;
            } else {
                this.processAreaBackground(yKeys, xKeys, background);
            }
            return;
        } else {
            if (!this.isContent(element) || this.isCellAreaOccupied(yKeys, xKeys)) return;
            CellReference cellReference = new CellReference(bounds);
            int x = 0;
            while (x < xKeys.length - 1) {
                BoundsCut mappedX = (BoundsCut)xKeys[x].getValue();
                int posX = mappedX.getPosition();
                int y = 0;
                while (y < yKeys.length - 1) {
                    BoundsCut mappedY = (BoundsCut)yKeys[y].getValue();
                    int posY = mappedY.getPosition();
                    this.objectIdTable.setObject(posY, posX, cellReference);
                    ++y;
                }
                ++x;
            }
        }
    }

    protected void clearObjectIdTable() {
        this.objectIdTable.clear();
        this.objectIdTable.ensureCapacity(this.backend.getRowCount(), this.backend.getColumnCount());
    }

    protected void columnInserted(long coordinate, int oldColumn, int newColumn) {
        this.backend.copyColumn(oldColumn, newColumn);
        this.objectIdTable.copyColumn(oldColumn, newColumn);
        Long coordinateKey = new Long(coordinate);
        StrictBounds cellBounds = null;
        Iterator entryIterator = this.yBounds.entrySet().iterator();
        while (entryIterator.hasNext()) {
            Map.Entry entry = entryIterator.next();
            BoundsCut bcut = (BoundsCut)entry.getValue();
            int i = bcut.getPosition();
            TableCellBackground bg = (TableCellBackground)this.backend.getObject(i, newColumn);
            if (bg == null) continue;
            StrictBounds bounds = bg.getBounds();
            cellBounds = this.computeCellBounds(cellBounds, coordinateKey, (Long)entry.getKey());
            TableCellBackground newBackground = bg.createSplittedInstance(cellBounds);
            long parentNewWidth = cellBounds.getX() - bounds.getX();
            bounds.setRect(bounds.getX(), bounds.getY(), Math.max(0L, parentNewWidth), bounds.getHeight());
            if (bg.getColorRight() != null) {
                bg.setBorderRight(null, 0.0f);
            }
            this.backend.setObject(i, newColumn, newBackground);
        }
    }

    private StrictBounds computeCellBounds(StrictBounds retval, Long x, Long y) {
        long xVal = x;
        long yVal = y;
        Long[] xCuts = this.getXCuts();
        Long[] yCuts = this.getYCuts();
        long x2Val = xCuts[this.findXPosition(xVal + 1L, true)];
        long y2Val = yCuts[this.findYPosition(yVal + 1L, true)];
        if (retval == null) {
            return new StrictBounds(xVal, yVal, x2Val - xVal, y2Val - yVal);
        }
        retval.setRect(xVal, yVal, x2Val - xVal, y2Val - yVal);
        return retval;
    }

    private void ensureXMapping(long coordinate, boolean aux) {
        Long key = new Long(coordinate);
        BoundsCut cut = (BoundsCut)this.xBounds.get(key);
        if (cut == null) {
            int result = this.xBounds.size();
            this.xBounds.put(key, new BoundsCut(key, result, aux));
            this.xKeysArray = null;
            int oldColumn = this.getPreviousColumn(coordinate);
            if (coordinate < this.xMaxBounds) {
                this.columnInserted(coordinate, oldColumn, result);
            } else {
                this.lastColumnCutIsSignificant = false;
            }
        } else if (cut.isAuxilary() && !aux) {
            cut.makePermanent();
        }
    }

    private void ensureYMapping(long coordinate, boolean aux) {
        Long key = new Long(coordinate);
        BoundsCut cut = (BoundsCut)this.yBounds.get(key);
        if (cut == null) {
            int result = this.yBounds.size();
            this.yBounds.put(key, new BoundsCut(key, result, aux));
            this.yKeysArray = null;
            int oldRow = this.getPreviousRow(coordinate);
            if (coordinate < this.yMaxBounds) {
                this.rowInserted(coordinate, oldRow, result);
            } else {
                this.lastRowCutIsSignificant = false;
            }
        } else if (cut.isAuxilary() && !aux) {
            cut.makePermanent();
        }
    }

    private int findXPosition(long coordinate, boolean upperLimit) {
        Object[] cuts = this.getXCuts();
        int pos = Arrays.binarySearch(cuts, new Long(coordinate));
        if (pos == cuts.length) {
            return cuts.length - 1;
        }
        if (-pos == cuts.length + 1) {
            return cuts.length - 1;
        }
        if (pos >= 0) {
            return pos;
        }
        if (upperLimit) {
            return -pos - 1;
        }
        return -pos - 2;
    }

    private int findYPosition(long coordinate, boolean upperLimit) {
        Object[] cuts = this.getYCuts();
        int pos = Arrays.binarySearch(cuts, new Long(coordinate));
        if (pos == cuts.length) {
            return cuts.length - 1;
        }
        if (-pos == cuts.length + 1) {
            return cuts.length - 1;
        }
        if (pos >= 0) {
            return pos;
        }
        if (upperLimit) {
            return -pos - 1;
        }
        return -pos - 2;
    }

    public long getCellWidth(int startCell, int endCell) {
        Long[] xCuts = this.getXCuts();
        long rightBorder = endCell >= xCuts.length ? this.xMaxBounds : xCuts[endCell];
        return rightBorder - xCuts[startCell];
    }

    public int getColumnCount() {
        Long[] xCuts = this.getXCuts();
        if (this.lastColumnCutIsSignificant) {
            return xCuts.length;
        }
        return xCuts.length - 1;
    }

    public CellReference getContentAt(int row, int column) {
        return (CellReference)this.objectIdTable.getObject(this.mapRow(row), this.mapColumn(column));
    }

    public TableCellBackground getElementAt(int row, int column) {
        return (TableCellBackground)this.backend.getObject(this.mapRow(row), this.mapColumn(column));
    }

    protected GenericObjectTable getLayoutBackend() {
        return this.backend;
    }

    private int getPreviousColumn(long coordinate) {
        SortedMap map = this.xBounds.headMap(new Long(coordinate));
        if (map.isEmpty()) {
            return -1;
        }
        Long lastKey = map.lastKey();
        BoundsCut cuts = (BoundsCut)map.get(lastKey);
        return cuts.getPosition();
    }

    private int getPreviousRow(long coordinate) {
        SortedMap map = this.yBounds.headMap(new Long(coordinate));
        if (map.isEmpty()) {
            return -1;
        }
        Long lastKey = map.lastKey();
        BoundsCut cuts = (BoundsCut)map.get(lastKey);
        return cuts.getPosition();
    }

    public TableCellBackground getRegionBackground(TableRectangle rect) {
        int mappedX1 = this.mapColumn(rect.getX1());
        int mappedY1 = this.mapRow(rect.getY1());
        TableCellBackground bgTopLeft = (TableCellBackground)this.backend.getObject(mappedY1, mappedX1);
        if (bgTopLeft == null) {
            return null;
        }
        if (rect.getRowSpan() == 1 && rect.getColumnSpan() == 1) {
            return bgTopLeft;
        }
        Long[] xCuts = this.getXCuts();
        Long[] yCuts = this.getYCuts();
        long x = xCuts[rect.getX1()];
        long y = yCuts[rect.getY1()];
        long width = rect.getX2() == xCuts.length ? Math.max(1L, xCuts[xCuts.length - 1] - x) : xCuts[rect.getX2()] - x;
        long height = rect.getY2() == yCuts.length ? yCuts[rect.getY2()] - y : Math.max(1L, yCuts[yCuts.length - 1] - y);
        this.workBounds.setRect(x, y, width, height);
        TableCellBackground retval = bgTopLeft.createSplittedInstance(this.workBounds);
        this.validateBackgroundColor(rect, retval);
        if (this.isVerticalBorderValid(rect, mappedX1, true)) {
            retval.setBorderLeft(bgTopLeft.getColorLeft(), bgTopLeft.getBorderSizeLeft());
        } else {
            retval.setBorderLeft(null, 0.0f);
        }
        if (this.isHorizontalBorderValid(rect, mappedY1, true)) {
            retval.setBorderTop(bgTopLeft.getColorTop(), bgTopLeft.getBorderSizeTop());
        } else {
            retval.setBorderTop(null, 0.0f);
        }
        return retval;
    }

    public int getRowCount() {
        Long[] yCuts = this.getYCuts();
        if (this.lastRowCutIsSignificant) {
            return yCuts.length;
        }
        return yCuts.length - 1;
    }

    public long getRowHeight(int row) {
        Long[] yCuts = this.getYCuts();
        if (row >= yCuts.length) {
            throw new IndexOutOfBoundsException("Row " + row + " is invalid. Max valid row is " + yCuts.length);
        }
        long bottomBorder = row + 1 < yCuts.length ? yCuts[row + 1] : this.yMaxBounds;
        return bottomBorder - yCuts[row];
    }

    public TableRectangle getTableBounds(MetaElement e, TableRectangle rect) {
        return this.getTableBounds(e.getBounds(), rect);
    }

    public TableRectangle getTableBounds(StrictBounds bounds, TableRectangle rect) {
        if (rect == null) {
            rect = new TableRectangle();
        }
        int x1 = this.findXPosition(bounds.getX(), false);
        int y1 = this.findYPosition(bounds.getY(), false);
        int x2 = this.findXPosition(bounds.getX() + bounds.getWidth(), true);
        int y2 = this.findYPosition(bounds.getY() + bounds.getHeight(), true);
        rect.setRect(x1, y1, x2, y2);
        return rect;
    }

    protected Long[] getXCuts() {
        if (this.xKeysArray != null) {
            return this.xKeysArray;
        }
        if (this.xBounds.size() == 0) {
            return EMPTY_LONG_ARRAY;
        }
        boolean isEndContained = this.xBounds.containsKey(this.xMaxBoundsKey);
        if (isEndContained) {
            this.xKeysArray = new Long[this.xBounds.size()];
        } else {
            this.xKeysArray = new Long[this.xBounds.size() + 1];
            this.xKeysArray[this.xKeysArray.length - 1] = this.xMaxBoundsKey;
        }
        this.xKeysArray = this.xBounds.keySet().toArray(this.xKeysArray);
        if (!isEndContained) {
            this.xKeysArray[this.xKeysArray.length - 1] = this.xMaxBoundsKey;
        }
        return this.xKeysArray;
    }

    protected Long[] getYCuts() {
        if (this.yKeysArray != null) {
            return this.yKeysArray;
        }
        if (this.yBounds.size() == 0) {
            return EMPTY_LONG_ARRAY;
        }
        boolean isEndContained = this.yBounds.containsKey(this.yMaxBoundsKey);
        this.yKeysArray = isEndContained ? new Long[this.yBounds.size()] : new Long[this.yBounds.size() + 1];
        this.yKeysArray = this.yBounds.keySet().toArray(this.yKeysArray);
        if (!isEndContained) {
            this.yKeysArray[this.yKeysArray.length - 1] = this.yMaxBoundsKey;
        }
        return this.yKeysArray;
    }

    public long getYPosition(int row) {
        Long[] yCuts = this.getYCuts();
        if (row >= yCuts.length) {
            throw new IndexOutOfBoundsException("Row " + row + " is invalid. Max valud row is " + yCuts.length);
        }
        return yCuts[row];
    }

    private boolean isCellAreaOccupied(Map.Entry[] yKeys, Map.Entry[] xKeys) {
        if (xKeys.length < 2 || yKeys.length < 2) {
            return false;
        }
        int x = 0;
        while (x < xKeys.length - 1) {
            BoundsCut mappedX = (BoundsCut)xKeys[x].getValue();
            int posX = mappedX.getPosition();
            int y = 0;
            while (y < yKeys.length - 1) {
                BoundsCut mappedY = (BoundsCut)yKeys[y].getValue();
                int posY = mappedY.getPosition();
                Object o = this.objectIdTable.getObject(posY, posX);
                if (o != null) {
                    return true;
                }
                ++y;
            }
            ++x;
        }
        return false;
    }

    protected boolean isContent(MetaElement element) {
        return !(element.getContent() instanceof EmptyContent);
    }

    public boolean isEmpty() {
        return this.backend.getColumnCount() == 0 && this.backend.getRowCount() == 0 && this.xMaxBounds == 0L && this.yMaxBounds == 0L;
    }

    private boolean isHorizontalBorderValid(TableRectangle rect, int mappedY, boolean top) {
        Color color = null;
        float border = 0.0f;
        int col = rect.getX1();
        while (col < rect.getX2()) {
            int mappedCol = this.mapColumn(col);
            TableCellBackground background = (TableCellBackground)this.backend.getObject(mappedY, mappedCol);
            if (background == null) {
                return false;
            }
            if (top) {
                if (color == null) {
                    color = background.getColorTop();
                    border = background.getBorderSizeTop();
                } else if (!color.equals(background.getColorTop()) || border != background.getBorderSizeTop()) {
                    return false;
                }
            } else if (color == null) {
                color = background.getColorBottom();
                border = background.getBorderSizeBottom();
            } else if (!color.equals(background.getColorBottom()) || border != background.getBorderSizeBottom()) {
                return false;
            }
            ++col;
        }
        return true;
    }

    public boolean isStrict() {
        return this.strict;
    }

    private boolean isVerticalBorderValid(TableRectangle rect, int mappedX, boolean left) {
        Color color = null;
        float border = 0.0f;
        int row = rect.getY1();
        while (row < rect.getY2()) {
            int mappedRow = this.mapRow(row);
            TableCellBackground background = (TableCellBackground)this.backend.getObject(mappedRow, mappedX);
            if (background == null) {
                return false;
            }
            if (left) {
                if (color == null) {
                    color = background.getColorLeft();
                    border = background.getBorderSizeLeft();
                } else if (!color.equals(background.getColorLeft()) || border != background.getBorderSizeLeft()) {
                    return false;
                }
            } else if (color == null) {
                color = background.getColorRight();
                border = background.getBorderSizeRight();
            } else if (!color.equals(background.getColorRight()) || border != background.getBorderSizeRight()) {
                return false;
            }
            ++row;
        }
        return true;
    }

    protected int mapColumn(int xCutIndex) {
        Long[] xcuts = this.getXCuts();
        try {
            BoundsCut boundsCut = (BoundsCut)this.xBounds.get(xcuts[xCutIndex]);
            return boundsCut.getPosition();
        }
        catch (NullPointerException nullPointerException) {
            throw new IllegalStateException("There is no column at " + xcuts[xCutIndex]);
        }
    }

    protected int mapRow(int yCutIndex) {
        Long[] ycuts = this.getYCuts();
        try {
            BoundsCut boundsCut = (BoundsCut)this.yBounds.get(ycuts[yCutIndex]);
            return boundsCut.getPosition();
        }
        catch (NullPointerException nullPointerException) {
            throw new IllegalStateException("There is no row at " + ycuts[yCutIndex]);
        }
    }

    public void pageCompleted() {
        this.removeAuxilaryBounds();
        this.clearObjectIdTable();
    }

    private void performMergeCellBackground(int currentRowIndex, int currentColumnIndex, TableCellBackground background, StrictBounds bounds) {
        TableCellBackground oldBackground = (TableCellBackground)this.backend.getObject(currentRowIndex, currentColumnIndex);
        TableCellBackground newBackground = oldBackground == null ? background.normalize(bounds) : oldBackground.merge(background, bounds);
        this.backend.setObject(currentRowIndex, currentColumnIndex, newBackground);
    }

    private void processAnchorBackground(Map.Entry yKey, Map.Entry xKey, TableCellBackground background) {
        BoundsCut currentRowValue = (BoundsCut)yKey.getValue();
        int currentRowIndex = currentRowValue.getPosition();
        BoundsCut currentColumnValue = (BoundsCut)xKey.getValue();
        int currentColumnIndex = currentColumnValue.getPosition();
        this.workBounds = this.computeCellBounds(this.workBounds, (Long)xKey.getKey(), (Long)yKey.getKey());
        this.performMergeCellBackground(currentRowIndex, currentColumnIndex, background, this.workBounds);
    }

    private void processAreaBackground(Map.Entry[] yKeys, Map.Entry[] xKeys, TableCellBackground background) {
        boolean hasRightBorders = background.getColorRight() != null;
        boolean hasBottomBorders = background.getColorBottom() != null;
        int yLength = hasBottomBorders ? yKeys.length : yKeys.length - 1;
        int xLength = hasRightBorders ? xKeys.length : xKeys.length - 1;
        int y = 0;
        while (y < yLength) {
            BoundsCut currentRowValue = (BoundsCut)yKeys[y].getValue();
            int currentRowIndex = currentRowValue.getPosition();
            int x = 0;
            while (x < xLength) {
                BoundsCut currentColumnValue = (BoundsCut)xKeys[x].getValue();
                int currentColumnIndex = currentColumnValue.getPosition();
                this.workBounds = this.computeCellBounds(this.workBounds, (Long)xKeys[x].getKey(), (Long)yKeys[y].getKey());
                this.performMergeCellBackground(currentRowIndex, currentColumnIndex, background, this.workBounds);
                ++x;
            }
            ++y;
        }
        if (hasRightBorders && xKeys[xKeys.length - 1].getKey().equals(this.xMaxBoundsKey)) {
            this.lastColumnCutIsSignificant = true;
        }
        if (hasBottomBorders && yKeys[yKeys.length - 1].getKey().equals(this.yMaxBoundsKey)) {
            this.lastRowCutIsSignificant = true;
        }
    }

    private void processHorizontalLine(Map.Entry yKey, Map.Entry[] xKeys, TableCellBackground background) {
        BoundsCut currentRowValue = (BoundsCut)yKey.getValue();
        int currentRowIndex = currentRowValue.getPosition();
        int x = 0;
        while (x < xKeys.length - 1) {
            BoundsCut currentColumnValue = (BoundsCut)xKeys[x].getValue();
            int currentColumnIndex = currentColumnValue.getPosition();
            this.workBounds = this.computeCellBounds(this.workBounds, (Long)xKeys[x].getKey(), (Long)yKey.getKey());
            this.performMergeCellBackground(currentRowIndex, currentColumnIndex, background, this.workBounds);
            ++x;
        }
        if (yKey.getKey().equals(this.yMaxBoundsKey)) {
            this.lastRowCutIsSignificant = true;
        }
    }

    private void processVerticalLine(Map.Entry[] yKeys, Map.Entry xKey, TableCellBackground background) {
        BoundsCut currentColumnValue = (BoundsCut)xKey.getValue();
        int currentColumnIndex = currentColumnValue.getPosition();
        int y = 0;
        while (y < yKeys.length - 1) {
            BoundsCut currentRowValue = (BoundsCut)yKeys[y].getValue();
            int currentRowIndex = currentRowValue.getPosition();
            this.workBounds = this.computeCellBounds(this.workBounds, (Long)xKey.getKey(), (Long)yKeys[y].getKey());
            this.performMergeCellBackground(currentRowIndex, currentColumnIndex, background, this.workBounds);
            ++y;
        }
        if (xKey.getKey().equals(this.xMaxBoundsKey)) {
            this.lastColumnCutIsSignificant = true;
        }
    }

    protected void removeAuxilaryBounds() {
        ArrayList<BoundsCut> removedCuts = new ArrayList<BoundsCut>();
        Iterator itX = this.xBounds.entrySet().iterator();
        while (itX.hasNext()) {
            Map.Entry entry = itX.next();
            BoundsCut cut = (BoundsCut)entry.getValue();
            if (!cut.isAuxilary()) continue;
            itX.remove();
            removedCuts.add(cut);
            this.xKeysArray = null;
        }
        int i = 0;
        while (i < removedCuts.size()) {
            BoundsCut boundsCut = (BoundsCut)removedCuts.get(i);
            int previousCol = this.getPreviousColumn(boundsCut.getCoordinate());
            int col = boundsCut.getPosition();
            int row = 0;
            while (row < this.backend.getRowCount()) {
                TableCellBackground leftBg = (TableCellBackground)this.backend.getObject(row, previousCol);
                TableCellBackground rightBg = (TableCellBackground)this.backend.getObject(row, col);
                if (leftBg != null && rightBg != null) {
                    StrictBounds leftBounds = leftBg.getBounds();
                    StrictBounds newBounds = rightBg.getBounds().createUnion(leftBounds);
                    TableCellBackground unionBg = leftBg.createSplittedInstance(newBounds);
                    unionBg.setBorderRight(rightBg.getColorRight(), rightBg.getBorderSizeRight());
                    this.backend.setObject(row, previousCol, unionBg);
                    this.backend.setObject(row, col, null);
                }
                ++row;
            }
            ++i;
        }
        removedCuts.clear();
        Iterator itY = this.yBounds.entrySet().iterator();
        while (itY.hasNext()) {
            Map.Entry entry = itY.next();
            BoundsCut cut = (BoundsCut)entry.getValue();
            if (!cut.isAuxilary()) continue;
            itY.remove();
            removedCuts.add(cut);
            this.yKeysArray = null;
        }
        int i2 = 0;
        while (i2 < removedCuts.size()) {
            BoundsCut boundsCut = (BoundsCut)removedCuts.get(i2);
            int previousRow = this.getPreviousRow(boundsCut.getCoordinate());
            int row = boundsCut.getPosition();
            int col = 0;
            while (col < this.backend.getColumnCount()) {
                TableCellBackground topBg = (TableCellBackground)this.backend.getObject(previousRow, col);
                TableCellBackground bottomBg = (TableCellBackground)this.backend.getObject(row, col);
                if (topBg != null && bottomBg != null) {
                    StrictBounds topBounds = topBg.getBounds();
                    StrictBounds newBounds = bottomBg.getBounds().createUnion(topBounds);
                    TableCellBackground unionBg = topBg.createSplittedInstance(newBounds);
                    unionBg.setBorderBottom(bottomBg.getColorBottom(), bottomBg.getBorderSizeBottom());
                    this.backend.setObject(previousRow, col, unionBg);
                    this.backend.setObject(row, col, null);
                }
                ++col;
            }
            ++i2;
        }
    }

    protected void rowInserted(long coordinate, int oldRow, int newRow) {
        this.backend.copyRow(oldRow, newRow);
        this.objectIdTable.copyRow(oldRow, newRow);
        Long coordinateKey = new Long(coordinate);
        StrictBounds cellBounds = null;
        Iterator entryIterator = this.xBounds.entrySet().iterator();
        while (entryIterator.hasNext()) {
            Map.Entry entry = entryIterator.next();
            BoundsCut bcut = (BoundsCut)entry.getValue();
            int i = bcut.getPosition();
            TableCellBackground bg = (TableCellBackground)this.backend.getObject(newRow, i);
            if (bg == null) continue;
            StrictBounds bounds = bg.getBounds();
            cellBounds = this.computeCellBounds(cellBounds, (Long)entry.getKey(), coordinateKey);
            TableCellBackground newBackground = bg.createSplittedInstance(cellBounds);
            long parentNewHeight = cellBounds.getY() - bounds.getY();
            bounds.setRect(bounds.getX(), bounds.getY(), bounds.getWidth(), Math.max(0L, parentNewHeight));
            if (bg.getColorBottom() != null) {
                bg.setBorderBottom(null, 0.0f);
            }
            this.backend.setObject(newRow, i, newBackground);
        }
    }

    private void validateBackgroundColor(TableRectangle rect, TableCellBackground retval) {
        int ty = rect.getY1();
        while (ty < rect.getY2()) {
            int tx = rect.getX1();
            while (tx < rect.getX2()) {
                int mappedLoopX1 = this.mapColumn(tx);
                int mappedLoopY1 = this.mapRow(ty);
                TableCellBackground bg = (TableCellBackground)this.backend.getObject(mappedLoopY1, mappedLoopX1);
                if (bg == null) {
                    retval.setColor(null);
                    return;
                }
                if (!ObjectUtilities.equal((Object)retval.getColor(), (Object)bg.getColor())) {
                    retval.setColor(null);
                    return;
                }
                ++tx;
            }
            ++ty;
        }
    }

    private static class BoundsCut {
        private long coordinate;
        private int position;
        private boolean auxilary;

        public BoundsCut(long coordinate, int position, boolean auxilary) {
            this.coordinate = coordinate;
            this.position = position;
            this.auxilary = auxilary;
        }

        public long getCoordinate() {
            return this.coordinate;
        }

        public int getPosition() {
            return this.position;
        }

        public boolean isAuxilary() {
            return this.auxilary;
        }

        public void makePermanent() {
            this.auxilary = false;
        }

        public String toString() {
            return "org.jfree.report.modules.output.table.base.SheetLayout.BoundsCut{auxilary=" + this.auxilary + ", position=" + this.position + "}";
        }
    }

    public static class CellReference {
        private StrictBounds bounds;
        private InstanceID contentID = new InstanceID();

        public CellReference(StrictBounds bounds) {
            this.bounds = (StrictBounds)bounds.clone();
        }

        public StrictBounds getBounds() {
            return this.bounds;
        }

        public InstanceID getContentID() {
            return this.contentID;
        }
    }
}

