/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.report.modules.output.table.base;

import java.util.ArrayList;
import org.jfree.report.modules.output.table.base.SheetLayout;

public class SheetLayoutCollection {
    private ArrayList pageLayouts = new ArrayList();
    private SheetLayout globalLayout;
    private boolean useGlobalLayout;

    public SheetLayoutCollection(boolean useGlobalLayout) {
        this.useGlobalLayout = useGlobalLayout;
        this.globalLayout = null;
    }

    public void addLayout(SheetLayout bounds) {
        if (this.isGlobalLayout()) {
            this.globalLayout = bounds;
        } else {
            this.pageLayouts.add(bounds);
        }
    }

    public SheetLayout getLayoutForPage(int page) {
        if (this.isGlobalLayout()) {
            if (this.globalLayout == null) {
                throw new IllegalStateException("No global layout defined.");
            }
            return this.globalLayout;
        }
        SheetLayout layout = (SheetLayout)this.pageLayouts.get(page);
        if (layout == null) {
            throw new IllegalStateException("No sheet layout for page " + page);
        }
        return layout;
    }

    public int getPageCount() {
        if (!this.isGlobalLayout()) {
            return this.pageLayouts.size();
        }
        if (this.globalLayout == null) {
            return 0;
        }
        return 1;
    }

    public boolean isGlobalLayout() {
        return this.useGlobalLayout;
    }
}

