/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.report.modules.output.table.base;

import java.awt.Color;
import java.util.AbstractCollection;
import java.util.HashSet;
import org.jfree.report.Anchor;
import org.jfree.report.content.Content;
import org.jfree.report.modules.output.meta.MetaElement;
import org.jfree.report.style.ElementStyleSheet;
import org.jfree.report.util.geom.StrictBounds;

public class TableCellBackground
extends MetaElement
implements Cloneable {
    private HashSet anchors;
    private float borderSizeTop;
    private float borderSizeBottom;
    private float borderSizeLeft;
    private float borderSizeRight;
    private Color colorTop;
    private Color colorLeft;
    private Color colorBottom;
    private Color colorRight;
    private Color color;
    private static final Anchor[] EMPTY_ANCHOR_ARRAY = new Anchor[0];

    public TableCellBackground(Content elementContent, ElementStyleSheet style, Color color) {
        super(elementContent, style);
        this.color = color;
    }

    public void addAnchor(Anchor anchor) {
        if (anchor == null) {
            throw new NullPointerException();
        }
        if (this.anchors == null) {
            this.anchors = new HashSet();
        }
        this.anchors.add(anchor);
    }

    private static Color addColor(Color base, Color paint) {
        if (paint.getAlpha() == 255) {
            return paint;
        }
        float baseAlpha = (float)base.getAlpha() / 255.0f;
        float paintAlpha = (float)paint.getAlpha() / 255.0f;
        float effectiveAlpha = 1.0f - baseAlpha * paintAlpha;
        double deltaAlpha = 1.0 - (double)effectiveAlpha;
        int red = (int)((double)base.getRed() * deltaAlpha + (double)((float)paint.getRed() * effectiveAlpha));
        int green = (int)((double)base.getGreen() * deltaAlpha + (double)((float)paint.getGreen() * effectiveAlpha));
        int blue = (int)((double)base.getBlue() * deltaAlpha + (double)((float)paint.getBlue() * effectiveAlpha));
        return new Color((float)red, (float)green, (float)blue, effectiveAlpha * 255.0f);
    }

    public Object clone() throws CloneNotSupportedException {
        TableCellBackground tb = (TableCellBackground)super.clone();
        if (this.anchors != null) {
            tb.anchors = (HashSet)this.anchors.clone();
        }
        return tb;
    }

    public TableCellBackground createSplittedInstance(StrictBounds bounds) {
        try {
            StrictBounds originalBounds = this.getBounds();
            TableCellBackground bg = (TableCellBackground)this.clone();
            bg.setBounds((StrictBounds)bounds.clone());
            if (!bounds.contains(originalBounds.getX(), originalBounds.getY()) && bg.anchors != null) {
                bg.anchors.clear();
            }
            long orgX2 = originalBounds.getX() + originalBounds.getWidth();
            long orgY2 = originalBounds.getY() + originalBounds.getHeight();
            if (bounds.getX() > orgX2 || bounds.getY() > orgY2 || bounds.getX() == orgX2 && bounds.getY() == orgY2) {
                bg.setBorderTop(null, 0.0f);
                bg.setBorderBottom(null, 0.0f);
                bg.setBorderLeft(null, 0.0f);
                bg.setBorderRight(null, 0.0f);
                bg.setColor(null);
            } else {
                if (bg.getTopBorderPos() != this.getTopBorderPos()) {
                    bg.setBorderTop(null, 0.0f);
                }
                if (bg.getLeftBorderPos() != this.getLeftBorderPos()) {
                    bg.setBorderLeft(null, 0.0f);
                }
                bg.setBorderRight(null, 0.0f);
                bg.setBorderBottom(null, 0.0f);
            }
            return bg;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new IllegalStateException("Clone caused an unexpected error.");
        }
    }

    public boolean equals(Object o) {
        block40: {
            block39: {
                boolean bl;
                block38: {
                    TableCellBackground tableCellBackground;
                    block37: {
                        block36: {
                            block35: {
                                boolean bl2;
                                block34: {
                                    block33: {
                                        block32: {
                                            block31: {
                                                boolean bl3;
                                                block30: {
                                                    block29: {
                                                        block28: {
                                                            block27: {
                                                                boolean bl4;
                                                                block26: {
                                                                    block25: {
                                                                        block24: {
                                                                            block23: {
                                                                                boolean bl5;
                                                                                block22: {
                                                                                    block21: {
                                                                                        if (this == o) {
                                                                                            return true;
                                                                                        }
                                                                                        if (!(o instanceof TableCellBackground)) {
                                                                                            return false;
                                                                                        }
                                                                                        tableCellBackground = (TableCellBackground)o;
                                                                                        if (this.borderSizeBottom != tableCellBackground.borderSizeBottom) {
                                                                                            return false;
                                                                                        }
                                                                                        if (this.borderSizeLeft != tableCellBackground.borderSizeLeft) {
                                                                                            return false;
                                                                                        }
                                                                                        if (this.borderSizeRight != tableCellBackground.borderSizeRight) {
                                                                                            return false;
                                                                                        }
                                                                                        if (this.borderSizeTop != tableCellBackground.borderSizeTop) {
                                                                                            return false;
                                                                                        }
                                                                                        if (this.color == null) break block21;
                                                                                        bl5 = this.color.equals(tableCellBackground.color) ^ true;
                                                                                        break block22;
                                                                                    }
                                                                                    if (tableCellBackground.color != null) break block23;
                                                                                    bl5 = false;
                                                                                }
                                                                                if (!bl5) break block24;
                                                                            }
                                                                            return false;
                                                                        }
                                                                        if (this.colorBottom == null) break block25;
                                                                        bl4 = this.colorBottom.equals(tableCellBackground.colorBottom) ^ true;
                                                                        break block26;
                                                                    }
                                                                    if (tableCellBackground.colorBottom != null) break block27;
                                                                    bl4 = false;
                                                                }
                                                                if (!bl4) break block28;
                                                            }
                                                            return false;
                                                        }
                                                        if (this.colorLeft == null) break block29;
                                                        bl3 = this.colorLeft.equals(tableCellBackground.colorLeft) ^ true;
                                                        break block30;
                                                    }
                                                    if (tableCellBackground.colorLeft != null) break block31;
                                                    bl3 = false;
                                                }
                                                if (!bl3) break block32;
                                            }
                                            return false;
                                        }
                                        if (this.colorRight == null) break block33;
                                        bl2 = this.colorRight.equals(tableCellBackground.colorRight) ^ true;
                                        break block34;
                                    }
                                    if (tableCellBackground.colorRight != null) break block35;
                                    bl2 = false;
                                }
                                if (!bl2) break block36;
                            }
                            return false;
                        }
                        if (this.colorTop == null) break block37;
                        bl = this.colorTop.equals(tableCellBackground.colorTop) ^ true;
                        break block38;
                    }
                    if (tableCellBackground.colorTop != null) break block39;
                    bl = false;
                }
                if (!bl) break block40;
            }
            return false;
        }
        return true;
    }

    public Anchor[] getAnchors() {
        if (this.anchors == null) {
            return EMPTY_ANCHOR_ARRAY;
        }
        return ((AbstractCollection)this.anchors).toArray(new Anchor[this.anchors.size()]);
    }

    public float getBorderSizeBottom() {
        return this.borderSizeBottom;
    }

    public float getBorderSizeLeft() {
        return this.borderSizeLeft;
    }

    public float getBorderSizeRight() {
        return this.borderSizeRight;
    }

    public float getBorderSizeTop() {
        return this.borderSizeTop;
    }

    public long getBottomBorderPos() {
        StrictBounds bounds = this.getBounds();
        return bounds.getY() + bounds.getHeight();
    }

    public Color getColor() {
        return this.color;
    }

    public Color getColorBottom() {
        return this.colorBottom;
    }

    public Color getColorLeft() {
        return this.colorLeft;
    }

    public Color getColorRight() {
        return this.colorRight;
    }

    public Color getColorTop() {
        return this.colorTop;
    }

    public long getLeftBorderPos() {
        StrictBounds cellBounds = this.getBounds();
        return cellBounds.getX();
    }

    public long getRightBorderPos() {
        StrictBounds cellBounds = this.getBounds();
        return cellBounds.getX() + cellBounds.getWidth();
    }

    public long getTopBorderPos() {
        StrictBounds cellBounds = this.getBounds();
        return cellBounds.getY();
    }

    public boolean hasAnchors() {
        if (this.anchors == null) {
            return false;
        }
        return !this.anchors.isEmpty();
    }

    public int hashCode() {
        int result = Float.floatToIntBits(this.borderSizeTop);
        result = 29 * result + Float.floatToIntBits(this.borderSizeBottom);
        result = 29 * result + Float.floatToIntBits(this.borderSizeLeft);
        result = 29 * result + Float.floatToIntBits(this.borderSizeRight);
        result = 29 * result + (this.colorTop != null ? this.colorTop.hashCode() : 0);
        result = 29 * result + (this.colorLeft != null ? this.colorLeft.hashCode() : 0);
        result = 29 * result + (this.colorBottom != null ? this.colorBottom.hashCode() : 0);
        result = 29 * result + (this.colorRight != null ? this.colorRight.hashCode() : 0);
        result = 29 * result + (this.color != null ? this.color.hashCode() : 0);
        return result;
    }

    public TableCellBackground merge(TableCellBackground background, StrictBounds cellBounds) {
        StrictBounds bounds = this.getBounds();
        StrictBounds backgroundBounds = background.getBounds();
        boolean thisIsALine = bounds.getHeight() == 0L || bounds.getWidth() == 0L;
        boolean otherIsALine = backgroundBounds.getHeight() == 0L || backgroundBounds.getWidth() == 0L;
        TableCellBackground merged = background.normalize(cellBounds);
        Color orgColor = this.getColor();
        if (!otherIsALine && !thisIsALine) {
            if (orgColor == null) {
                merged.setColor(background.getColor());
            } else if (background.getColor() != null) {
                Color color = TableCellBackground.addColor(orgColor, background.getColor());
                merged.setColor(color);
            } else {
                merged.setColor(orgColor);
            }
        } else if (!thisIsALine) {
            merged.setColor(orgColor);
        }
        if (cellBounds.contains(backgroundBounds.getX(), backgroundBounds.getY()) && background.anchors != null) {
            if (merged.anchors == null) {
                merged.anchors = new HashSet(background.anchors);
            } else {
                merged.anchors.addAll(background.anchors);
            }
        }
        if (merged.getColorTop() == null) {
            merged.setBorderTop(this.getColorTop(), this.getBorderSizeTop());
        }
        if (merged.getColorLeft() == null) {
            merged.setBorderLeft(this.getColorLeft(), this.getBorderSizeLeft());
        }
        return merged;
    }

    public TableCellBackground normalize(StrictBounds bounds) {
        try {
            StrictBounds originalBounds = this.getBounds();
            TableCellBackground bg = (TableCellBackground)this.clone();
            bg.setBounds((StrictBounds)bounds.clone());
            if (!bounds.contains(originalBounds.getX(), originalBounds.getY()) && bg.anchors != null) {
                bg.anchors.clear();
            }
            long orgX2 = originalBounds.getX() + originalBounds.getWidth();
            long orgY2 = originalBounds.getY() + originalBounds.getHeight();
            if (bounds.getX() > orgX2 || bounds.getY() > orgY2 || bounds.getX() == orgX2 && bounds.getY() == orgY2) {
                bg.setBorderTop(null, 0.0f);
                bg.setBorderBottom(null, 0.0f);
                bg.setBorderLeft(null, 0.0f);
                bg.setBorderRight(null, 0.0f);
                bg.setColor(null);
            } else if (bounds.getX() == orgX2) {
                bg.setBorderTop(null, 0.0f);
                bg.setBorderBottom(null, 0.0f);
                if (bg.getColorLeft() == null) {
                    bg.setBorderLeft(this.getColorRight(), this.getBorderSizeRight());
                }
                bg.setBorderRight(null, 0.0f);
                bg.setColor(null);
            } else if (bounds.getY() == orgY2) {
                if (bg.getColorTop() == null) {
                    bg.setBorderTop(this.getColorBottom(), this.getBorderSizeBottom());
                }
                bg.setBorderBottom(null, 0.0f);
                bg.setBorderLeft(null, 0.0f);
                bg.setBorderRight(null, 0.0f);
                bg.setColor(null);
            } else {
                if (bg.getTopBorderPos() != this.getTopBorderPos()) {
                    bg.setBorderTop(null, 0.0f);
                }
                if (bg.getLeftBorderPos() != this.getLeftBorderPos()) {
                    bg.setBorderLeft(null, 0.0f);
                }
                bg.setBorderRight(null, 0.0f);
                bg.setBorderBottom(null, 0.0f);
            }
            return bg;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new IllegalStateException("Clone caused an unexpected error.");
        }
    }

    public void setBorderBottom(Color color, float size) {
        if (size == 0.0f) {
            this.colorBottom = null;
            this.borderSizeBottom = 0.0f;
        } else {
            this.colorBottom = color;
            this.borderSizeBottom = size;
        }
    }

    public void setBorderLeft(Color color, float size) {
        if (size == 0.0f) {
            this.colorLeft = null;
            this.borderSizeLeft = 0.0f;
        } else {
            this.colorLeft = color;
            this.borderSizeLeft = size;
        }
    }

    public void setBorderRight(Color color, float size) {
        if (size == 0.0f) {
            this.colorRight = null;
            this.borderSizeRight = 0.0f;
        } else {
            this.colorRight = color;
            this.borderSizeRight = size;
        }
    }

    public void setBorderTop(Color color, float size) {
        if (size == 0.0f) {
            this.colorTop = null;
            this.borderSizeTop = 0.0f;
        } else {
            this.colorTop = color;
            this.borderSizeTop = size;
        }
    }

    protected void setColor(Color color) {
        this.color = color;
    }

    public String toString() {
        StringBuffer b = new StringBuffer();
        b.append("TableCellBackground={bounds=");
        b.append(this.getBounds());
        b.append(", color=");
        b.append(this.color);
        b.append(", colorTop=");
        b.append(this.colorTop);
        b.append(", widthTop=");
        b.append(this.borderSizeTop);
        b.append(", colorLeft=");
        b.append(this.colorLeft);
        b.append(", widthLeft=");
        b.append(this.borderSizeLeft);
        b.append(", colorBottom=");
        b.append(this.colorBottom);
        b.append(", widthBottom=");
        b.append(this.borderSizeBottom);
        b.append(", colorRight=");
        b.append(this.colorRight);
        b.append(", widthRight=");
        b.append(this.borderSizeRight);
        b.append("}");
        return b.toString();
    }
}

