/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.report.modules.output.table.base;

import org.jfree.report.Band;
import org.jfree.report.ReportProcessingException;
import org.jfree.report.content.ContentCreationException;
import org.jfree.report.event.PageEventListener;
import org.jfree.report.event.PrepareEventListener;
import org.jfree.report.event.ReportEvent;
import org.jfree.report.function.AbstractFunction;
import org.jfree.report.function.Expression;
import org.jfree.report.function.FunctionProcessingException;
import org.jfree.report.layout.BandLayoutManagerUtil;
import org.jfree.report.layout.LayoutSupport;
import org.jfree.report.modules.output.meta.MetaBand;
import org.jfree.report.modules.output.meta.MetaBandProducer;
import org.jfree.report.modules.output.support.pagelayout.SimplePageLayoutDelegate;
import org.jfree.report.modules.output.support.pagelayout.SimplePageLayoutWorker;
import org.jfree.report.modules.output.table.base.TableCreator;
import org.jfree.report.modules.output.table.base.TableWriterCursor;
import org.jfree.report.states.ReportState;
import org.jfree.report.style.BandStyleKeys;
import org.jfree.report.util.geom.StrictBounds;

public strictfp class TableWriter
extends AbstractFunction
implements PageEventListener,
SimplePageLayoutWorker,
PrepareEventListener {
    public static final int OUTPUT_LEVEL = -1;
    private ReportEvent currentEvent;
    private TableWriterCursor cursor;
    private long maxWidth;
    private int depLevel;
    private boolean inEndPage;
    private SimplePageLayoutDelegate delegate;
    private TableCreator tableCreator;
    private MetaBandProducer metaBandProducer;
    private LayoutSupport layoutSupport;

    public TableWriter(MetaBandProducer metaBandProducer) {
        this.setDependencyLevel(-1);
        this.delegate = new SimplePageLayoutDelegate(this);
        this.metaBandProducer = metaBandProducer;
        this.layoutSupport = metaBandProducer.getLayoutSupport();
    }

    private void clearCurrentEvent() {
        this.currentEvent = null;
    }

    public Object clone() throws CloneNotSupportedException {
        TableWriter clone = (TableWriter)super.clone();
        clone.delegate = (SimplePageLayoutDelegate)this.delegate.clone();
        clone.delegate.setWorker(clone);
        return clone;
    }

    private StrictBounds doLayout(Band band) {
        long width = this.getMaxWidth();
        long height = Integer.MAX_VALUE;
        StrictBounds bounds = BandLayoutManagerUtil.doLayout(band, this.getLayoutSupport(), width, Integer.MAX_VALUE);
        this.getCurrentEvent().getState().fireLayoutCompleteEvent(band, this.getCurrentEvent().getType());
        return bounds;
    }

    private void doPrint(StrictBounds bounds, Band band) throws ContentCreationException, ReportProcessingException {
        MetaBand metaBand = this.metaBandProducer.createBand(band, false);
        if (metaBand == null) {
            this.getCursor().advance(bounds.getHeight());
            return;
        }
        this.tableCreator.processBand(metaBand);
        this.getCursor().advance(bounds.getHeight());
        this.getCurrentEvent().getState().fireOutputCompleteEvent(band, this.getCurrentEvent().getType());
        this.tableCreator.flush();
    }

    private void endPage() throws ReportProcessingException {
        if (this.inEndPage) {
            throw new IllegalStateException("Already in startPage or endPage");
        }
        this.inEndPage = true;
        ReportEvent currentEvent = this.getCurrentEvent();
        ReportState cEventState = this.getCurrentEvent().getState();
        cEventState.firePageFinishedEvent();
        if (cEventState.isErrorOccured()) {
            throw new ReportProcessingException("An error occured while processing the page start - aborting");
        }
        cEventState.nextPage();
        this.setCurrentEvent(currentEvent);
        this.inEndPage = false;
    }

    public ReportEvent getCurrentEvent() {
        return this.currentEvent;
    }

    private TableWriterCursor getCursor() {
        return this.cursor;
    }

    public long getCursorPosition() {
        return this.getCursor().getY();
    }

    public int getDependencyLevel() {
        return this.depLevel;
    }

    public Expression getInstance() {
        TableWriter tw = (TableWriter)super.getInstance();
        tw.delegate = new SimplePageLayoutDelegate(tw);
        return tw;
    }

    public LayoutSupport getLayoutSupport() {
        return this.layoutSupport;
    }

    public long getMaxWidth() {
        return this.maxWidth;
    }

    public long getReservedSpace() {
        return 0L;
    }

    public TableCreator getTableCreator() {
        return this.tableCreator;
    }

    public long getTopContentPosition() {
        return 0L;
    }

    public Object getValue() {
        return this;
    }

    public void groupFinished(ReportEvent event) {
        this.setCurrentEvent(event);
        this.delegate.groupFinished(event);
        this.clearCurrentEvent();
    }

    public void groupStarted(ReportEvent event) {
        this.setCurrentEvent(event);
        this.delegate.groupStarted(event);
        this.clearCurrentEvent();
    }

    private boolean isInEndPage() {
        return this.inEndPage;
    }

    public boolean isPageEmpty() {
        if (this.tableCreator == null) {
            throw new IllegalStateException("tableCreator is null." + this.toString());
        }
        return this.tableCreator.isEmpty();
    }

    public boolean isPageEnded() {
        return false;
    }

    public boolean isWatermarkSupported() {
        return false;
    }

    public void itemsAdvanced(ReportEvent event) {
        this.setCurrentEvent(event);
        this.delegate.itemsAdvanced(event);
        this.clearCurrentEvent();
    }

    public void itemsFinished(ReportEvent event) {
        this.setCurrentEvent(event);
        this.delegate.itemsFinished(event);
        this.clearCurrentEvent();
    }

    public void itemsStarted(ReportEvent event) {
        this.setCurrentEvent(event);
        this.delegate.itemsStarted(event);
        this.clearCurrentEvent();
    }

    public void pageCanceled(ReportEvent event) {
    }

    public void pageFinished(ReportEvent event) {
        try {
            this.setCurrentEvent(event);
            this.delegate.pageFinished(event);
            this.tableCreator.endTable();
            this.clearCurrentEvent();
        }
        catch (ReportProcessingException e) {
            throw new FunctionProcessingException("TableWriter", (Exception)((Object)e));
        }
    }

    public void pageRolledBack(ReportEvent event) {
    }

    public void pageStarted(ReportEvent event) {
        try {
            this.setCurrentEvent(event);
            this.tableCreator.beginTable(event.getReport());
            this.delegate.pageStarted(event);
            this.clearCurrentEvent();
        }
        catch (ReportProcessingException e) {
            throw new FunctionProcessingException("TableWriter", (Exception)((Object)e));
        }
    }

    public void prepareEvent(ReportEvent event) {
        this.getLayoutSupport().getCache().flushDynamicCache();
    }

    public boolean print(Band band, boolean spoolBand, boolean handlePagebreakBefore) throws ReportProcessingException {
        if (!this.isInEndPage() && handlePagebreakBefore && band.getStyle().getBooleanStyleProperty(BandStyleKeys.PAGEBREAK_BEFORE) && !this.isPageEmpty()) {
            this.endPage();
            this.startPage();
        }
        long y = this.getCursor().getY();
        StrictBounds bounds = this.doLayout(band);
        bounds.setRect(0L, y, bounds.getWidth(), bounds.getHeight());
        try {
            this.doPrint(bounds, band);
        }
        catch (ContentCreationException e) {
            throw new ReportProcessingException("Failed to create content", (Exception)((Object)e));
        }
        if (!this.isInEndPage() && band.getStyle().getBooleanStyleProperty(BandStyleKeys.PAGEBREAK_AFTER) && !this.isPageEmpty()) {
            this.endPage();
            this.startPage();
        }
        return true;
    }

    public boolean printBottom(Band band) throws ReportProcessingException {
        return this.print(band, false, false);
    }

    public boolean printWatermark(Band watermark) throws ReportProcessingException {
        throw new ReportProcessingException("Watermark printing is not supported for table targets.");
    }

    public void reportFinished(ReportEvent event) {
        try {
            this.setCurrentEvent(event);
            this.delegate.reportFinished(event);
            this.endPage();
            this.tableCreator.close();
            this.clearCurrentEvent();
        }
        catch (ReportProcessingException e) {
            throw new FunctionProcessingException("TableWriter", (Exception)((Object)e));
        }
    }

    public void reportInitialized(ReportEvent event) {
        if (this.getMaxWidth() == 0L) {
            throw new IllegalStateException("Assert: TableWriter function was not initialized properly");
        }
        try {
            this.setCurrentEvent(event);
            this.tableCreator.open(event.getReport());
            this.startPage();
            this.clearCurrentEvent();
        }
        catch (ReportProcessingException e) {
            throw new FunctionProcessingException("TableWriter", (Exception)((Object)e));
        }
    }

    public void reportStarted(ReportEvent event) {
        this.setCurrentEvent(event);
        this.delegate.reportStarted(event);
        this.clearCurrentEvent();
    }

    public void resetCursor() {
        this.setCursor(new TableWriterCursor());
    }

    public void setCurrentEvent(ReportEvent currentEvent) {
        this.currentEvent = currentEvent;
    }

    private void setCursor(TableWriterCursor cursor) {
        this.cursor = cursor;
    }

    public void setDependencyLevel(int deplevel) {
        this.depLevel = deplevel;
    }

    public void setMaxWidth(long width) {
        this.maxWidth = width;
    }

    public void setReservedSpace(long reserved) {
    }

    public void setTableCreator(TableCreator producer) {
        if (producer == null) {
            throw new NullPointerException("TableCreator given must not be null.");
        }
        this.tableCreator = producer;
    }

    public void setTopPageContentPosition(long topPosition) {
    }

    private void startPage() throws ReportProcessingException {
        if (this.inEndPage) {
            throw new IllegalStateException("Already in startPage or endPage");
        }
        this.inEndPage = true;
        ReportEvent currentEvent = this.getCurrentEvent();
        ReportState cEventState = currentEvent.getState();
        cEventState.firePageStartedEvent(currentEvent.getType());
        if (cEventState.isErrorOccured()) {
            throw new ReportProcessingException("An error occured while processing the page start - aborting");
        }
        this.setCurrentEvent(currentEvent);
        this.inEndPage = false;
    }
}

