/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.report.modules.output.table.csv;

import java.io.PrintWriter;
import java.io.Writer;
import org.jfree.report.ReportDefinition;
import org.jfree.report.content.Content;
import org.jfree.report.content.ContentType;
import org.jfree.report.modules.output.meta.MetaElement;
import org.jfree.report.modules.output.table.base.GenericObjectTable;
import org.jfree.report.modules.output.table.base.RawContent;
import org.jfree.report.modules.output.table.base.SheetLayout;
import org.jfree.report.modules.output.table.base.SheetLayoutCollection;
import org.jfree.report.modules.output.table.base.TableContentCreator;
import org.jfree.report.modules.output.table.base.TableRectangle;
import org.jfree.report.util.CSVQuoter;

public class CSVContentCreator
extends TableContentCreator {
    private PrintWriter writer;
    private boolean open;
    private CSVQuoter quoter;

    public CSVContentCreator(SheetLayoutCollection sheetLayoutCollection, Writer writer) {
        super(sheetLayoutCollection);
        if (writer == null) {
            throw new NullPointerException("Writer is null.");
        }
        this.writer = new PrintWriter(writer);
    }

    protected void handleBeginTable(ReportDefinition reportDefinition) {
    }

    protected void handleClose() {
        this.open = false;
    }

    protected void handleEndTable() {
    }

    public boolean handleFlush() {
        int layoutOffset;
        GenericObjectTable go = this.getBackend();
        SheetLayout layout = this.getCurrentLayout();
        int height = go.getRowCount();
        int width = Math.max(go.getColumnCount(), layout.getColumnCount());
        int y = layoutOffset = this.getLayoutOffset();
        while (y < height + layoutOffset) {
            int x = 0;
            while (x < width) {
                MetaElement element = (MetaElement)go.getObject(y - layoutOffset, x);
                if (element == null) {
                    this.writer.print(this.quoter.getSeparator());
                } else {
                    TableRectangle rectangle = layout.getTableBounds(element, this.getLookupRectangle());
                    if (!rectangle.isOrigin(x, y)) {
                        this.writer.print(this.quoter.getSeparator());
                    } else {
                        Content c = element.getContent();
                        if (c.getContentType().equals(ContentType.RAW)) {
                            RawContent rc = (RawContent)c;
                            this.writer.print(this.quoter.doQuoting(String.valueOf(rc.getContent())));
                        }
                        this.writer.print(this.quoter.getSeparator());
                    }
                }
                ++x;
            }
            this.writer.println();
            ++y;
        }
        return true;
    }

    protected void handleOpen(ReportDefinition reportDefinition) {
        this.open = true;
        String separator = reportDefinition.getReportConfiguration().getConfigProperty("org.jfree.report.modules.output.table.csv.Separator", ",");
        if (separator.length() == 0) {
            throw new IllegalArgumentException("CSV separate cannot be an empty string.");
        }
        this.quoter = new CSVQuoter(separator.charAt(0));
    }

    public boolean isOpen() {
        return this.open;
    }
}

