/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.report.modules.output.table.csv;

import java.io.Writer;
import org.jfree.report.JFreeReport;
import org.jfree.report.ReportProcessingException;
import org.jfree.report.content.DefaultContentFactory;
import org.jfree.report.content.TextContentFactoryModule;
import org.jfree.report.layout.DefaultLayoutSupport;
import org.jfree.report.modules.output.meta.MetaBandProducer;
import org.jfree.report.modules.output.table.base.LayoutCreator;
import org.jfree.report.modules.output.table.base.TableCreator;
import org.jfree.report.modules.output.table.base.TableProcessor;
import org.jfree.report.modules.output.table.csv.CSVContentCreator;
import org.jfree.report.modules.output.table.csv.CSVMetaBandProducer;

public class CSVTableProcessor
extends TableProcessor {
    private Writer writer;
    public static final String CONFIGURATION_PREFIX = "org.jfree.report.modules.output.table.csv";
    public static final String SEPARATOR_KEY = "Separator";
    public static final String SEPARATOR_DEFAULT = ",";

    public CSVTableProcessor(JFreeReport report) throws ReportProcessingException {
        super(report);
        this.init();
    }

    protected TableCreator createContentCreator() {
        if (this.writer == null) {
            throw new IllegalStateException("There is no writer defined for the export.");
        }
        LayoutCreator lc = this.getLayoutCreator();
        return new CSVContentCreator(lc.getSheetLayoutCollection(), this.getWriter());
    }

    protected MetaBandProducer createMetaBandProducer() {
        DefaultContentFactory contentFactory = new DefaultContentFactory();
        contentFactory.addModule(new TextContentFactoryModule());
        return new CSVMetaBandProducer(new DefaultLayoutSupport(contentFactory));
    }

    protected String getReportConfigurationPrefix() {
        return CONFIGURATION_PREFIX;
    }

    public String getSeparator() {
        return this.getReport().getReportConfiguration().getConfigProperty(String.valueOf(this.getReportConfigurationPrefix()) + "." + SEPARATOR_KEY, SEPARATOR_DEFAULT);
    }

    public Writer getWriter() {
        return this.writer;
    }

    public void setSeparator(String separator) {
        if (separator == null) {
            throw new NullPointerException("Separator is null");
        }
        this.getReport().getReportConfiguration().setConfigProperty(String.valueOf(this.getReportConfigurationPrefix()) + "." + SEPARATOR_KEY, separator);
    }

    public void setWriter(Writer writer) {
        this.writer = writer;
    }
}

