/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.report.modules.output.table.html;

import java.awt.Color;
import org.jfree.report.ElementAlignment;
import org.jfree.report.modules.output.table.html.HtmlStyle;
import org.jfree.report.modules.output.table.html.HtmlStyleCollection;
import org.jfree.report.modules.output.table.html.StyleBuilder;
import org.jfree.report.style.FontDefinition;

public final class HtmlContentStyle
implements HtmlStyle {
    private FontDefinition font;
    private Color fontColor;
    private ElementAlignment horizontalAlignment;
    private int hashCode;

    public HtmlContentStyle(FontDefinition font, Color fontColor, ElementAlignment horizontalAlignment) {
        if (font == null) {
            throw new NullPointerException("FontDefinition is null");
        }
        if (fontColor == null) {
            throw new NullPointerException("Color is null");
        }
        if (horizontalAlignment == null) {
            throw new NullPointerException("HorizontalAlignment is null");
        }
        this.font = font;
        this.fontColor = fontColor;
        this.horizontalAlignment = horizontalAlignment;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof HtmlContentStyle)) {
            return false;
        }
        HtmlContentStyle style = (HtmlContentStyle)o;
        if (!this.horizontalAlignment.equals(style.horizontalAlignment)) {
            return false;
        }
        if (!this.font.equals(style.font)) {
            return false;
        }
        return this.fontColor.equals(style.fontColor);
    }

    public String getCSSString(boolean compact) {
        FontDefinition font = this.getFont();
        StyleBuilder builder = new StyleBuilder(compact);
        builder.append("font-family", this.translateFontName(font));
        builder.append("font-size", String.valueOf(font.getFontSize()), "pt");
        if (font.isBold()) {
            builder.append("font-weight", "bold");
        }
        if (font.isItalic()) {
            builder.append("font-style", "italic");
        }
        if (font.isUnderline() && font.isStrikeThrough()) {
            builder.append("text-decoration", "underline, line-through");
        } else if (font.isUnderline()) {
            builder.append("text-decoration", "underline");
        } else if (font.isStrikeThrough()) {
            builder.append("text-decoration", "line-through");
        }
        String colorValue = HtmlStyleCollection.getColorString(this.getFontColor());
        if (colorValue != null) {
            builder.append("color", colorValue);
        }
        builder.append("text-align", this.translateHorizontalAlignment(this.getHorizontalAlignment()));
        return builder.toString();
    }

    public FontDefinition getFont() {
        return this.font;
    }

    public Color getFontColor() {
        return this.fontColor;
    }

    public ElementAlignment getHorizontalAlignment() {
        return this.horizontalAlignment;
    }

    public int hashCode() {
        if (this.hashCode == 0) {
            int result = this.font.hashCode();
            result = 29 * result + this.fontColor.hashCode();
            this.hashCode = result = 29 * result + this.horizontalAlignment.hashCode();
        }
        return this.hashCode;
    }

    private String translateFontName(FontDefinition font) {
        if (font.isCourier()) {
            return "monospaced";
        }
        if (font.isSerif()) {
            return "serif";
        }
        if (font.isSansSerif()) {
            return "sans-serif";
        }
        return "'" + font.getFontName() + "'";
    }

    private String translateHorizontalAlignment(ElementAlignment ea) {
        if (ea == ElementAlignment.RIGHT) {
            return "right";
        }
        if (ea == ElementAlignment.CENTER) {
            return "center";
        }
        return "left";
    }
}

