/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.report.modules.output.table.html;

import org.jfree.report.JFreeReport;
import org.jfree.report.ReportProcessingException;
import org.jfree.report.modules.output.meta.MetaBandProducer;
import org.jfree.report.modules.output.table.base.LayoutCreator;
import org.jfree.report.modules.output.table.base.TableCreator;
import org.jfree.report.modules.output.table.base.TableProcessor;
import org.jfree.report.modules.output.table.html.HtmlContentCreator;
import org.jfree.report.modules.output.table.html.HtmlFilesystem;
import org.jfree.report.modules.output.table.html.HtmlLayoutCreator;
import org.jfree.report.modules.output.table.html.HtmlMetaBandProducer;

public class HtmlProcessor
extends TableProcessor {
    private HtmlFilesystem filesystem;
    public static final String CONFIGURATION_PREFIX = "org.jfree.report.modules.output.table.html";
    public static final String GENERATE_XHTML = "GenerateXHTML";
    public static final String ENCODING = "Encoding";
    public static final String ENCODING_DEFAULT = "UTF-8";
    public static final String BODY_FRAGMENT = "BodyFragment";
    public static final String EMPTY_CELLS_USE_CSS = "EmptyCellsUseCSS";
    public static final String TABLE_ROW_BORDER_DEFINITION = "TableRowBorderDefinition";
    public static final String USE_DEVICE_INDEPENDENT_IMAGESIZES = "UseDeviceIndependentImageSize";
    public static final String PROPORTIONAL_COLUMN_WIDTHS = "ProportionalColumnWidths";

    public HtmlProcessor(JFreeReport report) throws ReportProcessingException {
        super(report);
        this.init();
    }

    public HtmlProcessor(JFreeReport report, boolean useXHTML) throws ReportProcessingException {
        super(report);
        this.setGenerateXHTML(useXHTML);
        this.init();
    }

    protected TableCreator createContentCreator() {
        HtmlLayoutCreator layoutCreator = (HtmlLayoutCreator)this.getLayoutCreator();
        return new HtmlContentCreator(this.getFilesystem(), this.isGenerateXHTML(), layoutCreator.getStyleCollection(), layoutCreator.getSheetLayoutCollection());
    }

    protected LayoutCreator createLayoutCreator() {
        return new HtmlLayoutCreator(this.getReportConfigurationPrefix());
    }

    protected MetaBandProducer createMetaBandProducer() {
        return new HtmlMetaBandProducer(this.isGenerateXHTML(), this.isUseDeviceIndependentImageSize());
    }

    public String getEncoding() {
        return this.getReport().getReportConfiguration().getConfigProperty(String.valueOf(this.getReportConfigurationPrefix()) + "." + ENCODING, ENCODING_DEFAULT);
    }

    public HtmlFilesystem getFilesystem() {
        return this.filesystem;
    }

    protected String getReportConfigurationPrefix() {
        return CONFIGURATION_PREFIX;
    }

    public boolean isEmptyCellsUseCSS() {
        return this.getReport().getReportConfiguration().getConfigProperty(String.valueOf(this.getReportConfigurationPrefix()) + "." + EMPTY_CELLS_USE_CSS, "false").equals("true");
    }

    public boolean isGenerateBodyFragment() {
        return this.getReport().getReportConfiguration().getConfigProperty(String.valueOf(this.getReportConfigurationPrefix()) + "." + BODY_FRAGMENT, "false").equals("true");
    }

    public boolean isGenerateXHTML() {
        return this.getReport().getReportConfiguration().getConfigProperty(String.valueOf(this.getReportConfigurationPrefix()) + "." + GENERATE_XHTML, "false").equals("true");
    }

    public boolean isUseDeviceIndependentImageSize() {
        return this.getReport().getReportConfiguration().getConfigProperty(String.valueOf(this.getReportConfigurationPrefix()) + "." + USE_DEVICE_INDEPENDENT_IMAGESIZES, "false").equals("true");
    }

    public void setEmptyCellsUseCSS(boolean emptyCellsUseCSS) {
        this.getReport().getReportConfiguration().setConfigProperty(String.valueOf(this.getReportConfigurationPrefix()) + "." + EMPTY_CELLS_USE_CSS, String.valueOf(emptyCellsUseCSS));
    }

    public void setEncoding(String encoding) {
        this.getReport().getReportConfiguration().setConfigProperty(String.valueOf(this.getReportConfigurationPrefix()) + "." + ENCODING, encoding);
    }

    public void setFilesystem(HtmlFilesystem filesystem) {
        this.filesystem = filesystem;
    }

    public void setGenerateBodyFragment(boolean generateBodyFragment) {
        this.getReport().getReportConfiguration().setConfigProperty(String.valueOf(this.getReportConfigurationPrefix()) + "." + BODY_FRAGMENT, String.valueOf(generateBodyFragment));
    }

    public void setGenerateXHTML(boolean useXHTML) {
        this.getReport().getReportConfiguration().setConfigProperty(String.valueOf(this.getReportConfigurationPrefix()) + "." + GENERATE_XHTML, String.valueOf(useXHTML));
    }

    public void setUseDeviceIndependentImageSize(boolean useDeviceIndependentImageSize) {
        this.getReport().getReportConfiguration().setConfigProperty(String.valueOf(this.getReportConfigurationPrefix()) + "." + USE_DEVICE_INDEPENDENT_IMAGESIZES, String.valueOf(useDeviceIndependentImageSize));
    }
}

