/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.report.modules.output.table.html;

import java.awt.Color;
import org.jfree.report.ElementAlignment;
import org.jfree.report.modules.output.table.base.TableCellBackground;
import org.jfree.report.modules.output.table.html.HtmlStyle;
import org.jfree.report.modules.output.table.html.HtmlStyleCollection;
import org.jfree.report.modules.output.table.html.StyleBuilder;

public class HtmlTableCellStyle
implements HtmlStyle {
    private TableCellBackground background;
    private ElementAlignment verticalAlignment;

    public HtmlTableCellStyle(TableCellBackground background, ElementAlignment verticalAlignment) {
        if (verticalAlignment == null) {
            throw new NullPointerException();
        }
        this.background = background;
        this.verticalAlignment = verticalAlignment;
    }

    public boolean equals(Object o) {
        HtmlTableCellStyle that;
        block8: {
            block7: {
                boolean bl;
                block6: {
                    block5: {
                        if (this == o) {
                            return true;
                        }
                        if (o == null || this.getClass() != o.getClass()) {
                            return false;
                        }
                        that = (HtmlTableCellStyle)o;
                        if (this.background == null) break block5;
                        bl = this.background.equals(that.background) ^ true;
                        break block6;
                    }
                    if (that.background != null) break block7;
                    bl = false;
                }
                if (!bl) break block8;
            }
            return false;
        }
        return this.verticalAlignment.equals(that.verticalAlignment);
    }

    public String getCSSString(boolean compact) {
        if (this.background == null) {
            return "font-size: 1pt; vertical-alignment:" + this.translateVerticalAlignment(this.verticalAlignment);
        }
        StyleBuilder b = new StyleBuilder(compact);
        b.append("font-size", "1pt");
        Color c = this.background.getColor();
        if (c != null) {
            b.append("background-color", HtmlStyleCollection.getColorString(c));
        }
        if (this.background.getColorTop() != null) {
            b.append("border-top", String.valueOf(this.background.getBorderSizeTop()), "pt");
            b.append("border-top-style", "solid");
            b.append("border-top-color", HtmlStyleCollection.getColorString(this.background.getColorTop()));
        }
        if (this.background.getColorBottom() != null) {
            b.append("border-bottom", String.valueOf(this.background.getBorderSizeBottom()), "pt");
            b.append("border-bottom-style", "solid");
            b.append("border-bottom-color", HtmlStyleCollection.getColorString(this.background.getColorBottom()));
        }
        if (this.background.getColorLeft() != null) {
            b.append("border-left", String.valueOf(this.background.getBorderSizeLeft()), "pt");
            b.append("border-left-style", "solid");
            b.append("border-left-color", HtmlStyleCollection.getColorString(this.background.getColorLeft()));
        }
        if (this.background.getColorRight() != null) {
            b.append("border-right", String.valueOf(this.background.getBorderSizeRight()), "pt");
            b.append("border-right-style", "solid");
            b.append("border-right-color", HtmlStyleCollection.getColorString(this.background.getColorRight()));
        }
        b.append("vertical-align", this.translateVerticalAlignment(this.verticalAlignment));
        return b.toString();
    }

    public int hashCode() {
        int result = this.background != null ? this.background.hashCode() : 0;
        result = 29 * result + this.verticalAlignment.hashCode();
        return result;
    }

    private String translateVerticalAlignment(ElementAlignment ea) {
        if (ea == ElementAlignment.BOTTOM) {
            return "bottom";
        }
        if (ea == ElementAlignment.MIDDLE) {
            return "middle";
        }
        return "top";
    }
}

