/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.report.modules.output.table.html;

import com.keypoint.PngEncoder;
import java.awt.Image;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.HashMap;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.InflaterInputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.jfree.io.IOUtils;
import org.jfree.report.ImageContainer;
import org.jfree.report.LocalImageContainer;
import org.jfree.report.URLImageContainer;
import org.jfree.report.modules.output.table.html.HtmlFilesystem;
import org.jfree.report.modules.output.table.html.ref.EmptyContentReference;
import org.jfree.report.modules.output.table.html.ref.ExternalStyleSheetReference;
import org.jfree.report.modules.output.table.html.ref.HtmlImageReference;
import org.jfree.report.modules.output.table.html.ref.HtmlReference;
import org.jfree.report.modules.output.table.html.util.CounterReference;
import org.jfree.report.resourceloader.ImageFactory;
import org.jfree.report.util.ImageComparator;
import org.jfree.report.util.NoCloseOutputStream;
import org.jfree.report.util.StringUtil;
import org.jfree.util.WaitingImageObserver;

public class ZIPHtmlFilesystem
implements HtmlFilesystem {
    private String dataDirectory;
    private ZipOutputStream zipOut;
    private ByteArrayOutputStream rootBase;
    private OutputStream rootStream;
    private HashMap usedNames;
    private HashMap usedImages;
    private HashMap encodedImages;
    private ImageComparator comparator;
    private boolean copyExternalImages;
    private boolean digestImageCompare;

    public ZIPHtmlFilesystem(OutputStream out, String dataDirectory) throws IOException {
        if (out == null) {
            throw new NullPointerException();
        }
        if (dataDirectory == null) {
            throw new NullPointerException();
        }
        this.zipOut = new ZipOutputStream(new NoCloseOutputStream(out));
        this.rootBase = new ByteArrayOutputStream();
        this.rootStream = new DeflaterOutputStream((OutputStream)this.rootBase, new Deflater(9));
        File dataDir = new File(dataDirectory);
        File baseDir = new File("");
        if (dataDir.isAbsolute() || !IOUtils.getInstance().isSubDirectory(baseDir, dataDir)) {
            throw new IllegalArgumentException("The data directory is no relative directory in the zip file");
        }
        dataDirectory = IOUtils.getInstance().createRelativeURL(dataDir.toURL(), baseDir.toURL());
        if (dataDirectory.length() != 0) {
            this.dataDirectory = !dataDirectory.endsWith("/") ? String.valueOf(dataDirectory) + "/" : dataDirectory;
        }
        this.usedNames = new HashMap();
        this.usedImages = new HashMap();
        this.comparator = new ImageComparator();
        this.encodedImages = new HashMap();
    }

    public void close() throws IOException {
        String entryName = String.valueOf(this.createName("report")) + ".html";
        ZipEntry ze = new ZipEntry(entryName);
        this.zipOut.putNextEntry(ze);
        this.rootStream.flush();
        this.rootStream.close();
        byte[] data = this.rootBase.toByteArray();
        this.rootBase = null;
        InflaterInputStream infIn = new InflaterInputStream(new BufferedInputStream(new ByteArrayInputStream(data)));
        IOUtils.getInstance().copyStreams((InputStream)infIn, (OutputStream)this.zipOut);
        this.zipOut.closeEntry();
        ((FilterOutputStream)this.zipOut).flush();
        this.zipOut.close();
    }

    public HtmlReference createCSSReference(String styleSheet) throws IOException {
        String entryName = String.valueOf(this.dataDirectory) + this.createName("style") + ".css";
        ZipEntry ze = new ZipEntry(entryName);
        this.zipOut.putNextEntry(ze);
        this.zipOut.write(styleSheet.getBytes());
        String baseName = entryName;
        return new ExternalStyleSheetReference(baseName);
    }

    public HtmlReference createImageReference(ImageContainer reference) throws IOException {
        LocalImageContainer li;
        Image image;
        if (reference instanceof URLImageContainer) {
            URLImageContainer urlImage = (URLImageContainer)reference;
            URL url = urlImage.getSourceURL();
            if (url != null) {
                String name = (String)this.usedImages.get(url);
                if (name != null) {
                    return new HtmlImageReference(name);
                }
                if (this.isSupportedImageFormat(urlImage.getSourceURL())) {
                    if (this.isCopyExternalImages() && urlImage.isLoadable()) {
                        IOUtils iou = IOUtils.getInstance();
                        String entryName = String.valueOf(this.dataDirectory) + this.createName(iou.getFileName(url));
                        ZipEntry ze = new ZipEntry(entryName);
                        this.zipOut.putNextEntry(ze);
                        BufferedInputStream urlIn = new BufferedInputStream(urlImage.getSourceURL().openStream());
                        IOUtils.getInstance().copyStreams((InputStream)urlIn, (OutputStream)this.zipOut);
                        ((InputStream)urlIn).close();
                        this.usedImages.put(url, entryName);
                        return new HtmlImageReference(entryName);
                    }
                    String baseName = urlImage.getSourceURL().toExternalForm();
                    this.usedImages.put(url, baseName);
                    return new HtmlImageReference(baseName);
                }
                if (!urlImage.isLoadable()) {
                    return new EmptyContentReference();
                }
                Image image2 = null;
                if (reference instanceof LocalImageContainer) {
                    LocalImageContainer li2 = (LocalImageContainer)reference;
                    image2 = li2.getImage();
                }
                if (image2 == null) {
                    image2 = ImageFactory.getInstance().createImage(url);
                }
                if (image2 != null) {
                    String entryName = this.encodeImage(image2, false);
                    this.usedImages.put(url, entryName);
                    return new HtmlImageReference(entryName);
                }
            } else if (urlImage.getSourceURLString() != null) {
                return new HtmlImageReference(urlImage.getSourceURLString());
            }
        }
        if (reference instanceof LocalImageContainer && (image = (li = (LocalImageContainer)reference).getImage()) != null) {
            if (li.isIdentifiable()) {
                Object identity = li.getIdentity();
                String name = (String)this.usedImages.get(identity);
                if (name == null) {
                    name = this.encodeImage(image, false);
                    this.usedImages.put(identity, name);
                }
                return new HtmlImageReference(name);
            }
            return new HtmlImageReference(this.encodeImage(image, true));
        }
        return new EmptyContentReference();
    }

    private String createName(String base) {
        CounterReference ref = (CounterReference)this.usedNames.get(base);
        if (ref == null) {
            ref = new CounterReference();
            this.usedNames.put(base, ref);
            return base;
        }
        ref.increase();
        return String.valueOf(base) + ref.getCount();
    }

    private String encodeImage(Image image, boolean createComparator) throws IOException {
        Object object;
        WaitingImageObserver obs = new WaitingImageObserver(image);
        obs.waitImageLoaded();
        PngEncoder encoder = new PngEncoder(image, true, 0, 5);
        byte[] data = encoder.pngEncode();
        if (createComparator) {
            object = this.comparator.createCompareData(data, !this.isDigestImageCompare());
            String name = (String)this.encodedImages.get(object);
            if (name != null) {
                return name;
            }
        } else {
            object = null;
        }
        String entryName = String.valueOf(this.dataDirectory) + this.createName("picture") + ".png";
        ZipEntry ze = new ZipEntry(entryName);
        this.zipOut.putNextEntry(ze);
        this.zipOut.write(data);
        if (createComparator) {
            this.encodedImages.put(object, entryName);
        }
        return entryName;
    }

    public OutputStream getRootStream() throws IOException {
        return this.rootStream;
    }

    public boolean isCopyExternalImages() {
        return this.copyExternalImages;
    }

    public boolean isDigestImageCompare() {
        return this.digestImageCompare;
    }

    protected boolean isSupportedImageFormat(URL url) {
        String file = url.getFile();
        if (StringUtil.endsWithIgnoreCase(file, ".jpg")) {
            return true;
        }
        if (StringUtil.endsWithIgnoreCase(file, ".jpeg")) {
            return true;
        }
        if (StringUtil.endsWithIgnoreCase(file, ".png")) {
            return true;
        }
        return StringUtil.endsWithIgnoreCase(file, ".gif");
    }

    public void setCopyExternalImages(boolean copyExternalImages) {
        this.copyExternalImages = copyExternalImages;
    }

    public void setDigestImageCompare(boolean digestImageCompare) {
        this.digestImageCompare = digestImageCompare;
    }
}

