/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.report.modules.output.table.xls;

import java.io.IOException;
import java.io.OutputStream;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFPrintSetup;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.hssf.util.Region;
import org.jfree.report.ReportDefinition;
import org.jfree.report.ReportProcessingException;
import org.jfree.report.modules.output.meta.MetaElement;
import org.jfree.report.modules.output.table.base.GenericObjectTable;
import org.jfree.report.modules.output.table.base.SheetLayout;
import org.jfree.report.modules.output.table.base.SheetLayoutCollection;
import org.jfree.report.modules.output.table.base.TableCellBackground;
import org.jfree.report.modules.output.table.base.TableContentCreator;
import org.jfree.report.modules.output.table.base.TableRectangle;
import org.jfree.report.modules.output.table.xls.HSSFCellStyleProducer;
import org.jfree.report.modules.output.table.xls.metaelements.ExcelMetaElement;
import org.jfree.report.modules.output.table.xls.util.ExcelPrintSetupFactory;
import org.jfree.report.util.geom.StrictGeomUtility;
import org.jfree.util.Log;

public class ExcelContentCreator
extends TableContentCreator {
    private static final double HEIGHT_SCALE_FACTOR = 26.666666666666668;
    private HSSFCellStyleProducer cellStyleProducer;
    private OutputStream outputStream;
    private boolean open;
    private HSSFWorkbook workbook;
    private HSSFSheet sheet;
    private boolean newTable;
    private static final double SCALE_FACTOR = 56.88888931274414;

    public ExcelContentCreator(SheetLayoutCollection sheetLayoutCollection, OutputStream outputStream) {
        super(sheetLayoutCollection);
        this.outputStream = outputStream;
    }

    private void exportCell(MetaElement element, TableRectangle rectangle, short x, int y) {
        HSSFCell cell = this.getCellAt(x, y);
        if (rectangle.getColumnSpan() > 1 || rectangle.getRowSpan() > 1) {
            this.sheet.addMergedRegion(new Region(y, x, y + rectangle.getRowSpan() - 1, (short)(x + rectangle.getColumnSpan() - 1)));
            int rectX = rectangle.getX1();
            int rectY = rectangle.getY1();
            int row = 0;
            while (row < rectangle.getRowSpan()) {
                int col = 0;
                while (col < rectangle.getColumnSpan()) {
                    TableCellBackground bg = this.getCurrentLayout().getElementAt(rectY + row, rectX + col);
                    HSSFCell regionCell = this.getCellAt((short)(x + col), y + row);
                    HSSFCellStyle style = this.cellStyleProducer.createCellStyle(element, bg);
                    if (style != null) {
                        regionCell.setCellStyle(style);
                    }
                    ++col;
                }
                ++row;
            }
        } else {
            TableCellBackground bg = this.getCurrentLayout().getRegionBackground(rectangle);
            HSSFCellStyle style = this.cellStyleProducer.createCellStyle(element, bg);
            if (style != null) {
                cell.setCellStyle(style);
            }
        }
        if (element instanceof ExcelMetaElement) {
            ExcelMetaElement me = (ExcelMetaElement)element;
            cell.setEncoding((short)1);
            me.applyValue(cell);
        }
    }

    private HSSFCell getCellAt(short x, int y) {
        HSSFRow row = this.getRowAt(y);
        HSSFCell cell = row.getCell(x);
        if (cell != null) {
            return cell;
        }
        return row.createCell(x);
    }

    private HSSFRow getRowAt(int y) {
        HSSFRow row = this.sheet.getRow(y);
        if (row != null) {
            return row;
        }
        return this.sheet.createRow(y);
    }

    protected void handleBeginTable(ReportDefinition reportDefinition) throws ReportProcessingException {
        this.newTable = true;
        String sheetName = null;
        if (this.getSheetNameFunction() != null) {
            sheetName = String.valueOf(reportDefinition.getDataRow().get(this.getSheetNameFunction()));
        }
        this.sheet = sheetName == null ? this.workbook.createSheet() : this.workbook.createSheet(sheetName);
        String paper = reportDefinition.getReportConfiguration().getConfigProperty("org.jfree.report.modules.output.table.xls.Paper");
        String paperOrientation = reportDefinition.getReportConfiguration().getConfigProperty("org.jfree.report.modules.output.table.xls.PaperOrientation");
        HSSFPrintSetup printSetup = this.sheet.getPrintSetup();
        ExcelPrintSetupFactory.performPageSetup(printSetup, reportDefinition.getPageDefinition(), paper, paperOrientation);
    }

    protected void handleClose() throws ReportProcessingException {
        this.open = false;
        try {
            this.workbook.write(this.outputStream);
        }
        catch (IOException e) {
            Log.warn((Object)"could not write xls data. Message:", (Exception)e);
        }
    }

    protected void handleEndTable() throws ReportProcessingException {
        this.sheet = null;
    }

    public boolean handleFlush() throws ReportProcessingException {
        int layoutOffset;
        GenericObjectTable go = this.getBackend();
        SheetLayout layout = this.getCurrentLayout();
        int width = Math.max(go.getColumnCount(), layout.getColumnCount());
        if (this.newTable) {
            int i = 0;
            while (i < width) {
                double cellWidth = StrictGeomUtility.toExternalValue(layout.getCellWidth(i, i + 1));
                double poiCellWidth = cellWidth * 56.88888931274414;
                this.sheet.setColumnWidth((short)i, (short)poiCellWidth);
                i = (short)(i + 1);
            }
            this.newTable = false;
        }
        int height = go.getRowCount();
        int y = layoutOffset = this.getLayoutOffset();
        while (y < height + layoutOffset) {
            HSSFRow row = this.getRowAt((short)y);
            double lastRowHeight = StrictGeomUtility.toExternalValue(layout.getRowHeight(y));
            row.setHeight((short)(lastRowHeight * 26.666666666666668));
            int x = 0;
            while (x < width) {
                MetaElement element = (MetaElement)go.getObject(y - layoutOffset, x);
                if (element == null) {
                    TableCellBackground background = layout.getElementAt(y, x);
                    if (background != null) {
                        HSSFCell cell = this.getCellAt((short)x, y);
                        HSSFCellStyle style = this.cellStyleProducer.createCellStyle(null, background);
                        if (style != null) {
                            cell.setCellStyle(style);
                        }
                    }
                } else {
                    TableRectangle rectangle = layout.getTableBounds(element, this.getLookupRectangle());
                    if (rectangle.isOrigin(x, y)) {
                        this.exportCell(element, rectangle, (short)x, y);
                    }
                }
                ++x;
            }
            ++y;
        }
        return true;
    }

    protected void handleOpen(ReportDefinition reportDefinition) throws ReportProcessingException {
        this.open = true;
        this.workbook = new HSSFWorkbook();
        boolean hardLimit = "true".equals(reportDefinition.getReportConfiguration().getConfigProperty("org.jfree.report.modules.output.table.xls.HardStyleCountLimit"));
        this.cellStyleProducer = new HSSFCellStyleProducer(this.workbook, hardLimit);
    }

    public boolean isOpen() {
        return this.open;
    }
}

