/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.report.modules.parser.extwriter;

import java.io.IOException;
import java.io.Writer;
import org.jfree.report.JFreeReport;
import org.jfree.report.ReportBuilderHints;
import org.jfree.report.modules.parser.base.CommentHintPath;
import org.jfree.report.modules.parser.extwriter.ReportWriter;
import org.jfree.report.modules.parser.extwriter.ReportWriterException;
import org.jfree.xml.writer.SafeTagList;
import org.jfree.xml.writer.XMLWriterSupport;

public abstract class AbstractXMLDefinitionWriter
extends XMLWriterSupport {
    public static final String REPORT_DEFINITION_TAG = "report-definition";
    public static final String PARSER_CONFIG_TAG = "parser-config";
    public static final String REPORT_CONFIG_TAG = "report-config";
    public static final String STYLES_TAG = "styles";
    public static final String TEMPLATES_TAG = "templates";
    public static final String REPORT_DESCRIPTION_TAG = "report-description";
    public static final String FUNCTIONS_TAG = "functions";
    public static final String BAND_TAG = "band";
    public static final String ELEMENT_TAG = "element";
    public static final String COMPOUND_OBJECT_TAG = "compound-object";
    public static final String BASIC_OBJECT_TAG = "basic-object";
    public static final String DATASOURCE_TAG = "datasource";
    public static final String PROPERTIES_TAG = "properties";
    public static final String FUNCTION_TAG = "function";
    public static final String EXPRESSION_TAG = "expression";
    public static final String PROPERTY_REF_TAG = "property-ref";
    public static final String FIELDS_TAG = "fields";
    public static final String FIELD_TAG = "field";
    public static final String GROUP_HEADER_TAG = "group-header";
    public static final String GROUP_FOOTER_TAG = "group-footer";
    public static final String GROUP_TAG = "group";
    public static final String STYLEKEY_FACTORY_TAG = "stylekey-factory";
    public static final String TEMPLATE_FACTORY_TAG = "template-factory";
    public static final String OBJECT_FACTORY_TAG = "object-factory";
    public static final String DATADEFINITION_FACTORY_TAG = "datadefinition-factory";
    public static final String DATASOURCE_FACTORY_TAG = "datasource-factory";
    public static final String ELEMENT_FACTORY_TAG = "element-factory";
    public static final String CLASS_ATTRIBUTE = "class";
    public static final String DEFAULT_PAGEFORMAT_TAG = "defaultpageformat";
    public static final String CONFIGURATION_TAG = "configuration";
    public static final String OUTPUT_TARGET_TAG = "output-config";
    public static final String PAGEFORMAT_ATT = "pageformat";
    public static final String LEFTMARGIN_ATT = "leftmargin";
    public static final String RIGHTMARGIN_ATT = "rightmargin";
    public static final String TOPMARGIN_ATT = "topmargin";
    public static final String BOTTOMMARGIN_ATT = "bottommargin";
    public static final String WIDTH_ATT = "width";
    public static final String HEIGHT_ATT = "height";
    public static final String ORIENTATION_ATT = "orientation";
    public static final String ORIENTATION_PORTRAIT_VAL = "portrait";
    public static final String ORIENTATION_LANDSCAPE_VAL = "landscape";
    public static final String ORIENTATION_REVERSE_LANDSCAPE_VAL = "reverse_landscape";
    public static final String STYLEKEY_FACTORY_HINT = "ext.parser.parser-config.stylekeyfactories";
    public static final String OBJECT_FACTORY_HINT = "ext.parser.parser-config.objectfactories";
    public static final String DATASOURCE_FACTORY_HINT = "ext.parser.parser-config.datasourcefactories";
    public static final String TEMPLATE_FACTORY_HINT = "ext.parser.parser-config.templatefactories";
    public static final String ELEMENT_FACTORY_HINT = "ext.parser.parser-config.elementfactories";
    public static final String REPORT_HEADER_TAG = "report-header";
    public static final String REPORT_FOOTER_TAG = "report-footer";
    public static final String PAGE_HEADER_TAG = "page-header";
    public static final String PAGE_FOOTER_TAG = "page-footer";
    public static final String ITEMBAND_TAG = "itemband";
    public static final String GROUPS_TAG = "groups";
    public static final String WATERMARK_TAG = "watermark";
    public static final String STYLE_TAG = "style";
    public static final String COMPOUND_KEY_TAG = "compound-key";
    public static final String BASIC_KEY_TAG = "basic-key";
    public static final String EXTENDS_TAG = "extends";
    public static final String TEMPLATE_TAG = "template";
    public static final String PROPERTY_TAG = "property";
    public static final String NAME_ATTR = "name";
    private final ReportWriter reportWriter;
    protected static final String PAGE_DEFINITION_TAG = "page-definition";
    protected static final String SIMPLE_PAGE_DEFINITION_TAG = "simple-page-definition";
    protected static final String PAGE_TAG = "page";
    private static SafeTagList safeTags;
    static /* synthetic */ Class array$Ljava$lang$String;

    public AbstractXMLDefinitionWriter(ReportWriter reportWriter, int indentLevel) {
        super(AbstractXMLDefinitionWriter.getDefaultSafeTags(), indentLevel);
        this.reportWriter = reportWriter;
    }

    static /* synthetic */ Class class$(String class$) {
        try {
            return Class.forName(class$);
        }
        catch (ClassNotFoundException forName) {
            throw new NoClassDefFoundError(forName.getMessage());
        }
    }

    public static SafeTagList getDefaultSafeTags() {
        if (safeTags == null) {
            safeTags = new SafeTagList();
            safeTags.add(FUNCTIONS_TAG);
            safeTags.add(PARSER_CONFIG_TAG);
            safeTags.add(REPORT_CONFIG_TAG);
            safeTags.add(REPORT_DEFINITION_TAG);
            safeTags.add(REPORT_DESCRIPTION_TAG);
            safeTags.add(STYLES_TAG);
            safeTags.add(TEMPLATES_TAG);
            safeTags.add(BAND_TAG);
            safeTags.add(ELEMENT_TAG);
            safeTags.add(COMPOUND_OBJECT_TAG);
            safeTags.add(BASIC_OBJECT_TAG, false, true);
            safeTags.add(DATASOURCE_TAG);
            safeTags.add(PROPERTIES_TAG);
            safeTags.add(EXPRESSION_TAG);
            safeTags.add(FUNCTION_TAG);
            safeTags.add(PROPERTY_REF_TAG);
            safeTags.add(FIELDS_TAG);
            safeTags.add(FIELD_TAG, false, true);
            safeTags.add(GROUP_FOOTER_TAG);
            safeTags.add(GROUP_HEADER_TAG);
            safeTags.add(GROUP_TAG);
            safeTags.add(DATADEFINITION_FACTORY_TAG);
            safeTags.add(DATASOURCE_FACTORY_TAG);
            safeTags.add(ELEMENT_FACTORY_TAG);
            safeTags.add(OBJECT_FACTORY_TAG);
            safeTags.add(STYLEKEY_FACTORY_TAG);
            safeTags.add(TEMPLATE_FACTORY_TAG);
            safeTags.add(CONFIGURATION_TAG);
            safeTags.add(DEFAULT_PAGEFORMAT_TAG);
            safeTags.add(SIMPLE_PAGE_DEFINITION_TAG);
            safeTags.add(PAGE_DEFINITION_TAG);
            safeTags.add(PAGE_TAG);
            safeTags.add(OUTPUT_TARGET_TAG);
            safeTags.add(GROUPS_TAG);
            safeTags.add(ITEMBAND_TAG);
            safeTags.add(PAGE_FOOTER_TAG);
            safeTags.add(PAGE_HEADER_TAG);
            safeTags.add(REPORT_FOOTER_TAG);
            safeTags.add(REPORT_HEADER_TAG);
            safeTags.add(STYLE_TAG);
            safeTags.add(COMPOUND_KEY_TAG);
            safeTags.add(BASIC_KEY_TAG, false, true);
            safeTags.add(EXTENDS_TAG);
            safeTags.add(TEMPLATE_TAG);
            safeTags.add(PROPERTY_TAG, false, true);
        }
        return safeTags;
    }

    protected JFreeReport getReport() {
        return this.getReportWriter().getReport();
    }

    protected ReportWriter getReportWriter() {
        return this.reportWriter;
    }

    public static String normalize(String s) {
        if (s == null) {
            return "";
        }
        StringBuffer str = new StringBuffer();
        int len = s.length();
        int i = 0;
        while (i < len) {
            char ch = s.charAt(i);
            switch (ch) {
                case '<': {
                    str.append("&lt;");
                    break;
                }
                case '>': {
                    str.append("&gt;");
                    break;
                }
                case '&': {
                    str.append("&amp;");
                    break;
                }
                case '\"': {
                    str.append("&quot;");
                    break;
                }
                case '\n': {
                    if (i > 0) {
                        char lastChar = str.charAt(str.length() - 1);
                        if (lastChar != '\r') {
                            str.append(XMLWriterSupport.getLineSeparator());
                            break;
                        }
                        str.append('\n');
                        break;
                    }
                    str.append(XMLWriterSupport.getLineSeparator());
                    break;
                }
                default: {
                    str.append(ch);
                }
            }
            ++i;
        }
        return str.toString();
    }

    public abstract void write(Writer var1) throws IOException, ReportWriterException;

    protected void writeComment(Writer writer, String comment) throws IOException {
        if (comment == null) {
            return;
        }
        this.indent(writer, 3);
        writer.write("<!--");
        writer.write(comment);
        writer.write("-->");
        writer.write(XMLWriterSupport.getLineSeparator());
    }

    protected void writeComment(Writer writer, CommentHintPath path, String hintName) throws IOException {
        ReportBuilderHints hints = this.getReport().getReportBuilderHints();
        if (hints == null) {
            return;
        }
        String[] comment = (String[])hints.getHint(path, hintName, array$Ljava$lang$String != null ? array$Ljava$lang$String : (array$Ljava$lang$String = AbstractXMLDefinitionWriter.class$("[Ljava.lang.String;")));
        if (comment == null) {
            return;
        }
        int i = 0;
        while (i < comment.length) {
            this.writeComment(writer, comment[i]);
            ++i;
        }
    }
}

