/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.report.modules.parser.extwriter;

import java.io.IOException;
import java.io.Writer;
import java.lang.reflect.Constructor;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Iterator;
import org.jfree.report.modules.parser.base.CommentHintPath;
import org.jfree.report.modules.parser.extwriter.AbstractXMLDefinitionWriter;
import org.jfree.report.modules.parser.extwriter.ReportWriter;
import org.jfree.util.Log;
import org.jfree.xml.writer.XMLWriterSupport;

public class ParserConfigWriter
extends AbstractXMLDefinitionWriter {
    private static final CommentHintPath PARSER_CONFIG_PATH = new CommentHintPath(new String[]{"report-definition", "parser-config"});

    public ParserConfigWriter(ReportWriter reportWriter, int indentLevel) {
        super(reportWriter, indentLevel);
    }

    private Iterator filterFactories(Iterator it) {
        ReportWriter writer = this.getReportWriter();
        ArrayList factories = new ArrayList();
        while (it.hasNext()) {
            Object o = it.next();
            if (o.equals(writer.getClassFactoryCollector()) || o.equals(writer.getDataSourceCollector()) || o.equals(writer.getElementFactoryCollector()) || o.equals(writer.getStyleKeyFactoryCollector()) || o.equals(writer.getTemplateCollector()) || factories.contains(o)) continue;
            factories.add(o);
        }
        return ((AbstractList)factories).iterator();
    }

    public void write(Writer writer) throws IOException {
        this.writeComment(writer, PARSER_CONFIG_PATH, "parser.comment.open");
        this.writeTag(writer, "parser-config");
        this.writeFactory(writer, "object-factory", this.filterFactories(this.getReportWriter().getClassFactoryCollector().getFactories()));
        this.writeFactory(writer, "element-factory", this.filterFactories(this.getReportWriter().getElementFactoryCollector().getFactories()));
        this.writeFactory(writer, "stylekey-factory", this.filterFactories(this.getReportWriter().getStyleKeyFactoryCollector().getFactories()));
        this.writeFactory(writer, "template-factory", this.filterFactories(this.getReportWriter().getTemplateCollector().getFactories()));
        this.writeFactory(writer, "datasource-factory", this.filterFactories(this.getReportWriter().getDataSourceCollector().getFactories()));
        this.writeComment(writer, PARSER_CONFIG_PATH, "parser.comment.close");
        this.writeCloseTag(writer, "parser-config");
        writer.write(XMLWriterSupport.getLineSeparator());
    }

    public void writeFactory(Writer w, String tagName, Iterator it) throws IOException {
        while (it.hasNext()) {
            Object itObject;
            block4: {
                itObject = it.next();
                try {
                    Class<?> itClass = itObject.getClass();
                    Constructor<?> c = itClass.getConstructor(new Class[0]);
                    if (c == null) {
                    }
                    break block4;
                }
                catch (Exception exception) {
                    StringBuffer message = new StringBuffer();
                    message.append("FactoryClass ");
                    message.append(itObject.getClass());
                    message.append(" has no default constructor. This class will be ignored");
                    this.writeComment(w, message.toString());
                    Log.warn((Object)message.toString());
                }
                continue;
            }
            String className = itObject.getClass().getName();
            CommentHintPath path = PARSER_CONFIG_PATH.getInstance();
            path.addName(tagName);
            path.addName(itObject.getClass().getName());
            this.writeComment(w, path, "parser.comment.open");
            this.writeTag(w, tagName, "class", className, true);
        }
    }
}

