/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.report.modules.parser.simple.readhandlers;

import org.jfree.report.elementfactory.ImageElementFactory;
import org.jfree.report.modules.parser.base.PropertyAttributes;
import org.jfree.report.modules.parser.simple.readhandlers.AbstractElementReadHandler;
import org.jfree.xml.ParserUtil;
import org.jfree.xml.parser.XmlReaderException;
import org.xml.sax.SAXException;

public abstract class AbstractImageElementReadHandler
extends AbstractElementReadHandler {
    private static final String SCALE_ATT = "scale";
    private static final String KEEP_ASPECT_RATIO_ATT = "keepAspectRatio";

    protected AbstractImageElementReadHandler() {
    }

    protected void handleKeepAspectRatio(PropertyAttributes atts) {
        String booleanValue = atts.getValue(KEEP_ASPECT_RATIO_ATT);
        if (booleanValue != null) {
            ImageElementFactory elementFactory = (ImageElementFactory)this.getElementFactory();
            elementFactory.setKeepAspectRatio(new Boolean(ParserUtil.parseBoolean((String)booleanValue, (boolean)false)));
        }
    }

    protected void handleScale(PropertyAttributes atts) {
        String booleanValue = atts.getValue(SCALE_ATT);
        if (booleanValue != null) {
            ImageElementFactory elementFactory = (ImageElementFactory)this.getElementFactory();
            elementFactory.setScale(new Boolean(ParserUtil.parseBoolean((String)booleanValue, (boolean)false)));
        }
    }

    protected void startParsing(PropertyAttributes atts) throws SAXException, XmlReaderException {
        super.startParsing(atts);
        this.handleScale(atts);
        this.handleKeepAspectRatio(atts);
    }
}

