/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.report.modules.parser.simple.readhandlers;

import java.awt.print.PageFormat;
import java.awt.print.Paper;
import org.jfree.report.JFreeReport;
import org.jfree.report.SimplePageDefinition;
import org.jfree.report.modules.parser.base.AbstractPropertyXmlReadHandler;
import org.jfree.report.modules.parser.base.CommentHintPath;
import org.jfree.report.modules.parser.base.PropertyAttributes;
import org.jfree.report.modules.parser.base.ReportParser;
import org.jfree.report.modules.parser.base.common.ConfigurationReadHandler;
import org.jfree.report.modules.parser.base.common.FunctionsReadHandler;
import org.jfree.report.modules.parser.base.common.IncludeReadHandler;
import org.jfree.report.modules.parser.simple.readhandlers.GroupsReadHandler;
import org.jfree.report.modules.parser.simple.readhandlers.PageBandReadHandler;
import org.jfree.report.modules.parser.simple.readhandlers.ParserConfigurationReadHandler;
import org.jfree.report.modules.parser.simple.readhandlers.ReportFooterReadHandler;
import org.jfree.report.modules.parser.simple.readhandlers.ReportHeaderReadHandler;
import org.jfree.report.modules.parser.simple.readhandlers.RootLevelBandReadHandler;
import org.jfree.report.util.PageFormatFactory;
import org.jfree.util.Log;
import org.jfree.xml.ParseException;
import org.jfree.xml.ParserUtil;
import org.jfree.xml.parser.XmlReadHandler;
import org.jfree.xml.parser.XmlReaderException;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class JFreeReportReadHandler
extends AbstractPropertyXmlReadHandler {
    public static final String REPORT_KEY = "::report";
    public static final String REPORT_TAG = "report";
    public static final String NAME_ATT = "name";
    public static final String PAGEFORMAT_ATT = "pageformat";
    public static final String PAGESPAN_ATT = "pagespan";
    public static final String UNIT_ATT = "unit";
    public static final String LEFTMARGIN_ATT = "leftmargin";
    public static final String RIGHTMARGIN_ATT = "rightmargin";
    public static final String TOPMARGIN_ATT = "topmargin";
    public static final String BOTTOMMARGIN_ATT = "bottommargin";
    public static final String WIDTH_ATT = "width";
    public static final String HEIGHT_ATT = "height";
    public static final String ORIENTATION_ATT = "orientation";
    public static final String ORIENTATION_PORTRAIT_VAL = "portrait";
    public static final String ORIENTATION_LANDSCAPE_VAL = "landscape";
    public static final String ORIENTATION_REVERSE_LANDSCAPE_VAL = "reverse_landscape";
    private JFreeReport report;

    private PageFormat createPageFormat(PageFormat format, Attributes atts) throws SAXException {
        int orientationVal;
        String pageformatName = atts.getValue(PAGEFORMAT_ATT);
        String orientation = atts.getValue(ORIENTATION_ATT);
        if (orientation == null) {
            orientationVal = 1;
        } else if (orientation.equals(ORIENTATION_LANDSCAPE_VAL)) {
            orientationVal = 0;
        } else if (orientation.equals(ORIENTATION_REVERSE_LANDSCAPE_VAL)) {
            orientationVal = 2;
        } else if (orientation.equals(ORIENTATION_PORTRAIT_VAL)) {
            orientationVal = 1;
        } else {
            throw new ParseException("Orientation value in REPORT-Tag is invalid.", this.getRootHandler().getLocator());
        }
        if (pageformatName != null) {
            Paper p = PageFormatFactory.getInstance().createPaper(pageformatName);
            if (p == null) {
                Log.warn((Object)("Unable to create the requested Paper. " + pageformatName));
                return format;
            }
            return PageFormatFactory.getInstance().createPageFormat(p, orientationVal);
        }
        if (atts.getValue(WIDTH_ATT) != null && atts.getValue(HEIGHT_ATT) != null) {
            int[] pageformatData = new int[]{ParserUtil.parseInt((String)atts.getValue(WIDTH_ATT), (String)"No Width set"), ParserUtil.parseInt((String)atts.getValue(HEIGHT_ATT), (String)"No Height set")};
            Paper p = PageFormatFactory.getInstance().createPaper(pageformatData);
            if (p == null) {
                Log.warn((Object)("Unable to create the requested Paper. Paper={" + pageformatData[0] + ", " + pageformatData[1] + "}"));
                return format;
            }
            return PageFormatFactory.getInstance().createPageFormat(p, orientationVal);
        }
        Log.info((Object)"Insufficient Data to create a pageformat: Returned default.");
        return format;
    }

    protected XmlReadHandler getHandlerForChild(String tagName, PropertyAttributes atts) throws XmlReaderException, SAXException {
        if (tagName.equals("configuration")) {
            return new ConfigurationReadHandler(this.report.getReportConfiguration());
        }
        if (tagName.equals("reportheader")) {
            return new ReportHeaderReadHandler(this.report.getReportHeader());
        }
        if (tagName.equals("reportfooter")) {
            return new ReportFooterReadHandler(this.report.getReportFooter());
        }
        if (tagName.equals("pageheader")) {
            return new PageBandReadHandler(this.report.getPageHeader());
        }
        if (tagName.equals("pagefooter")) {
            return new PageBandReadHandler(this.report.getPageFooter());
        }
        if (tagName.equals("watermark")) {
            return new RootLevelBandReadHandler(this.report.getWatermark());
        }
        if (tagName.equals("groups")) {
            return new GroupsReadHandler(this.report.getGroups());
        }
        if (tagName.equals("items")) {
            return new RootLevelBandReadHandler(this.report.getItemBand());
        }
        if (tagName.equals("functions")) {
            return new FunctionsReadHandler(this.report);
        }
        if (tagName.equals("include")) {
            return new IncludeReadHandler();
        }
        if (tagName.equals("parser-config")) {
            return new ParserConfigurationReadHandler();
        }
        return null;
    }

    public Object getObject() throws XmlReaderException {
        return this.report;
    }

    protected void startParsing(PropertyAttributes attrs) throws SAXException {
        Object maybeReport = this.getRootHandler().getHelperObject(REPORT_KEY);
        JFreeReport report = !(maybeReport instanceof JFreeReport) ? new JFreeReport() : (JFreeReport)maybeReport;
        ReportParser parser = (ReportParser)this.getRootHandler();
        if (!parser.isIncluded()) {
            String name = attrs.getValue(NAME_ATT);
            if (name != null) {
                report.setName(name);
            }
            PageFormat format = report.getPageDefinition().getPageFormat(0);
            float defTopMargin = (float)format.getImageableY();
            float defBottomMargin = (float)(format.getHeight() - format.getImageableHeight() - format.getImageableY());
            float defLeftMargin = (float)format.getImageableX();
            float defRightMargin = (float)(format.getWidth() - format.getImageableWidth() - format.getImageableX());
            format = this.createPageFormat(format, attrs);
            defTopMargin = ParserUtil.parseFloat((String)attrs.getValue(TOPMARGIN_ATT), (float)defTopMargin);
            defBottomMargin = ParserUtil.parseFloat((String)attrs.getValue(BOTTOMMARGIN_ATT), (float)defBottomMargin);
            defLeftMargin = ParserUtil.parseFloat((String)attrs.getValue(LEFTMARGIN_ATT), (float)defLeftMargin);
            defRightMargin = ParserUtil.parseFloat((String)attrs.getValue(RIGHTMARGIN_ATT), (float)defRightMargin);
            Paper p = format.getPaper();
            switch (format.getOrientation()) {
                case 1: {
                    PageFormatFactory.getInstance().setBorders(p, defTopMargin, defLeftMargin, defBottomMargin, defRightMargin);
                    break;
                }
                case 0: {
                    PageFormatFactory.getInstance().setBorders(p, defRightMargin, defTopMargin, defLeftMargin, defBottomMargin);
                    break;
                }
                case 2: {
                    PageFormatFactory.getInstance().setBorders(p, defLeftMargin, defBottomMargin, defRightMargin, defTopMargin);
                    break;
                }
                default: {
                    throw new IllegalStateException("Unexpected paper orientation.");
                }
            }
            int pageSpan = ParserUtil.parseInt((String)attrs.getValue(PAGESPAN_ATT), (int)1);
            format.setPaper(p);
            report.setPageDefinition(new SimplePageDefinition(format, pageSpan, 1));
        }
        this.getRootHandler().setHelperObject(REPORT_KEY, (Object)report);
        this.report = report;
    }

    protected void storeComments() throws SAXException {
        CommentHintPath hintPath = new CommentHintPath(this.report);
        this.defaultStoreComments(hintPath);
    }
}

