/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.report.modules.parser.simple.readhandlers;

import org.jfree.report.Band;
import org.jfree.report.modules.parser.base.PropertyAttributes;
import org.jfree.report.modules.parser.base.ReportParserUtil;
import org.jfree.report.modules.parser.simple.FontFactory;
import org.jfree.report.modules.parser.simple.readhandlers.BandReadHandler;
import org.jfree.report.style.BandStyleKeys;
import org.jfree.report.style.ElementStyleSheet;
import org.jfree.ui.FloatDimension;
import org.jfree.xml.ParserUtil;
import org.xml.sax.SAXException;

public class RootLevelBandReadHandler
extends BandReadHandler {
    public static final String FIXED_POSITION_ATTRIBUTE = "fixed-position";
    public static final String PAGEBREAK_BEFORE_ATTR = "pagebreak-before-print";
    public static final String HEIGHT_ATTRIBUTE = "height";
    public static final String PAGEBREAK_AFTER_ATTRIBUTE = "pagebreak-after-print";
    public static final String ALIGNMENT_ATT = "alignment";
    public static final String VALIGNMENT_ATT = "vertical-alignment";

    public RootLevelBandReadHandler(Band band) {
        super(band);
    }

    private void handleBreakAfter(PropertyAttributes attr) {
        String breakAfterAttr = attr.getValue(PAGEBREAK_AFTER_ATTRIBUTE);
        if (breakAfterAttr != null) {
            boolean breakAfter = ParserUtil.parseBoolean((String)breakAfterAttr, (boolean)false);
            this.getBand().getStyle().setBooleanStyleProperty(BandStyleKeys.PAGEBREAK_AFTER, breakAfter);
        }
    }

    private void handleBreakBefore(PropertyAttributes attr) {
        String breakBeforeAttr = attr.getValue(PAGEBREAK_BEFORE_ATTR);
        if (breakBeforeAttr != null) {
            boolean breakBefore = ParserUtil.parseBoolean((String)breakBeforeAttr, (boolean)false);
            this.getBand().getStyle().setBooleanStyleProperty(BandStyleKeys.PAGEBREAK_BEFORE, breakBefore);
        }
    }

    protected void handleFixedPosition(PropertyAttributes attr) throws SAXException {
        String fixedPos = attr.getValue(FIXED_POSITION_ATTRIBUTE);
        if (fixedPos != null) {
            float fixedPosValue = ParserUtil.parseFloat((String)fixedPos, (String)"FixedPosition is invalid!");
            this.getBand().getStyle().setStyleProperty(BandStyleKeys.FIXED_POSITION, new Float(fixedPosValue));
        }
    }

    private void handleHAlign(PropertyAttributes attr) throws SAXException {
        String halign = attr.getValue(ALIGNMENT_ATT);
        if (halign != null) {
            this.getBand().getStyle().setStyleProperty(ElementStyleSheet.ALIGNMENT, ReportParserUtil.parseHorizontalElementAlignment(halign));
        }
    }

    private void handleHeight(PropertyAttributes attr) {
        String height = attr.getValue(HEIGHT_ATTRIBUTE);
        if (height != null) {
            float heightValue = ParserUtil.parseFloat((String)height, (float)0.0f);
            this.getBand().getStyle().setStyleProperty(ElementStyleSheet.MINIMUMSIZE, new FloatDimension(0.0f, heightValue));
        }
    }

    private void handleVAlign(PropertyAttributes attr) throws SAXException {
        String valign = attr.getValue(VALIGNMENT_ATT);
        if (valign != null) {
            this.getBand().getStyle().setStyleProperty(ElementStyleSheet.VALIGNMENT, ReportParserUtil.parseVerticalElementAlignment(valign));
        }
    }

    protected boolean isManualBreakAllowed() {
        return true;
    }

    protected void startParsing(PropertyAttributes attr) throws SAXException {
        super.startParsing(attr);
        this.handleHeight(attr);
        if (this.isManualBreakAllowed()) {
            this.handleBreakAfter(attr);
            this.handleBreakBefore(attr);
        }
        this.handleVAlign(attr);
        this.handleHAlign(attr);
        FontFactory.FontInformation fi = FontFactory.createFont(attr);
        FontFactory.applyFontInformation(this.getBand().getStyle(), fi);
    }
}

