/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.report.resourceloader;

import java.awt.Image;
import java.awt.Toolkit;
import java.io.IOException;
import org.jfree.report.resourceloader.ImageFactoryModule;
import org.jfree.report.util.StringUtil;

public class GIFImageFactoryModule
implements ImageFactoryModule {
    private static final byte[] GIF_ID = new byte[]{71, 73, 70, 56};
    private static final String[] MIMETYPES = new String[]{"image/gif", "image/x-xbitmap", "image/gi_"};

    public boolean canHandleResourceByContent(byte[] content) {
        int i = 0;
        while (i < GIF_ID.length) {
            if (GIF_ID[i] != content[i]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public boolean canHandleResourceByMimeType(String name) {
        int i = 0;
        while (i < MIMETYPES.length) {
            if (name.equals(MIMETYPES[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean canHandleResourceByName(String name) {
        return StringUtil.endsWithIgnoreCase(name, ".gif");
    }

    public Image createImage(byte[] imageData, String fileName, String mimeType) throws IOException {
        return Toolkit.getDefaultToolkit().createImage(imageData);
    }

    public int getHeaderFingerprintSize() {
        return GIF_ID.length;
    }
}

