/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.report.states;

import org.jfree.report.Group;
import org.jfree.report.states.PreGroupFooterState;
import org.jfree.report.states.PreGroupHeaderState;
import org.jfree.report.states.PreReportFooterState;
import org.jfree.report.states.ReportState;

public final class PostGroupFooterState
extends ReportState {
    public PostGroupFooterState(ReportState previous) {
        super(previous);
    }

    public ReportState advance() {
        this.firePrepareEvent();
        this.leaveGroup();
        if (this.isLastGroup()) {
            if (this.hasMoreData()) {
                return new PreGroupHeaderState(this);
            }
            return new PreReportFooterState(this);
        }
        if (this.hasMoreData()) {
            Group group = this.getReport().getGroup(this.getCurrentGroupIndex());
            if (ReportState.isLastItemInGroup(group, this.getDataRowBackend(), this.getDataRowPreview())) {
                return new PreGroupFooterState(this);
            }
            return new PreGroupHeaderState(this);
        }
        return new PreGroupFooterState(this);
    }

    public int getEventCode() {
        return 4096;
    }

    private boolean hasMoreData() {
        return this.getCurrentDataItem() < this.getNumberOfRows() - 1;
    }

    private boolean isLastGroup() {
        return this.getCurrentGroupIndex() == -1;
    }

    private void leaveGroup() {
        this.setCurrentGroupIndex(this.getCurrentGroupIndex() - 1);
    }
}

