/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.report.states;

import java.util.Iterator;
import java.util.List;
import org.jfree.report.Band;
import org.jfree.report.DataRow;
import org.jfree.report.Group;
import org.jfree.report.JFreeReport;
import org.jfree.report.ReportDefinition;
import org.jfree.report.ReportProcessingException;
import org.jfree.report.event.LayoutEvent;
import org.jfree.report.event.ReportEvent;
import org.jfree.report.function.LevelledExpressionList;
import org.jfree.report.states.DataRowBackend;
import org.jfree.report.states.DataRowPreview;
import org.jfree.report.states.ReportDefinitionImpl;
import org.jfree.report.states.ReportStateProgress;
import org.jfree.report.util.ReportProperties;
import org.jfree.report.util.ReportPropertiesList;
import org.jfree.util.ObjectUtilities;

public abstract class ReportState
implements Cloneable {
    private ReportDefinitionImpl report;
    private int numberOfRows;
    private int currentDataItem;
    private int currentPage;
    private int currentGroupIndex;
    private ReportProperties reportProperties;
    private DataRowBackend dataRow;
    private DataRowPreview dataRowPreview;
    public static final int BEFORE_FIRST_ROW = -1;
    public static final int BEFORE_FIRST_GROUP = -1;
    public static final int BEFORE_FIRST_PAGE = 0;

    protected ReportState(JFreeReport reportPar) throws CloneNotSupportedException {
        this.setReportDefinition(new ReportDefinitionImpl(reportPar));
        this.numberOfRows = reportPar.getData().getRowCount();
        this.reportProperties = this.getReport().getProperties();
        LevelledExpressionList functions = new LevelledExpressionList(reportPar.getExpressions());
        DataRowBackend dr = new DataRowBackend();
        dr.setTablemodel(reportPar.getData());
        dr.setFunctions(functions);
        dr.setReportProperties(new ReportPropertiesList(this.reportProperties));
        this.getReportDefinition().getDataRowConnector().setDataRowBackend(dr);
        this.dataRow = dr;
        this.resetState();
    }

    protected ReportState(ReportState clone) {
        this(clone, false);
    }

    protected ReportState(ReportState clone, boolean reset) {
        this.setReportDefinition(clone.getReportDefinition());
        this.reportProperties = clone.reportProperties;
        this.numberOfRows = clone.getNumberOfRows();
        this.dataRowPreview = clone.dataRowPreview;
        this.dataRow = clone.getDataRowBackend();
        if (reset) {
            this.resetState();
        } else {
            this.setCurrentDataItem(clone.getCurrentDataItem());
            this.setCurrentPage(clone.getCurrentPage());
            this.setCurrentGroupIndex(clone.getCurrentGroupIndex());
            this.getDataRowBackend().setCurrentRow(this.getCurrentDisplayItem());
        }
    }

    public abstract ReportState advance() throws ReportProcessingException;

    public Object clone() throws CloneNotSupportedException {
        ReportState result = (ReportState)super.clone();
        result.report = (ReportDefinitionImpl)this.report.clone();
        result.dataRow = (DataRowBackend)this.dataRow.clone();
        result.report.getDataRowConnector().setDataRowBackend(result.dataRow);
        return result;
    }

    public PageBreakSaveState createPageProgressCopy() throws CloneNotSupportedException {
        return new PageBreakSaveState(this);
    }

    protected ReportState createShallowCopy() throws CloneNotSupportedException {
        return (ReportState)super.clone();
    }

    public ReportStateProgress createStateProgress(ReportStateProgress progress) {
        if (progress == null) {
            progress = new ReportStateProgress();
        }
        progress.setCurrentDataItem(this.getCurrentDataItem());
        progress.setCurrentGroupIndex(this.getCurrentGroupIndex());
        progress.setCurrentPage(this.getCurrentPage());
        progress.setStateClass(this.getClass());
        return progress;
    }

    public void fireGroupFinishedEvent() {
        this.getFunctions().groupFinished(new ReportEvent(this, 128));
    }

    public void fireGroupStartedEvent() {
        this.getFunctions().groupStarted(new ReportEvent(this, 8));
    }

    public void fireItemsAdvancedEvent() {
        this.getFunctions().itemsAdvanced(new ReportEvent(this, 32));
    }

    public void fireItemsFinishedEvent() {
        this.getFunctions().itemsFinished(new ReportEvent(this, 64));
    }

    public void fireItemsStartedEvent() {
        this.getFunctions().itemsStarted(new ReportEvent(this, 16));
    }

    public void fireLayoutCompleteEvent(Band band, int type) {
        this.getFunctions().layoutComplete(new LayoutEvent(this, band, 0x20000 | type));
    }

    public void fireOutputCompleteEvent(Band band, int type) {
        this.getFunctions().outputComplete(new LayoutEvent(this, band, 0x20000 | type));
    }

    public void firePageCanceledEvent() {
        this.getFunctions().pageCanceled(new ReportEvent(this, 2048));
    }

    public void firePageFinishedEvent() {
        this.getFunctions().pageFinished(new ReportEvent(this, 1024));
    }

    public void firePageStartedEvent(int baseEvent) {
        this.getFunctions().pageStarted(new ReportEvent(this, 2 | baseEvent));
    }

    public void firePrepareEvent() {
        this.getFunctions().firePrepareEvent(new ReportEvent(this, 0x2000000 | this.getEventCode()));
    }

    public void fireReportDoneEvent() {
        this.getFunctions().reportDone(new ReportEvent(this, 512));
    }

    public void fireReportFinishedEvent() {
        this.getFunctions().reportFinished(new ReportEvent(this, 256));
    }

    public void fireReportInitializedEvent() {
        this.getFunctions().reportInitialized(new ReportEvent(this, 1));
    }

    public void fireReportStartedEvent() {
        this.getFunctions().reportStarted(new ReportEvent(this, 4));
    }

    public int getCurrentDataItem() {
        return this.currentDataItem;
    }

    public final int getCurrentDisplayItem() {
        if (this.isPrefetchState()) {
            return this.currentDataItem + 1;
        }
        return this.currentDataItem;
    }

    public int getCurrentGroupIndex() {
        return this.currentGroupIndex;
    }

    public int getCurrentPage() {
        return this.currentPage;
    }

    public DataRow getDataRow() {
        return this.dataRow.getDataRow();
    }

    protected DataRowBackend getDataRowBackend() {
        return this.dataRow;
    }

    protected DataRowPreview getDataRowPreview() {
        if (this.dataRowPreview == null) {
            this.dataRowPreview = new DataRowPreview(this.getDataRowBackend());
        }
        this.dataRowPreview.update(this.getDataRowBackend());
        return this.dataRowPreview;
    }

    public List getErrors() {
        return this.getFunctions().getErrors();
    }

    public abstract int getEventCode();

    protected final LevelledExpressionList getFunctions() {
        if (this.dataRow.getFunctions().getDataRow() != this.dataRow.getDataRow()) {
            throw new IllegalStateException("Paranoia: Unconnected or invalid function datarow");
        }
        return this.dataRow.getFunctions();
    }

    public int getLevel() {
        return this.getFunctions().getLevel();
    }

    public Iterator getLevels() {
        return this.getFunctions().getLevelsDescending();
    }

    public int getNumberOfRows() {
        return this.numberOfRows;
    }

    public ReportProperties getProperties() {
        return this.reportProperties;
    }

    public Object getProperty(String key) {
        return this.reportProperties.get(key);
    }

    public Object getProperty(String key, Object def) {
        return this.reportProperties.get(key, def);
    }

    public ReportDefinition getReport() {
        return this.report;
    }

    protected ReportDefinitionImpl getReportDefinition() {
        return this.report;
    }

    protected final void handleRestore(DataRowBackend backend) {
        this.dataRow = backend;
        this.report.getDataRowConnector().setDataRowBackend(backend);
        this.dataRowPreview = null;
    }

    public boolean isErrorOccured() {
        return this.getFunctions().hasErrors();
    }

    public boolean isFinish() {
        return false;
    }

    public static boolean isLastItemInGroup(Group g, DataRowBackend currentDataRow, DataRowBackend nextDataRow) {
        if (currentDataRow.isLastRow() || nextDataRow == null) {
            return true;
        }
        String[] fieldsCached = g.getFieldsArray();
        int i = 0;
        while (i < fieldsCached.length) {
            Object item2;
            Object item1;
            int column2;
            String field = fieldsCached[i];
            int column1 = currentDataRow.findColumn(field);
            if (column1 != -1 && (column2 = nextDataRow.findColumn(field)) != -1 && !ObjectUtilities.equal((Object)(item1 = currentDataRow.get(column1)), (Object)(item2 = nextDataRow.get(column2)))) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean isPrefetchState() {
        return false;
    }

    public boolean isPrepareRun() {
        Boolean bool = (Boolean)this.getProperty("report.preparerun", Boolean.FALSE);
        return bool;
    }

    public boolean isProceeding(ReportStateProgress oldstate) {
        if (this.getCurrentGroupIndex() != oldstate.getCurrentGroupIndex()) {
            return true;
        }
        if (this.getCurrentDataItem() > oldstate.getCurrentDataItem()) {
            return true;
        }
        return !this.getClass().equals(oldstate.getStateClass());
    }

    public boolean isStart() {
        return false;
    }

    public void nextPage() {
        this.setCurrentPage(this.getCurrentPage() + 1);
    }

    protected void resetState() {
        this.setCurrentDataItem(-1);
        this.setCurrentPage(0);
        this.setCurrentGroupIndex(-1);
        this.getDataRowBackend().setCurrentRow(this.getCurrentDisplayItem());
    }

    protected void setCurrentDataItem(int itemIndex) {
        this.currentDataItem = itemIndex;
    }

    protected void setCurrentGroupIndex(int index) {
        if (index < -1) {
            throw new IllegalArgumentException("GroupIndex must be >= 0 or BEFORE_FIRST_GROUP");
        }
        this.currentGroupIndex = index;
    }

    protected void setCurrentPage(int page) {
        if (page < 0) {
            throw new IllegalArgumentException("Page must be >= 0");
        }
        this.currentPage = page;
    }

    public void setProperty(String key, Object o) {
        this.reportProperties.put(key, o);
    }

    private void setReportDefinition(ReportDefinitionImpl report) {
        if (report == null) {
            throw new NullPointerException("A ReportState without a report is not allowed");
        }
        this.report = report;
    }

    public static final class PageBreakSaveState {
        private DataRowBackend backend;
        private ReportState state;

        public PageBreakSaveState(ReportState state) throws CloneNotSupportedException {
            this.backend = (DataRowBackend)state.getDataRowBackend().clone();
            this.state = state.createShallowCopy();
        }

        public ReportState restorePageProgressCopy() {
            ReportState result = this.state;
            result.handleRestore(this.backend);
            return result;
        }
    }
}

