/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.report.util.geom;

import java.io.Serializable;

public class StrictDimension
implements Serializable,
Cloneable {
    private long width;
    private long height;
    private boolean locked;

    public StrictDimension() {
    }

    public StrictDimension(long width, long height) {
        this.width = width;
        this.height = height;
    }

    public Object clone() {
        try {
            return (StrictDimension)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError("Clone must always be supported.");
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StrictDimension that = (StrictDimension)o;
        if (this.height != that.height) {
            return false;
        }
        return this.width == that.width;
    }

    public long getHeight() {
        return this.height;
    }

    public StrictDimension getLockedInstance() {
        if (this.locked) {
            return this;
        }
        StrictDimension retval = (StrictDimension)this.clone();
        retval.locked = true;
        return retval;
    }

    public StrictDimension getUnlockedInstance() {
        StrictDimension retval = (StrictDimension)this.clone();
        retval.locked = false;
        return retval;
    }

    public long getWidth() {
        return this.width;
    }

    public int hashCode() {
        int result = (int)(this.width ^ this.width >>> 32);
        result = 29 * result + (int)(this.height ^ this.height >>> 32);
        return result;
    }

    public boolean isLocked() {
        return this.locked;
    }

    public void setHeight(long height) {
        if (this.locked) {
            throw new IllegalStateException("This object is locked");
        }
        this.height = height;
    }

    public void setSize(long width, long height) {
        if (this.locked) {
            throw new IllegalStateException("This object is locked");
        }
        this.width = width;
        this.height = height;
    }

    public void setWidth(long width) {
        if (this.locked) {
            throw new IllegalStateException("This object is locked");
        }
        this.width = width;
    }

    public String toString() {
        return "org.jfree.report.util.geom.StrictDimension{width=" + this.width + ", height=" + this.height + "}";
    }
}

