/*
 * Decompiled with CFR 0.152.
 */
package mockit.external.asm.commons;

import java.util.ArrayList;
import java.util.List;
import mockit.external.asm.MethodVisitor;
import mockit.external.asm.Type;
import mockit.external.asm.commons.LocalVariablesSorter;
import mockit.external.asm.commons.Method;

public final class GeneratorAdapter
extends LocalVariablesSorter {
    private static final Type BYTE_TYPE = Type.getType("Ljava/lang/Byte;");
    private static final Type BOOLEAN_TYPE = Type.getType("Ljava/lang/Boolean;");
    private static final Type SHORT_TYPE = Type.getType("Ljava/lang/Short;");
    private static final Type CHARACTER_TYPE = Type.getType("Ljava/lang/Character;");
    private static final Type INTEGER_TYPE = Type.getType("Ljava/lang/Integer;");
    private static final Type FLOAT_TYPE = Type.getType("Ljava/lang/Float;");
    private static final Type LONG_TYPE = Type.getType("Ljava/lang/Long;");
    private static final Type DOUBLE_TYPE = Type.getType("Ljava/lang/Double;");
    private static final Type NUMBER_TYPE = Type.getType("Ljava/lang/Number;");
    private static final Type OBJECT_TYPE = Type.getType("Ljava/lang/Object;");
    private static final Method BOOLEAN_VALUE = Method.getMethod("boolean booleanValue()");
    private static final Method CHAR_VALUE = Method.getMethod("char charValue()");
    private static final Method INT_VALUE = Method.getMethod("int intValue()");
    private static final Method FLOAT_VALUE = Method.getMethod("float floatValue()");
    private static final Method LONG_VALUE = Method.getMethod("long longValue()");
    private static final Method DOUBLE_VALUE = Method.getMethod("double doubleValue()");
    public static final int AND = 126;
    public static final int OR = 128;
    private final Type returnType;
    private final List<Type> localTypes;

    public GeneratorAdapter(MethodVisitor mv, int access, String desc) {
        super(access, desc, mv);
        this.returnType = Type.getReturnType(desc);
        this.localTypes = new ArrayList<Type>();
    }

    public void push(boolean value) {
        this.push(value ? 1 : 0);
    }

    public void push(int value) {
        if (value >= -1 && value <= 5) {
            this.mv.visitInsn(3 + value);
        } else if (value >= -128 && value <= 127) {
            this.mv.visitIntInsn(16, value);
        } else if (value >= Short.MIN_VALUE && value <= Short.MAX_VALUE) {
            this.mv.visitIntInsn(17, value);
        } else {
            this.mv.visitLdcInsn(value);
        }
    }

    public void push(long value) {
        if (value == 0L || value == 1L) {
            this.mv.visitInsn(9 + (int)value);
        } else {
            this.mv.visitLdcInsn(value);
        }
    }

    public void push(float value) {
        int bits = Float.floatToIntBits(value);
        if ((long)bits == 0L || bits == 1065353216 || bits == 0x40000000) {
            this.mv.visitInsn(11 + (int)value);
        } else {
            this.mv.visitLdcInsn(Float.valueOf(value));
        }
    }

    public void push(double value) {
        long bits = Double.doubleToLongBits(value);
        if (bits == 0L || bits == 0x3FF0000000000000L) {
            this.mv.visitInsn(14 + (int)value);
        } else {
            this.mv.visitLdcInsn(value);
        }
    }

    public void push(String value) {
        if (value == null) {
            this.mv.visitInsn(1);
        } else {
            this.mv.visitLdcInsn(value);
        }
    }

    public void push(Type value) {
        if (value == null) {
            this.mv.visitInsn(1);
        } else {
            this.mv.visitLdcInsn(value);
        }
    }

    public int newLocal(Type type) {
        int local = this.newLocal(type.getSize());
        this.setLocalType(local, type);
        return local;
    }

    private void setLocalType(int local, Type type) {
        int index = local - this.firstLocal;
        while (this.localTypes.size() < index + 1) {
            this.localTypes.add(null);
        }
        this.localTypes.set(index, type);
    }

    public void arrayLoad(Type type) {
        this.mv.visitInsn(type.getOpcode(46));
    }

    public void pop() {
        this.mv.visitInsn(87);
    }

    public void pop2() {
        this.mv.visitInsn(88);
    }

    public void dupX1() {
        this.mv.visitInsn(90);
    }

    public void dupX2() {
        this.mv.visitInsn(91);
    }

    public void dup2X1() {
        this.mv.visitInsn(93);
    }

    public void dup2X2() {
        this.mv.visitInsn(94);
    }

    public void swap() {
        this.mv.visitInsn(95);
    }

    public void swap(Type prev, Type type) {
        if (type.getSize() == 1) {
            if (prev.getSize() == 1) {
                this.swap();
            } else {
                this.dupX2();
                this.pop();
            }
        } else if (prev.getSize() == 1) {
            this.dup2X1();
            this.pop2();
        } else {
            this.dup2X2();
            this.pop2();
        }
    }

    public void math(int op, Type type) {
        this.mv.visitInsn(type.getOpcode(op));
    }

    public void not() {
        this.mv.visitInsn(4);
        this.mv.visitInsn(130);
    }

    public void cast(Type from, Type to) {
        if (from != to) {
            if (from == Type.DOUBLE_TYPE) {
                if (to == Type.FLOAT_TYPE) {
                    this.mv.visitInsn(144);
                } else if (to == Type.LONG_TYPE) {
                    this.mv.visitInsn(143);
                } else {
                    this.mv.visitInsn(142);
                    this.cast(Type.INT_TYPE, to);
                }
            } else if (from == Type.FLOAT_TYPE) {
                if (to == Type.DOUBLE_TYPE) {
                    this.mv.visitInsn(141);
                } else if (to == Type.LONG_TYPE) {
                    this.mv.visitInsn(140);
                } else {
                    this.mv.visitInsn(139);
                    this.cast(Type.INT_TYPE, to);
                }
            } else if (from == Type.LONG_TYPE) {
                if (to == Type.DOUBLE_TYPE) {
                    this.mv.visitInsn(138);
                } else if (to == Type.FLOAT_TYPE) {
                    this.mv.visitInsn(137);
                } else {
                    this.mv.visitInsn(136);
                    this.cast(Type.INT_TYPE, to);
                }
            } else if (to == Type.BYTE_TYPE) {
                this.mv.visitInsn(145);
            } else if (to == Type.CHAR_TYPE) {
                this.mv.visitInsn(146);
            } else if (to == Type.DOUBLE_TYPE) {
                this.mv.visitInsn(135);
            } else if (to == Type.FLOAT_TYPE) {
                this.mv.visitInsn(134);
            } else if (to == Type.LONG_TYPE) {
                this.mv.visitInsn(133);
            } else if (to == Type.SHORT_TYPE) {
                this.mv.visitInsn(147);
            }
        }
    }

    public void box(Type type) {
        if (type.getSort() == 10 || type.getSort() == 9) {
            return;
        }
        if (type == Type.VOID_TYPE) {
            this.push((String)null);
        } else {
            Type boxed = type;
            switch (type.getSort()) {
                case 3: {
                    boxed = BYTE_TYPE;
                    break;
                }
                case 1: {
                    boxed = BOOLEAN_TYPE;
                    break;
                }
                case 4: {
                    boxed = SHORT_TYPE;
                    break;
                }
                case 2: {
                    boxed = CHARACTER_TYPE;
                    break;
                }
                case 5: {
                    boxed = INTEGER_TYPE;
                    break;
                }
                case 6: {
                    boxed = FLOAT_TYPE;
                    break;
                }
                case 7: {
                    boxed = LONG_TYPE;
                    break;
                }
                case 8: {
                    boxed = DOUBLE_TYPE;
                }
            }
            this.newInstance(boxed);
            if (type.getSize() == 2) {
                this.dupX2();
                this.dupX2();
                this.pop();
            } else {
                this.dupX1();
                this.swap();
            }
            this.invokeConstructor(boxed, new Method("<init>", Type.VOID_TYPE, new Type[]{type}));
        }
    }

    public void unbox(Type type) {
        Type t = NUMBER_TYPE;
        Method sig = null;
        switch (type.getSort()) {
            case 0: {
                return;
            }
            case 2: {
                t = CHARACTER_TYPE;
                sig = CHAR_VALUE;
                break;
            }
            case 1: {
                t = BOOLEAN_TYPE;
                sig = BOOLEAN_VALUE;
                break;
            }
            case 8: {
                sig = DOUBLE_VALUE;
                break;
            }
            case 6: {
                sig = FLOAT_VALUE;
                break;
            }
            case 7: {
                sig = LONG_VALUE;
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                sig = INT_VALUE;
            }
        }
        if (sig == null) {
            this.checkCast(type);
        } else {
            this.checkCast(t);
            this.invokeVirtual(t, sig);
        }
    }

    public void returnValue() {
        this.mv.visitInsn(this.returnType.getOpcode(172));
    }

    private void invokeInsn(int opcode, Type type, Method method) {
        String owner = type.getSort() == 9 ? type.getDescriptor() : type.getInternalName();
        this.mv.visitMethodInsn(opcode, owner, method.getName(), method.getDescriptor());
    }

    public void invokeVirtual(Type owner, Method method) {
        this.invokeInsn(182, owner, method);
    }

    public void invokeConstructor(Type type, Method method) {
        this.invokeInsn(183, type, method);
    }

    private void typeInsn(int opcode, Type type) {
        String desc = type.getSort() == 9 ? type.getDescriptor() : type.getInternalName();
        this.mv.visitTypeInsn(opcode, desc);
    }

    public void newInstance(Type type) {
        this.typeInsn(187, type);
    }

    public void checkCast(Type type) {
        if (!type.equals(OBJECT_TYPE)) {
            this.typeInsn(192, type);
        }
    }
}

