/*
 * Decompiled with CFR 0.152.
 */
package mockit.external.hamcrest.number;

import mockit.external.hamcrest.Description;
import mockit.external.hamcrest.TypeSafeMatcher;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class IsCloseTo
extends TypeSafeMatcher<Number> {
    private final double delta;
    private final double value;

    public IsCloseTo(double value, double error) {
        this.delta = error;
        this.value = value;
    }

    @Override
    public boolean matchesSafely(Number item) {
        return this.actualDelta(item) <= 0.0;
    }

    @Override
    public void describeMismatchSafely(Number item, Description description) {
        description.appendValue(item).appendText(" differed by ").appendValue(this.actualDelta(item));
    }

    @Override
    public void describeTo(Description description) {
        description.appendText("a numeric value within ").appendValue(this.delta).appendText(" of ").appendValue(this.value);
    }

    private double actualDelta(Number item) {
        return Math.abs(item.doubleValue() - this.value) - this.delta;
    }
}

