/*
 * Decompiled with CFR 0.152.
 */
package mockit.integration.junit3.internal;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import junit.framework.Assert;
import junit.framework.TestCase;
import mockit.Mock;
import mockit.MockClass;
import mockit.integration.TestRunnerDecorator;
import mockit.internal.expectations.RecordAndReplayExecution;
import mockit.internal.state.SavePoint;
import mockit.internal.state.TestRun;
import mockit.internal.util.Utilities;

@MockClass(realClass=TestCase.class)
public final class JUnitTestCaseDecorator
extends TestRunnerDecorator {
    private static final Method setUpMethod;
    private static final Method tearDownMethod;
    private static final Method runTestMethod;
    private static final Field fName;
    public TestCase it;

    @Mock
    public void runBare() throws Throwable {
        this.updateTestClassState(this.it, this.it.getClass());
        TestRun.setRunningIndividualTest(this.it);
        TestRun.generateIdForNextTest();
        try {
            this.originalRunBare();
        }
        catch (Throwable t) {
            Utilities.filterStackTrace(t);
            throw t;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void originalRunBare() throws Throwable {
        setUpMethod.invoke((Object)this.it, new Object[0]);
        Object exception = null;
        try {
            this.runTest();
            exception = this.endTestExecution(true);
        }
        catch (Throwable running) {
            this.endTestExecution(false);
            exception = running;
        }
        finally {
            block13: {
                TestRun.setRunningTestMethod(null);
                try {
                    tearDownMethod.invoke((Object)this.it, new Object[0]);
                }
                catch (Throwable tearingDown) {
                    if (exception != null) break block13;
                    exception = tearingDown;
                }
            }
        }
        if (exception != null) {
            throw exception;
        }
    }

    @Mock(reentrant=true)
    public void runTest() throws Throwable {
        String testMethodName = (String)fName.get(this.it);
        Method testMethod = this.findTestMethod(testMethodName);
        if (testMethod == null) {
            Assert.fail((String)("Method \"" + testMethodName + "\" not found"));
        }
        TestRun.setRunningTestMethod(testMethod);
        SavePoint savePoint = new SavePoint();
        Object[] args = this.createInstancesForMockParametersIfAny(this.it, testMethod, Utilities.NO_ARGS);
        try {
            if (args.length == 0) {
                runTestMethod.invoke((Object)this.it, new Object[0]);
            } else {
                testMethod.invoke((Object)this.it, args);
            }
        }
        catch (InvocationTargetException e) {
            e.fillInStackTrace();
            throw e.getTargetException();
        }
        catch (IllegalAccessException e) {
            e.fillInStackTrace();
            throw e;
        }
        finally {
            this.rollbackToSavePoint(savePoint);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void rollbackToSavePoint(SavePoint savePoint) {
        TestRun.enterNoMockingZone();
        try {
            savePoint.rollback();
        }
        finally {
            TestRun.exitNoMockingZone();
        }
    }

    private Method findTestMethod(String testMethodName) {
        for (Method publicMethod : this.it.getClass().getMethods()) {
            if (!publicMethod.getName().equals(testMethodName)) continue;
            return publicMethod;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AssertionError endTestExecution(boolean nothingThrownByTestMethod) {
        AssertionError expectationsFailure = RecordAndReplayExecution.endCurrentReplayIfAny();
        try {
            if (nothingThrownByTestMethod && expectationsFailure == null) {
                TestRun.verifyExpectationsOnAnnotatedMocks();
            }
        }
        catch (AssertionError e) {
            expectationsFailure = e;
        }
        finally {
            TestRun.resetExpectationsOnAnnotatedMocks();
        }
        TestRun.finishCurrentTestExecution();
        return expectationsFailure;
    }

    static {
        try {
            setUpMethod = TestCase.class.getDeclaredMethod("setUp", new Class[0]);
            tearDownMethod = TestCase.class.getDeclaredMethod("tearDown", new Class[0]);
            runTestMethod = TestCase.class.getDeclaredMethod("runTest", new Class[0]);
            fName = TestCase.class.getDeclaredField("fName");
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
        catch (NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
        setUpMethod.setAccessible(true);
        tearDownMethod.setAccessible(true);
        runTestMethod.setAccessible(true);
        fName.setAccessible(true);
    }
}

