/*
 * Decompiled with CFR 0.152.
 */
package mockit.integration.testng.internal;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import mockit.Mock;
import mockit.MockClass;
import mockit.Mockit;
import mockit.integration.TestRunnerDecorator;
import mockit.internal.expectations.RecordAndReplayExecution;
import mockit.internal.state.SavePoint;
import mockit.internal.state.TestRun;
import mockit.internal.util.Utilities;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;
import org.testng.internal.MethodHelper;
import org.testng.internal.Parameters;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@MockClass(realClass=MethodHelper.class)
public final class TestNGTestRunnerDecorator
extends TestRunnerDecorator {
    private final ThreadLocal<SavePoint> savePoint = new ThreadLocal();
    private boolean generateTestIdForNextBeforeMethod;

    public TestNGTestRunnerDecorator() {
        Mockit.stubOutClass(Parameters.class, "checkParameterTypes");
    }

    @Mock(reentrant=true)
    public Object invokeMethod(Method method, Object instance, Object[] parameters) throws InvocationTargetException, IllegalAccessException {
        Class<?> testClass = instance == null ? method.getDeclaringClass() : instance.getClass();
        this.updateTestClassState(instance, testClass);
        if (!this.isTestMethod(testClass, method)) {
            if (this.generateTestIdForNextBeforeMethod && method.isAnnotationPresent(BeforeMethod.class)) {
                TestRun.generateIdForNextTest();
                this.generateTestIdForNextBeforeMethod = false;
            }
            TestRun.setRunningIndividualTest(instance);
            TestRun.setRunningTestMethod(null);
            try {
                Object object = MethodHelper.invokeMethod((Method)method, (Object)instance, (Object[])parameters);
                return object;
            }
            catch (InvocationTargetException t) {
                RecordAndReplayExecution.endCurrentReplayIfAny();
                Utilities.filterStackTrace(t);
                throw t;
            }
            finally {
                TestRun.setRunningIndividualTest(null);
            }
        }
        this.savePoint.set(new SavePoint());
        if (!this.isMethodWithParametersProvidedByTestNG(method)) {
            parameters = this.createInstancesForMockParametersIfAny(this, method, parameters);
        }
        if (this.generateTestIdForNextBeforeMethod) {
            TestRun.generateIdForNextTest();
        }
        TestRun.setRunningIndividualTest(instance);
        TestRun.setRunningTestMethod(method);
        this.generateTestIdForNextBeforeMethod = true;
        return this.executeTestMethod(instance, method, parameters);
    }

    private boolean isTestMethod(Class<?> testClass, Method method) {
        return method.isAnnotationPresent(Test.class) || testClass.isAnnotationPresent(Test.class) && Modifier.isPublic(method.getModifiers()) && method.getDeclaredAnnotations().length == 0;
    }

    private boolean isMethodWithParametersProvidedByTestNG(Method method) {
        if (method.isAnnotationPresent(org.testng.annotations.Parameters.class)) {
            return true;
        }
        Test testMetadata = method.getAnnotation(Test.class);
        return testMetadata != null && testMetadata.dataProvider().length() > 0;
    }

    private Object executeTestMethod(Object instance, Method method, Object[] parameters) throws InvocationTargetException, IllegalAccessException {
        try {
            Object result = MethodHelper.invokeMethod((Method)method, (Object)instance, (Object[])parameters);
            AssertionError error = RecordAndReplayExecution.endCurrentReplayIfAny();
            if (error != null) {
                Utilities.filterStackTrace((Throwable)((Object)error));
                throw error;
            }
            TestRun.verifyExpectationsOnAnnotatedMocks();
            Object object = result;
            return object;
        }
        catch (InvocationTargetException e) {
            RecordAndReplayExecution.endCurrentReplayIfAny();
            Utilities.filterStackTrace(e.getCause());
            throw e;
        }
        catch (IllegalAccessException e) {
            RecordAndReplayExecution.endCurrentReplayIfAny();
            throw e;
        }
        finally {
            this.cleanUpAfterTestMethodExecution();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cleanUpAfterTestMethodExecution() {
        TestRun.enterNoMockingZone();
        try {
            TestRun.resetExpectationsOnAnnotatedMocks();
            TestRun.finishCurrentTestExecution();
            this.savePoint.get().rollback();
            this.savePoint.set(null);
        }
        finally {
            TestRun.exitNoMockingZone();
        }
    }
}

