/*
 * Decompiled with CFR 0.152.
 */
package mockit.internal.capturing;

import java.lang.reflect.Proxy;
import mockit.Capturing;
import mockit.internal.util.Utilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class CapturedType {
    final Class<?> baseType;
    private final String[] classNameFilters;
    private final boolean inverseFilters;

    CapturedType(Class<?> baseType, Capturing capturing) {
        if (capturing == null) {
            this.baseType = baseType;
            this.classNameFilters = null;
            this.inverseFilters = false;
        } else {
            this.classNameFilters = capturing.classNames();
            this.inverseFilters = capturing.inverse();
            Class<?> specifiedBaseType = capturing.baseType();
            if (specifiedBaseType == Void.class) {
                if (baseType == null) {
                    throw new IllegalArgumentException("Missing base type in @Capturing annotation at class level");
                }
                this.baseType = baseType;
            } else {
                this.baseType = specifiedBaseType;
            }
        }
    }

    boolean isToBeCaptured(Class<?> aClass) {
        return aClass != this.baseType && !Proxy.isProxyClass(aClass) && this.baseType.isAssignableFrom(aClass) && this.isToBeCaptured(aClass.getName());
    }

    boolean isToBeCaptured(String className) {
        if (Utilities.isGeneratedClass(className)) {
            return false;
        }
        if (this.classNameFilters == null || this.classNameFilters.length == 0) {
            return true;
        }
        for (String classNameRegex : this.classNameFilters) {
            if (!className.matches(classNameRegex)) continue;
            return !this.inverseFilters;
        }
        return this.inverseFilters;
    }
}

