/*
 * Decompiled with CFR 0.152.
 */
package mockit.internal.expectations.invocation;

import java.lang.reflect.Method;
import mockit.Delegate;
import mockit.external.asm.Type;
import mockit.internal.expectations.invocation.DynamicInvocationResult;
import mockit.internal.expectations.invocation.ExpectedInvocation;
import mockit.internal.expectations.invocation.InvocationConstraints;
import mockit.internal.util.Utilities;

final class DelegatedResult
extends DynamicInvocationResult {
    DelegatedResult(Delegate delegate) {
        super(delegate, DelegatedResult.findDelegateMethodIfSingle(delegate));
    }

    private static Method findDelegateMethodIfSingle(Delegate delegate) {
        Method[] declaredMethods = delegate.getClass().getDeclaredMethods();
        return declaredMethods.length == 1 ? declaredMethods[0] : null;
    }

    Object produceResult(Object invokedObject, ExpectedInvocation invocation, InvocationConstraints constraints, Object[] args) throws Throwable {
        if (this.methodToInvoke == null) {
            String methodName = this.adaptNameAndArgumentsForDelegate(invocation, args);
            this.methodToInvoke = Utilities.findCompatibleMethod(this.targetObject, methodName, args);
            this.determineWhetherMethodToInvokeHasInvocationParameter();
        } else if (this.numberOfRegularParameters == 0 && args.length > 0) {
            args = Utilities.NO_ARGS;
        }
        return this.invokeMethodOnTargetObject(invokedObject, constraints, args);
    }

    private String adaptNameAndArgumentsForDelegate(ExpectedInvocation invocation, Object[] args) {
        String methodNameAndDesc = invocation.getMethodNameAndDescription();
        int leftParen = methodNameAndDesc.indexOf(40);
        this.replaceNullArgumentsWithClassObjectsIfAny(methodNameAndDesc, leftParen, args);
        String methodName = methodNameAndDesc.substring(0, leftParen);
        if ("<init>".equals(methodName)) {
            methodName = "$init";
        }
        return methodName;
    }

    private void replaceNullArgumentsWithClassObjectsIfAny(String methodNameAndDesc, int leftParen, Object[] args) {
        Type[] argTypes = null;
        for (int i = 0; i < args.length; ++i) {
            if (args[i] != null) continue;
            if (argTypes == null) {
                String methodDesc = methodNameAndDesc.substring(leftParen);
                argTypes = Type.getArgumentTypes(methodDesc);
            }
            args[i] = Utilities.getClassForType((Type)argTypes[i]);
        }
    }
}

