/*
 * Decompiled with CFR 0.152.
 */
package mockit.internal.expectations.mocking;

import java.lang.instrument.ClassDefinition;
import java.lang.reflect.Modifier;
import java.lang.reflect.Proxy;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import mockit.Mockit;
import mockit.external.asm.ClassReader;
import mockit.external.asm.ClassWriter;
import mockit.internal.ClassFile;
import mockit.internal.RedefinitionEngine;
import mockit.internal.expectations.mocking.ExpectationsModifier;
import mockit.internal.expectations.mocking.InstanceFactory;
import mockit.internal.expectations.mocking.InterfaceImplementationGenerator;
import mockit.internal.expectations.mocking.MockedType;
import mockit.internal.expectations.mocking.SubclassGenerationModifier;
import mockit.internal.filtering.MockingConfiguration;
import mockit.internal.state.TestRun;
import mockit.internal.util.Utilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class BaseTypeRedefinition {
    private static final Map<Integer, MockedClass> mockedClasses = new HashMap<Integer, MockedClass>();
    private static final Map<Class<?>, Class<?>> mockInterfaces = new HashMap();
    Class<?> targetClass;
    MockedType typeMetadata;
    InstanceFactory instanceFactory;
    MockingConfiguration mockingCfg;
    private List<ClassDefinition> mockedClassDefinitions;

    BaseTypeRedefinition(Class<?> mockedType) {
        this.targetClass = mockedType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final Object redefineType(Type typeToMock) {
        Object mock;
        TestRun.getExecutingTest().setShouldIgnoreMockingCallbacks(true);
        try {
            if (this.targetClass == null || this.targetClass.isInterface()) {
                this.createMockedInterfaceImplementation(typeToMock);
                mock = this.instanceFactory.create();
            } else {
                mock = this.createNewInstanceOfTargetClass();
            }
        }
        finally {
            TestRun.getExecutingTest().setShouldIgnoreMockingCallbacks(false);
        }
        TestRun.mockFixture().addInstanceForMockedType(this.targetClass, this.instanceFactory);
        return mock;
    }

    private void createMockedInterfaceImplementation(Type typeToMock) {
        Class<?> mockedInterface = this.interfaceToMock(typeToMock);
        if (mockedInterface == null) {
            this.createMockInterfaceImplementationUsingStandardProxy(typeToMock);
            return;
        }
        Class<?> mockClass = mockInterfaces.get(mockedInterface);
        if (mockClass != null) {
            this.targetClass = mockClass;
            if (this.typeMetadata != null && this.typeMetadata.fieldFromTestClass) {
                this.instanceFactory = TestRun.mockFixture().getMockedTypesAndInstances().get(mockClass);
            } else {
                this.createNewMockInstanceFactoryForInterface();
            }
            return;
        }
        this.generateNewMockImplementationClassForInterface(mockedInterface);
        this.createNewMockInstanceFactoryForInterface();
        mockInterfaces.put(mockedInterface, this.targetClass);
    }

    private Class<?> interfaceToMock(Type typeToMock) {
        Class theInterface;
        if (typeToMock instanceof Class && Modifier.isPublic((theInterface = (Class)typeToMock).getModifiers()) && !theInterface.isAnnotation()) {
            return theInterface;
        }
        return null;
    }

    private void createMockInterfaceImplementationUsingStandardProxy(Type typeToMock) {
        Object mock = Mockit.newEmptyProxy(typeToMock);
        this.targetClass = mock.getClass();
        this.redefineMethodsAndConstructorsInTargetType();
        this.instanceFactory = new InstanceFactory.InterfaceInstanceFactory(mock);
    }

    private void generateNewMockImplementationClassForInterface(Class<?> mockedInterface) {
        ClassReader interfaceReader = ClassFile.createClassFileReader(mockedInterface.getName());
        String mockClassName = "$Impl_" + mockedInterface.getSimpleName();
        InterfaceImplementationGenerator modifier = new InterfaceImplementationGenerator(interfaceReader, mockClassName);
        interfaceReader.accept(modifier, true);
        final byte[] generatedClass = modifier.toByteArray();
        this.targetClass = new ClassLoader(){

            @Override
            protected Class<?> findClass(String name) {
                return this.defineClass(name, generatedClass, 0, generatedClass.length);
            }
        }.findClass(mockClassName);
    }

    private void createNewMockInstanceFactoryForInterface() {
        Object mock = Utilities.newInstanceUsingDefaultConstructor(this.targetClass);
        this.instanceFactory = new InstanceFactory.InterfaceInstanceFactory(mock);
    }

    final void redefineMethodsAndConstructorsInTargetType() {
        this.redefineClassAndItsSuperClasses(this.targetClass);
    }

    private void redefineClassAndItsSuperClasses(Class<?> realClass) {
        ClassReader classReader = this.createClassReader(realClass);
        ExpectationsModifier modifier = this.createModifier(realClass, classReader);
        this.redefineClass(realClass, classReader, modifier);
        Class<?> superClass = realClass.getSuperclass();
        if (superClass != null && superClass != Object.class && superClass != Proxy.class) {
            this.redefineClassAndItsSuperClasses(superClass);
        }
    }

    abstract ExpectationsModifier createModifier(Class<?> var1, ClassReader var2);

    private void redefineClass(Class<?> realClass, ClassReader classReader, ClassWriter modifier) {
        classReader.accept(modifier, false);
        byte[] modifiedClass = modifier.toByteArray();
        ClassDefinition classDefinition = new ClassDefinition(realClass, modifiedClass);
        RedefinitionEngine.redefineClasses(classDefinition);
        if (this.mockedClassDefinitions != null) {
            this.mockedClassDefinitions.add(classDefinition);
        }
    }

    private ClassReader createClassReader(Class<?> realClass) {
        return new ClassFile(realClass, true).getReader();
    }

    private Object createNewInstanceOfTargetClass() {
        this.createInstanceFactoryForRedefinedClass();
        TestRun.exitNoMockingZone();
        try {
            Object object = this.instanceFactory.create();
            return object;
        }
        catch (ExceptionInInitializerError e) {
            Utilities.filterStackTrace(e);
            Utilities.filterStackTrace(e.getCause());
            e.printStackTrace();
            throw e;
        }
        finally {
            TestRun.enterNoMockingZone();
        }
    }

    private void createInstanceFactoryForRedefinedClass() {
        Integer mockedClassId = this.redefineClassesFromCache();
        if (mockedClassId == null) {
            return;
        }
        if (this.targetClass.isEnum()) {
            this.instanceFactory = new InstanceFactory.EnumInstanceFactory(this.targetClass);
            this.redefineMethodsAndConstructorsInTargetType();
        } else if (Modifier.isAbstract(this.targetClass.getModifiers())) {
            this.redefineMethodsAndConstructorsInTargetType();
            Class<?> subclass = this.generateConcreteSubclassForAbstractType();
            this.instanceFactory = new InstanceFactory.ClassInstanceFactory(subclass);
        } else {
            this.redefineMethodsAndConstructorsInTargetType();
            this.instanceFactory = new InstanceFactory.ClassInstanceFactory(this.targetClass);
        }
        this.storeRedefinedClassesInCache(mockedClassId);
    }

    final Integer redefineClassesFromCache() {
        Integer mockedClassId = this.typeMetadata != null ? this.typeMetadata.hashCode() : this.targetClass.hashCode();
        MockedClass mockedClass = mockedClasses.get(mockedClassId);
        if (mockedClass != null) {
            mockedClass.redefineClasses();
            this.instanceFactory = mockedClass.instanceFactory;
            return null;
        }
        this.mockedClassDefinitions = new ArrayList<ClassDefinition>();
        return mockedClassId;
    }

    final void storeRedefinedClassesInCache(Integer mockedClassId) {
        MockedClass mockedClass = new MockedClass(this.instanceFactory, this.mockedClassDefinitions.toArray(new ClassDefinition[this.mockedClassDefinitions.size()]));
        mockedClasses.put(mockedClassId, mockedClass);
    }

    private Class<?> generateConcreteSubclassForAbstractType() {
        String subclassName = this.getNameForConcreteSubclassToCreate();
        ClassReader classReader = this.createClassReader(this.targetClass);
        SubclassGenerationModifier modifier = new SubclassGenerationModifier(this.mockingCfg, this.targetClass, classReader, subclassName);
        classReader.accept(modifier, false);
        final byte[] modifiedClass = modifier.toByteArray();
        return new ClassLoader(){

            @Override
            protected Class<?> findClass(String name) {
                return this.defineClass(name, modifiedClass, 0, modifiedClass.length);
            }
        }.findClass(subclassName);
    }

    abstract String getNameForConcreteSubclassToCreate();

    private static final class MockedClass {
        final InstanceFactory instanceFactory;
        final ClassDefinition[] mockedClassDefinitions;

        MockedClass(InstanceFactory instanceFactory, ClassDefinition[] classDefinitions) {
            this.instanceFactory = instanceFactory;
            this.mockedClassDefinitions = classDefinitions;
        }

        void redefineClasses() {
            RedefinitionEngine.redefineClasses(this.mockedClassDefinitions);
        }
    }
}

