/*
 * Decompiled with CFR 0.152.
 */
package mockit.internal.expectations.mocking;

import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import mockit.external.asm.ClassReader;
import mockit.internal.ClassFile;
import mockit.internal.RedefinitionEngine;
import mockit.internal.expectations.mocking.ExpectationsModifier;
import mockit.internal.filtering.MockFilter;
import mockit.internal.filtering.MockingConfiguration;
import mockit.internal.util.Utilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DynamicPartialMocking {
    private static final List<MockFilter> exclusionFiltersForMockObject = new ArrayList<MockFilter>(){
        {
            this.add(new MockFilter(){

                public boolean matches(String name, String desc) {
                    return "<init>".equals(name);
                }
            });
        }
    };
    private final List<Class<?>> targetClasses = new ArrayList(2);
    private final Map<Class<?>, byte[]> modifiedClassfiles = new HashMap();
    private MockingConfiguration mockingCfg;

    public List<Class<?>> getTargetClasses() {
        return this.targetClasses;
    }

    public void redefineTypes(Object[] classesOrInstancesToBePartiallyMocked) {
        for (Object classOrInstance : classesOrInstancesToBePartiallyMocked) {
            this.redefineTargetType(classOrInstance);
        }
        new RedefinitionEngine().redefineMethods(this.modifiedClassfiles);
        this.modifiedClassfiles.clear();
    }

    private void redefineTargetType(Object classOrInstance) {
        Class<?> targetClass;
        if (classOrInstance instanceof Class) {
            targetClass = (Class<?>)classOrInstance;
            this.validateTargetClassType(targetClass);
            this.mockingCfg = null;
            this.redefineClass(targetClass);
        } else {
            targetClass = classOrInstance.getClass();
            this.validateTargetClassType(targetClass);
            this.mockingCfg = new MockingConfiguration(exclusionFiltersForMockObject, false);
            this.redefineClassAndItsSuperClasses(targetClass);
        }
        this.targetClasses.add(targetClass);
    }

    private void validateTargetClassType(Class<?> targetClass) {
        if (targetClass.isInterface() || targetClass.isAnnotation() || targetClass.isArray() || targetClass.isPrimitive() || Utilities.isWrapperOfPrimitiveType(targetClass) || Utilities.isGeneratedImplementationClass(targetClass)) {
            throw new IllegalArgumentException("Invalid type for dynamic mocking: " + targetClass);
        }
    }

    private void redefineClassAndItsSuperClasses(Class<?> realClass) {
        this.redefineClass(realClass);
        Class<?> superClass = realClass.getSuperclass();
        if (superClass != Object.class && superClass != Proxy.class) {
            this.redefineClassAndItsSuperClasses(superClass);
        }
    }

    private void redefineClass(Class<?> realClass) {
        ClassReader classReader = new ClassFile(realClass, false).getReader();
        ExpectationsModifier modifier = new ExpectationsModifier(realClass.getClassLoader(), classReader, this.mockingCfg);
        modifier.setExecutionMode(1);
        classReader.accept(modifier, false);
        byte[] modifiedClass = modifier.toByteArray();
        this.modifiedClassfiles.put(realClass, modifiedClass);
    }
}

