/*
 * Decompiled with CFR 0.152.
 */
package mockit.internal.expectations.mocking;

import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.Map;
import mockit.external.asm.ClassReader;
import mockit.external.asm.Label;
import mockit.external.asm.MethodAdapter;
import mockit.external.asm.MethodVisitor;
import mockit.external.asm.Type;
import mockit.internal.BaseClassModifier;
import mockit.internal.filtering.MockingConfiguration;
import mockit.internal.startup.Startup;
import mockit.internal.util.SuperConstructorCollector;

final class ExpectationsModifier
extends BaseClassModifier {
    private static final int METHOD_ACCESS_MASK = 5120;
    private static final Type VOID_TYPE = Type.getType("Ljava/lang/Void;");
    private static final Map<String, String> DEFAULT_FILTERS = new HashMap<String, String>(){
        {
            this.put("java/lang/Object", "<init> getClass hashCode");
            this.put("java/lang/System", "arraycopy getSecurityManager");
            this.put("java/util/AbstractCollection", "<init>");
            this.put("java/util/AbstractList", "<init> iterator");
            this.put("java/util/ArrayList", "get size RangeCheck");
            this.put("java/util/Hashtable", "get");
            this.put("java/lang/Throwable", "<init> fillInStackTrace");
            this.put("java/lang/Exception", "<init>");
        }
    };
    private final MockingConfiguration mockingCfg;
    private String superClassName;
    private String className;
    private String baseClassNameForCapturedInstanceMethods;
    private boolean stubOutClassInitialization;
    private boolean ignoreStaticMethods;
    private int executionMode;
    private boolean isProxy;
    private String defaultFilters;

    ExpectationsModifier(ClassLoader classLoader, ClassReader classReader, MockingConfiguration mockingConfiguration) {
        super(classReader);
        this.mockingCfg = mockingConfiguration;
        this.stubOutClassInitialization = true;
        this.setUseMockingBridge(classLoader);
    }

    public void setClassNameForInstanceMethods(String internalClassName) {
        this.baseClassNameForCapturedInstanceMethods = internalClassName;
    }

    public void setStubOutClassInitialization(boolean stubOutClassInitialization) {
        this.stubOutClassInitialization = stubOutClassInitialization;
    }

    public void setIgnoreStaticMethods(boolean ignoreStaticMethods) {
        this.ignoreStaticMethods = ignoreStaticMethods;
    }

    public void setExecutionMode(int executionMode) {
        this.executionMode = executionMode;
    }

    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        this.superClassName = superName;
        if (this.mockingCfg != null) {
            this.mockingCfg.setSuperClassName(superName);
        }
        super.visit(version, access, name, signature, superName, interfaces);
        this.isProxy = "java/lang/reflect/Proxy".equals(superName);
        if (this.isProxy) {
            this.className = interfaces[0];
            this.defaultFilters = null;
        } else {
            this.className = name;
            this.defaultFilters = DEFAULT_FILTERS.get(name);
        }
    }

    public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        boolean matchesFilters;
        if ((access & 0x1400) != 0 || this.isProxy && this.isConstructorOrSystemMethodNotToBeMocked(name, desc) || this.isMethodOrConstructorNotToBeMocked(access, name)) {
            return super.visitMethod(access, name, desc, signature, exceptions);
        }
        boolean noFiltersToMatch = this.mockingCfg == null || this.mockingCfg.isEmpty();
        boolean bl = matchesFilters = noFiltersToMatch || this.mockingCfg.matchesFilters(name, desc);
        if ("<clinit>".equals(name)) {
            if (matchesFilters && this.stubOutClassInitialization) {
                this.mw = super.visitMethod(access, name, desc, signature, exceptions);
                this.generateEmptyImplementation();
                return null;
            }
            return super.visitMethod(access, name, desc, signature, exceptions);
        }
        if (!matchesFilters || noFiltersToMatch && this.isMethodFromObject(name, desc)) {
            return super.visitMethod(access, name, desc, signature, exceptions);
        }
        this.validateModificationOfNativeMethod(access, name);
        this.startModifiedMethodVersion(access, name, desc, signature, exceptions);
        boolean visitingConstructor = "<init>".equals(name);
        if (visitingConstructor && this.superClassName != null) {
            this.generateCallToDefaultOrConfiguredSuperConstructor();
        }
        String internalClassName = this.className;
        if (this.baseClassNameForCapturedInstanceMethods != null && !visitingConstructor) {
            internalClassName = this.baseClassNameForCapturedInstanceMethods;
        }
        if (this.useMockingBridge) {
            return this.generateCallToHandlerThroughMockingBridge(access, name, desc, internalClassName);
        }
        this.generateDirectCallToHandler(internalClassName, access, name, desc, this.executionMode);
        if (this.executionMode > 0) {
            this.generateDecisionBetweenReturningOrContinuingToRealImplementation(desc);
            return visitingConstructor ? new DynamicConstructorModifier() : new MethodAdapter(this.mw);
        }
        this.generateReturnWithObjectAtTopOfTheStack(desc);
        this.mw.visitMaxs(1, 0);
        return null;
    }

    private boolean isConstructorOrSystemMethodNotToBeMocked(String name, String desc) {
        return "<init>".equals(name) || this.isMethodFromObject(name, desc) || "annotationType".equals(name) && "()Ljava/lang/Class;".equals(desc);
    }

    private boolean isMethodOrConstructorNotToBeMocked(int access, String name) {
        return this.isConstructorToBeIgnored(name) || this.isStaticMethodToBeIgnored(access) || this.isMethodFromCapturedClassNotToBeMocked(access) || this.defaultFilters != null && this.defaultFilters.contains(name);
    }

    private boolean isConstructorToBeIgnored(String name) {
        return this.executionMode == 2 && "<init>".equals(name);
    }

    private boolean isStaticMethodToBeIgnored(int access) {
        return this.ignoreStaticMethods && Modifier.isStatic(access);
    }

    private boolean isMethodFromCapturedClassNotToBeMocked(int access) {
        return this.baseClassNameForCapturedInstanceMethods != null && (Modifier.isStatic(access) || Modifier.isPrivate(access));
    }

    private void validateModificationOfNativeMethod(int access, String name) {
        if (Modifier.isNative(access) && !Startup.isJava6OrLater()) {
            throw new IllegalArgumentException("Mocking of native methods not supported under JDK 1.5; please filter out method \"" + name + "\", or run under JDK 1.6+");
        }
    }

    private void generateCallToDefaultOrConfiguredSuperConstructor() {
        String constructorDesc;
        this.mw.visitVarInsn(25, 0);
        if ("java/lang/Object".equals(this.superClassName)) {
            constructorDesc = "()V";
        } else if (this.mockingCfg != null) {
            Type[] paramTypes = this.mockingCfg.getSuperConstructorParameterTypes();
            constructorDesc = this.generateSuperConstructorArguments(paramTypes);
        } else {
            constructorDesc = new SuperConstructorCollector(1).findConstructor(this.superClassName);
            this.pushDefaultValuesForParameterTypes(constructorDesc);
        }
        this.mw.visitMethodInsn(183, this.superClassName, "<init>", constructorDesc);
    }

    private MethodVisitor generateCallToHandlerThroughMockingBridge(int access, String name, String desc, String internalClassName) {
        this.generateCallToMockingBridge(1, internalClassName, access, name, desc, this.executionMode);
        this.generateDecisionBetweenReturningOrContinuingToRealImplementation(desc);
        if (Modifier.isNative(access)) {
            this.generateEmptyImplementation(desc);
            return null;
        }
        return new MethodAdapter(this.mw);
    }

    private void generateDecisionBetweenReturningOrContinuingToRealImplementation(String desc) {
        this.mw.visitInsn(89);
        this.mw.visitLdcInsn(VOID_TYPE);
        Label startOfRealImplementation = new Label();
        this.mw.visitJumpInsn(165, startOfRealImplementation);
        this.generateReturnWithObjectAtTopOfTheStack(desc);
        this.mw.visitLabel(startOfRealImplementation);
        this.mw.visitInsn(87);
    }

    private final class DynamicConstructorModifier
    extends MethodAdapter {
        DynamicConstructorModifier() {
            super(ExpectationsModifier.this.mw);
        }

        public void visitMethodInsn(int opcode, String owner, String name, String desc) {
            if (opcode == 183 && (owner.equals(ExpectationsModifier.this.superClassName) || owner.equals(ExpectationsModifier.this.className))) {
                return;
            }
            ExpectationsModifier.this.mw.visitMethodInsn(opcode, owner, name, desc);
        }
    }
}

