/*
 * Decompiled with CFR 0.152.
 */
package mockit.internal.expectations.mocking;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import mockit.Expectations;
import mockit.internal.expectations.mocking.FieldTypeRedefinitions;
import mockit.internal.expectations.mocking.InstanceFactory;
import mockit.internal.expectations.mocking.MockedType;
import mockit.internal.expectations.mocking.TypeRedefinition;
import mockit.internal.state.ExecutingTest;
import mockit.internal.state.TestRun;
import mockit.internal.util.Utilities;

public final class SharedFieldTypeRedefinitions
extends FieldTypeRedefinitions {
    private final Map<MockedType, InstanceFactory> mockInstanceFactories = new HashMap<MockedType, InstanceFactory>();
    private final List<MockedType> finalMockFields = new ArrayList<MockedType>();

    public SharedFieldTypeRedefinitions(Object objectWithMockFields) {
        super(objectWithMockFields);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void redefineTypesForTestClass() {
        TestRun.enterNoMockingZone();
        try {
            Class<?> testClass = this.parentObject.getClass();
            this.targetClasses.clear();
            this.redefineFieldTypes(testClass, !Expectations.class.isAssignableFrom(testClass));
        }
        finally {
            TestRun.exitNoMockingZone();
        }
    }

    protected TypeRedefinition redefineTypeForMockField() {
        TypeRedefinition typeRedefinition = new TypeRedefinition(this.parentObject, this.typeMetadata);
        if (this.finalField) {
            typeRedefinition.redefineTypeForFinalField();
            this.finalMockFields.add(this.typeMetadata);
        } else {
            typeRedefinition.redefineType();
            InstanceFactory factory = typeRedefinition.instanceFactory;
            if (factory != null) {
                this.mockInstanceFactories.put(this.typeMetadata, factory);
            } else {
                this.finalMockFields.add(this.typeMetadata);
            }
        }
        this.targetClasses.add(typeRedefinition.targetClass);
        return typeRedefinition;
    }

    public void assignNewInstancesToMockFields(Object target) {
        ExecutingTest executingTest = TestRun.getExecutingTest();
        executingTest.clearInjectableMocks();
        executingTest.clearNonStrictMocks();
        for (Map.Entry<MockedType, InstanceFactory> metadataAndFactory : this.mockInstanceFactories.entrySet()) {
            MockedType metadata = metadataAndFactory.getKey();
            InstanceFactory instanceFactory = metadataAndFactory.getValue();
            Object mock = this.assignNewInstanceToMockField(target, metadata, instanceFactory);
            if (metadata.injectable) {
                executingTest.addInjectableMock(mock);
            }
            if (!metadata.nonStrict) continue;
            executingTest.addNonStrictMock(mock);
        }
        for (MockedType metadata : this.finalMockFields) {
            if (!metadata.nonStrict) continue;
            executingTest.addNonStrictMock(metadata.getClassType());
        }
    }

    private Object assignNewInstanceToMockField(Object target, MockedType metadata, InstanceFactory instanceFactory) {
        Field mockField = metadata.field;
        Object mock = Utilities.getFieldValue(mockField, target);
        if (mock == null) {
            try {
                mock = instanceFactory.create();
            }
            catch (ExceptionInInitializerError e) {
                Utilities.filterStackTrace(e);
                Utilities.filterStackTrace(e.getCause());
                e.printStackTrace();
                throw e;
            }
            Utilities.setFieldValue(mockField, target, mock);
            if (metadata.getMaxInstancesToCapture() > 0) {
                this.getCaptureOfNewInstances().resetCaptureCount(mockField);
            }
        }
        return mock;
    }

    public boolean captureNewInstanceForApplicableMockField(Object mock) {
        if (this.captureOfNewInstances == null) {
            return false;
        }
        Object fieldOwner = TestRun.getCurrentTestInstance();
        return this.getCaptureOfNewInstances().captureNewInstanceForApplicableMockField(fieldOwner, mock);
    }
}

