/*
 * Decompiled with CFR 0.152.
 */
package mockit.internal.state;

import java.lang.reflect.Method;
import java.net.URL;
import java.security.CodeSource;
import java.security.ProtectionDomain;
import mockit.internal.capturing.CaptureOfImplementationsForTestClass;
import mockit.internal.expectations.RecordAndReplayExecution;
import mockit.internal.expectations.mocking.SharedFieldTypeRedefinitions;
import mockit.internal.state.ExecutingTest;
import mockit.internal.state.MockClasses;
import mockit.internal.state.MockFixture;
import mockit.internal.state.ProxyClasses;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class TestRun {
    private static final TestRun instance = new TestRun();
    private Class<?> currentTestClass;
    private Object currentTestInstance;
    private int testId;
    private Method runningTestMethod;
    private final ThreadLocal<Integer> noMockingCount = new ThreadLocal<Integer>(){

        @Override
        protected Integer initialValue() {
            return 0;
        }

        @Override
        public void set(Integer valueToAdd) {
            super.set((Integer)this.get() + valueToAdd);
        }
    };
    private CaptureOfImplementationsForTestClass captureOfSubtypes;
    private SharedFieldTypeRedefinitions sharedFieldTypeRedefinitions;
    private final ProxyClasses proxyClasses = new ProxyClasses();
    private final MockFixture mockFixture = new MockFixture();
    private final ExecutingTest executingTest = new ExecutingTest();
    private final MockClasses mockClasses = new MockClasses();

    private TestRun() {
    }

    public static Class<?> getCurrentTestClass() {
        return TestRun.instance.currentTestClass;
    }

    public static Object getCurrentTestInstance() {
        return TestRun.instance.currentTestInstance;
    }

    public static int getTestId() {
        return TestRun.instance.testId;
    }

    public static boolean isInsideNoMockingZone() {
        return TestRun.instance.noMockingCount.get() > 0;
    }

    public static boolean isRunningTestCode(ProtectionDomain protectionDomain) {
        if (TestRun.instance.currentTestInstance != null) {
            return protectionDomain == TestRun.instance.currentTestClass.getProtectionDomain();
        }
        if (protectionDomain == null) {
            return false;
        }
        CodeSource codeSource = protectionDomain.getCodeSource();
        if (codeSource == null) {
            return false;
        }
        URL location = codeSource.getLocation();
        return location != null && !location.getPath().endsWith(".jar");
    }

    public static CaptureOfImplementationsForTestClass getCaptureOfSubtypes() {
        return TestRun.instance.captureOfSubtypes;
    }

    public static SharedFieldTypeRedefinitions getSharedFieldTypeRedefinitions() {
        return TestRun.instance.sharedFieldTypeRedefinitions;
    }

    public static ProxyClasses proxyClasses() {
        return TestRun.instance.proxyClasses;
    }

    public static MockFixture mockFixture() {
        return TestRun.instance.mockFixture;
    }

    public static ExecutingTest getExecutingTest() {
        return TestRun.instance.executingTest;
    }

    public static RecordAndReplayExecution getRecordAndReplayForRunningTest(boolean create) {
        if (TestRun.instance.currentTestInstance == null) {
            return null;
        }
        return TestRun.getExecutingTest().getRecordAndReplay(TestRun.instance.runningTestMethod != null && create);
    }

    public static MockClasses getMockClasses() {
        return TestRun.instance.mockClasses;
    }

    public static void verifyExpectationsOnAnnotatedMocks() {
        TestRun.getMockClasses().getMockStates().verifyExpectations();
    }

    public static void resetExpectationsOnAnnotatedMocks() {
        TestRun.getMockClasses().getMockStates().resetExpectations();
    }

    public static void setCurrentTestClass(Class<?> testClass) {
        TestRun.instance.currentTestClass = testClass;
    }

    public static void generateIdForNextTest() {
        ++TestRun.instance.testId;
    }

    public static void setRunningTestMethod(Method runningTestMethod) {
        TestRun.instance.runningTestMethod = runningTestMethod;
        if (runningTestMethod != null) {
            TestRun.instance.executingTest.clearRecordAndReplayForVerifications();
        }
    }

    public static void enterNoMockingZone() {
        TestRun.instance.noMockingCount.set(1);
    }

    public static void exitNoMockingZone() {
        TestRun.instance.noMockingCount.set(-1);
    }

    public static void setRunningIndividualTest(Object testInstance) {
        TestRun.instance.currentTestInstance = testInstance;
    }

    public static void setCaptureOfSubtypes(CaptureOfImplementationsForTestClass captureOfSubtypes) {
        TestRun.instance.captureOfSubtypes = captureOfSubtypes;
    }

    public static void setSharedFieldTypeRedefinitions(SharedFieldTypeRedefinitions redefinitions) {
        TestRun.instance.sharedFieldTypeRedefinitions = redefinitions;
    }

    public static void finishCurrentTestExecution() {
        TestRun.instance.currentTestInstance = null;
        TestRun.instance.runningTestMethod = null;
        TestRun.instance.executingTest.finishExecution();
    }

    public static Object getMock(int index) {
        return TestRun.instance.mockClasses.regularMocks.getMock(index);
    }

    public static Object getStartupMock(int index) {
        return TestRun.instance.mockClasses.startupMocks.getMock(index);
    }

    public static Object getMock(Class<?> mockClass, Object mockedInstance) {
        return TestRun.instance.mockClasses.regularMocks.getMock(mockClass, mockedInstance);
    }

    public static boolean updateMockState(String mockClassDesc, int mockIndex) {
        return TestRun.instance.mockClasses.annotatedMockStates.updateMockState(mockClassDesc, mockIndex);
    }

    public static void exitReentrantMock(String mockClassDesc, int mockIndex) {
        TestRun.instance.mockClasses.annotatedMockStates.exitReentrantMock(mockClassDesc, mockIndex);
    }
}

