/*
 * Decompiled with CFR 0.152.
 */
package net.revelc.code.zookeeper.maven.plugin;

import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.descriptor.PluginDescriptor;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;

public abstract class AbstractZooKeeperMojo
extends AbstractMojo {
    @Parameter(defaultValue="${project}", readonly=true)
    protected MavenProject project;
    @Parameter(defaultValue="${plugin}", readonly=true)
    protected PluginDescriptor plugin;
    @Parameter(alias="clientPortAddress", property="zmp.clientPortAddress", defaultValue="127.0.0.1")
    protected String clientPortAddress;
    @Parameter(alias="shutdownPort", required=true, property="zmp.shutdownPort", defaultValue="52000")
    protected int shutdownPort;
    @Parameter(alias="shutdownString", required=true, property="zmp.shutdownString", defaultValue="shutdown")
    protected String shutdownString;
    @Parameter(alias="skip", property="zmp.skip", defaultValue="false")
    protected boolean skip;
    @Parameter(alias="ignoreSkipTests", property="zmp.ignoreSkipTests", defaultValue="false")
    protected boolean ignoreSkipTests;
    @Parameter(alias="ignoreSkipITs", property="zmp.ignoreSkipITs", defaultValue="false")
    protected boolean ignoreSkipITs;

    public void execute() throws MojoFailureException, MojoExecutionException {
        if (this.shouldSkip()) {
            return;
        }
        this.runMojo();
    }

    protected abstract void runMojo() throws MojoFailureException, MojoExecutionException;

    boolean shouldSkip() {
        boolean skipTests = !"false".equals(System.getProperty("skipTests", "false"));
        boolean skipITs = !"false".equals(System.getProperty("skipITs", "false"));
        this.getLog().debug((CharSequence)String.format("skipTests = %s, skipITs = %s", skipTests, skipITs));
        if (this.skip) {
            String fmt = "Skipping due to skip = %s";
            this.getLog().debug((CharSequence)String.format(fmt, this.skip));
        } else if (skipTests && !this.ignoreSkipTests) {
            String fmt = "Skipping due to skipTests = %s (ignoreSkipTests = %s)";
            this.getLog().debug((CharSequence)String.format(fmt, skipTests, this.ignoreSkipTests));
        } else if (skipITs && !this.ignoreSkipITs) {
            String fmt = "Skipping due to skipITs = %s (ignoreSkipITs = %s)";
            this.getLog().debug((CharSequence)String.format(fmt, skipITs, this.ignoreSkipITs));
        }
        if (this.skip || skipTests && !this.ignoreSkipTests || skipITs && !this.ignoreSkipITs) {
            this.getLog().info((CharSequence)"Skipping execution of zookeeper-maven-plugin");
            return true;
        }
        return false;
    }
}

