/*
 * Decompiled with CFR 0.152.
 */
package net.revelc.code.zookeeper.maven.plugin;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Properties;
import java.util.Scanner;
import java.util.UUID;
import net.revelc.code.zookeeper.maven.plugin.AbstractZooKeeperMojo;
import net.revelc.code.zookeeper.maven.plugin.ZooKeeperLauncher;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.codehaus.plexus.util.FileUtils;

@Mojo(name="start", defaultPhase=LifecyclePhase.PRE_INTEGRATION_TEST, threadSafe=true)
public class StartZooKeeperMojo
extends AbstractZooKeeperMojo {
    @Parameter(defaultValue="${project.build.directory}/zmp", readonly=true)
    protected File zmpDir;
    @Parameter(alias="clientPort", required=true, property="zmp.clientPort", defaultValue="2181")
    protected int clientPort;
    @Parameter(alias="tickTime", property="zmp.tickTime", defaultValue="2000")
    protected int tickTime;
    @Parameter(alias="initLimit", property="zmp.initLimit", defaultValue="10")
    protected int initLimit;
    @Parameter(alias="syncLimit", property="zmp.syncLimit", defaultValue="5")
    protected int syncLimit;
    @Parameter(alias="maxClientCnxns", property="zmp.maxClientCnxns", defaultValue="100")
    protected int maxClientCnxns;
    private File baseDir;
    private File dataDir;

    @Override
    protected void runMojo() throws MojoExecutionException, MojoFailureException {
        this.parseConfig();
        ProcessBuilder builder = new ProcessBuilder(new String[0]);
        builder.command().add(this.getJavaCommand());
        String classpath = this.getClasspath();
        this.getLog().warn((CharSequence)classpath);
        if (!classpath.isEmpty()) {
            builder.command().add("-cp");
            builder.command().add(classpath);
        }
        builder.command().add(ZooKeeperLauncher.class.getName());
        builder.command().add("--shutdownPort");
        builder.command().add(Integer.toString(this.shutdownPort));
        builder.command().add("--shutdownString");
        builder.command().add(this.shutdownString);
        String token = UUID.randomUUID().toString();
        builder.command().add("--token");
        builder.command().add(token);
        File zooCfgFile = this.createZooCfg();
        builder.command().add("--zoocfg");
        builder.command().add(zooCfgFile.getAbsolutePath());
        builder.directory(this.project.getBasedir());
        this.getLog().info((CharSequence)"Starting ZooKeeper");
        Process forkedProcess = null;
        try {
            builder.redirectErrorStream(true);
            forkedProcess = builder.start();
            try (Scanner scanner = new Scanner(forkedProcess.getInputStream(), StandardCharsets.UTF_8.name());){
                this.getLog().info((CharSequence)"Waiting for ZooKeeper service to start...");
                boolean verifiedStart = false;
                for (int checklines = 50; scanner.hasNextLine() && checklines > 0; --checklines) {
                    String line = scanner.nextLine();
                    this.getLog().debug((CharSequence)("LINE: " + line));
                    if (!line.contains("Token: " + token)) continue;
                    verifiedStart = true;
                    break;
                }
                if (verifiedStart) {
                    this.getLog().info((CharSequence)"ZooKeeper service has started");
                } else {
                    this.getLog().warn((CharSequence)"Unable to verify ZooKeeper service started");
                }
            }
        }
        catch (IOException e) {
            throw new MojoFailureException("Unable to start process (or verify that it has started)", (Throwable)e);
        }
    }

    private void parseConfig() throws MojoExecutionException {
        if (!this.zmpDir.mkdirs() && !this.zmpDir.isDirectory()) {
            throw new MojoExecutionException("Can't create plugin directory: " + this.zmpDir.getAbsolutePath());
        }
        this.baseDir = new File(this.zmpDir, this.clientPortAddress + "_" + this.clientPort);
        try {
            FileUtils.deleteDirectory((File)this.baseDir);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Can't clean plugin directory: " + this.baseDir.getAbsolutePath());
        }
        if (!this.baseDir.mkdirs() && !this.baseDir.isDirectory()) {
            throw new MojoExecutionException("Can't create plugin directory: " + this.baseDir.getAbsolutePath());
        }
        this.dataDir = new File(this.baseDir, "data");
        try {
            FileUtils.deleteDirectory((File)this.dataDir);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Can't clean data directory: " + this.baseDir.getAbsolutePath());
        }
    }

    private File createZooCfg() throws MojoExecutionException, MojoFailureException {
        File confDir = new File(this.baseDir, "conf");
        if (!confDir.mkdirs() && !confDir.isDirectory()) {
            throw new MojoExecutionException("Can't create configuration directory: " + confDir.getAbsolutePath());
        }
        File zooCfgFile = new File(confDir, "zoo.cfg");
        if (zooCfgFile.exists() && !zooCfgFile.delete()) {
            throw new MojoExecutionException("Can't delete existing configuration file: " + zooCfgFile.getAbsolutePath());
        }
        Properties zooCfg = new Properties();
        zooCfg.setProperty("tickTime", this.tickTime + "");
        zooCfg.setProperty("initLimit", this.initLimit + "");
        zooCfg.setProperty("syncLimit", this.syncLimit + "");
        zooCfg.setProperty("clientPortAddress", this.clientPortAddress);
        zooCfg.setProperty("clientPort", this.clientPort + "");
        zooCfg.setProperty("maxClientCnxns", this.maxClientCnxns + "");
        zooCfg.setProperty("dataDir", this.dataDir.getAbsolutePath());
        try (FileWriter fileWriter = new FileWriter(zooCfgFile);){
            zooCfg.store(fileWriter, null);
        }
        catch (IOException e) {
            throw new MojoFailureException("Unable to create " + zooCfgFile.getAbsolutePath(), (Throwable)e);
        }
        return zooCfgFile;
    }

    private String getJavaCommand() {
        return System.getProperty("java.home") + File.separator + "bin" + File.separator + "java";
    }

    private String getClasspath() {
        StringBuilder classpath = new StringBuilder();
        String delim = File.pathSeparator;
        classpath.append(this.plugin.getPluginArtifact().getFile().getAbsolutePath());
        for (Artifact artifact : this.plugin.getArtifacts()) {
            if (!"jar".equals(artifact.getType()) || "provided".equals(artifact.getScope())) continue;
            classpath.append(delim).append(artifact.getFile().getAbsolutePath());
        }
        return classpath.toString();
    }
}

