/*
 * Decompiled with CFR 0.152.
 */
package net.revelc.code.zookeeper.maven.plugin;

import java.io.IOException;
import java.io.OutputStream;
import java.net.ConnectException;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.WritableByteChannel;
import java.nio.charset.StandardCharsets;
import java.util.Scanner;
import java.util.concurrent.TimeUnit;
import net.revelc.code.zookeeper.maven.plugin.AbstractZooKeeperMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;

@Mojo(name="stop", defaultPhase=LifecyclePhase.POST_INTEGRATION_TEST, threadSafe=true)
public class StopZooKeeperMojo
extends AbstractZooKeeperMojo {
    @Parameter(alias="shutdownWait", property="zmp.shutdownWait", defaultValue="30")
    protected int shutdownWait;

    @Override
    protected void runMojo() throws MojoFailureException, MojoExecutionException {
        block55: {
            ByteBuffer shutdownMsg = StandardCharsets.UTF_8.encode(this.shutdownString.trim() + "\r\n");
            try (Socket s = new Socket(this.clientPortAddress, this.shutdownPort);
                 OutputStream os = s.getOutputStream();
                 WritableByteChannel channel = Channels.newChannel(os);){
                channel.write(shutdownMsg);
                os.flush();
                this.getLog().info((CharSequence)"Shutdown message sent.");
                if (this.shutdownWait <= 0) break block55;
                long shutdownWaitMillis = TimeUnit.SECONDS.toMillis(this.shutdownWait);
                if (shutdownWaitMillis <= Integer.MAX_VALUE) {
                    s.setSoTimeout((int)shutdownWaitMillis);
                    try (Scanner scanner = new Scanner(s.getInputStream(), StandardCharsets.UTF_8.name());){
                        while (scanner.hasNextLine()) {
                            String response = scanner.nextLine();
                            if (!"done".equals(response)) continue;
                            this.getLog().info((CharSequence)"Shutdown response received: success.");
                            break block55;
                        }
                        break block55;
                    }
                    catch (SocketTimeoutException e) {
                        throw new MojoExecutionException("Shutdown response not received within the time limit", (Exception)e);
                    }
                }
                throw new MojoExecutionException("shutdownWait too large; can't convert to millis");
            }
            catch (ConnectException e) {
                throw new MojoFailureException("ZooKeeper service not running", (Throwable)e);
            }
            catch (IOException e) {
                throw new MojoFailureException("Couldn't write shutdown message to " + this.clientPortAddress + ":" + this.shutdownPort, (Throwable)e);
            }
        }
    }
}

