/*
 * Decompiled with CFR 0.152.
 */
package net.revelc.code.zookeeper.maven.plugin;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.nio.channels.Channels;
import java.nio.channels.WritableByteChannel;
import java.nio.charset.StandardCharsets;
import java.util.NoSuchElementException;
import java.util.Scanner;
import java.util.concurrent.TimeUnit;
import org.apache.zookeeper.server.ServerConfig;
import org.apache.zookeeper.server.ZooKeeperServerMain;
import org.apache.zookeeper.server.quorum.QuorumPeerConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZooKeeperLauncher {
    private static final Logger log = LoggerFactory.getLogger(ZooKeeperLauncher.class);
    private static final Thread.UncaughtExceptionHandler loggingExceptionHandler = new Thread.UncaughtExceptionHandler(){

        @Override
        public synchronized void uncaughtException(Thread thread, Throwable exception) {
            log.error("Uncaught exception in {}", (Object)thread, (Object)exception);
            System.exit(1);
        }
    };
    private String token = null;
    private String shutdownString = null;
    private int port = 0;
    private File zooCfg = null;
    private String host = null;

    public ZooKeeperLauncher(String[] args) {
        this.parseArgs(args);
    }

    private void execute() {
        Thread shutdownThread = new Thread((Runnable)new ShutdownListener(this.host, this.port, this.shutdownString), "ShutdownListener");
        RunServer server = new RunServer(this.zooCfg);
        Thread serverThread = new Thread((Runnable)server, "ZooKeeperServerThread");
        for (Thread t : new Thread[]{shutdownThread, serverThread}) {
            t.setDaemon(true);
            t.setUncaughtExceptionHandler(loggingExceptionHandler);
            t.start();
        }
        if (this.token != null) {
            System.err.println("Started ZooKeeper (Token: " + this.token + ")");
        }
        try {
            shutdownThread.join();
            server.shutdown();
            serverThread.join(TimeUnit.SECONDS.toMillis(5L));
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        if (serverThread.isAlive()) {
            log.warn("ZooKeeper did not shut down for 5 seconds. Forcing exit...");
            System.exit(1);
        } else {
            log.info("ZooKeeper shut down successfully.");
            System.exit(0);
        }
    }

    private void parseArgs(String[] args) {
        boolean nextIsToken = false;
        boolean nextIsShutdownString = false;
        boolean nextIsShutdownPort = false;
        boolean nextIsHost = false;
        boolean nextIsZooCfg = false;
        for (String arg : args) {
            if (nextIsToken) {
                this.token = arg;
            } else if (nextIsShutdownString) {
                this.shutdownString = arg;
            } else if (nextIsShutdownPort) {
                this.port = Integer.parseInt(arg);
            } else if (nextIsHost) {
                this.host = arg;
            } else if (nextIsZooCfg) {
                this.zooCfg = new File(arg);
            }
            nextIsToken = "--token".equals(arg);
            nextIsShutdownString = "--shutdownString".equals(arg);
            nextIsShutdownPort = "--shutdownPort".equals(arg);
            nextIsHost = "--host".equals(arg);
            nextIsZooCfg = "--zoocfg".equals(arg);
        }
        if (this.port < 1) {
            throw new IllegalArgumentException("Must specify port greater than 0");
        }
    }

    public static void main(String[] args) {
        new ZooKeeperLauncher(args).execute();
    }

    private static class RunServer
    extends ZooKeeperServerMain
    implements Runnable {
        private final ServerConfig config = new ServerConfig();

        public RunServer(File zooCfg) {
            try {
                this.config.parse(zooCfg.getAbsolutePath());
            }
            catch (QuorumPeerConfig.ConfigException e) {
                throw new IllegalArgumentException("Bad configuration file", e);
            }
        }

        public void shutdown() {
            super.shutdown();
        }

        @Override
        public void run() {
            try {
                this.runFromConfig(this.config);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private static class ShutdownListener
    implements Runnable {
        private final String host;
        private final int port;
        private final String shutdownString;

        public ShutdownListener(String host, int port, String shutdownString) {
            this.host = host;
            this.port = port;
            this.shutdownString = shutdownString;
        }

        @Override
        public void run() {
            block57: {
                try {
                    ServerSocket listener = new ServerSocket(this.port, 10, InetAddress.getByName(this.host));
                    Throwable throwable = null;
                    block44: while (true) {
                        try {
                            while (true) {
                                Socket sock = listener.accept();
                                sock.setSoTimeout(5000);
                                try {
                                    Scanner scanner = new Scanner(sock.getInputStream(), StandardCharsets.UTF_8.name());
                                    Throwable throwable2 = null;
                                    try {
                                        if (!this.shutdownString.equals(scanner.nextLine())) continue block44;
                                        try (OutputStream os = sock.getOutputStream();
                                             WritableByteChannel channel = Channels.newChannel(os);){
                                            channel.write(StandardCharsets.UTF_8.encode("done\r\n"));
                                            os.flush();
                                        }
                                        catch (IOException e) {
                                            log.warn("Problem receiving shutdown message", (Throwable)e);
                                        }
                                        log.info("Received shutdown message");
                                        break block57;
                                    }
                                    catch (Throwable throwable3) {
                                        throwable2 = throwable3;
                                        throw throwable3;
                                    }
                                    finally {
                                        if (scanner == null) continue block44;
                                        if (throwable2 != null) {
                                            try {
                                                scanner.close();
                                            }
                                            catch (Throwable throwable4) {
                                                throwable2.addSuppressed(throwable4);
                                            }
                                            continue block44;
                                        }
                                        scanner.close();
                                        continue block44;
                                    }
                                }
                                catch (NoSuchElementException e) {
                                    log.warn("Connection lost to unresponsive client", (Throwable)e);
                                    continue;
                                }
                                break;
                            }
                        }
                        catch (Throwable throwable5) {
                            throwable = throwable5;
                            throw throwable5;
                        }
                    }
                    finally {
                        if (listener != null) {
                            if (throwable != null) {
                                try {
                                    listener.close();
                                }
                                catch (Throwable throwable6) {
                                    throwable.addSuppressed(throwable6);
                                }
                            } else {
                                listener.close();
                            }
                        }
                    }
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }
}

