/*
 * Decompiled with CFR 0.152.
 */
package net.serenitybdd.maven.plugins;

import java.io.File;
import java.io.IOException;
import java.util.Locale;
import net.serenitybdd.core.Serenity;
import net.thucydides.core.ThucydidesSystemProperty;
import net.thucydides.core.guice.Injectors;
import net.thucydides.core.reports.html.HtmlAggregateStoryReporter;
import net.thucydides.core.util.EnvironmentVariables;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;

@Mojo(name="aggregate", requiresProject=false)
public class SerenityAggregatorMojo
extends AbstractMojo {
    @Parameter(property="thucydides.outputDirectory", defaultValue="${project.build.directory}/site/serenity", required=true)
    public File outputDirectory;
    @Parameter(property="thucydides.source", defaultValue="${project.build.directory}/site/serenity", required=true)
    public File sourceDirectory;
    @Parameter
    public String issueTrackerUrl;
    @Parameter
    public String jiraUrl;
    @Parameter
    public String jiraUsername;
    @Parameter
    public String jiraPassword;
    @Parameter
    public String jiraProject;
    @Parameter
    public String requirementsBaseDir;
    EnvironmentVariables environmentVariables;
    @Parameter(property="thucydides.project.key", defaultValue="default")
    public String projectKey;
    private HtmlAggregateStoryReporter reporter;

    protected void setOutputDirectory(File outputDirectory) {
        this.outputDirectory = outputDirectory;
    }

    protected void setSourceDirectory(File sourceDirectory) {
        this.sourceDirectory = sourceDirectory;
    }

    public void prepareExecution() {
        if (!this.outputDirectory.exists()) {
            this.outputDirectory.mkdirs();
        }
        this.configureEnvironmentVariables();
    }

    private EnvironmentVariables getEnvironmentVariables() {
        if (this.environmentVariables == null) {
            this.environmentVariables = (EnvironmentVariables)Injectors.getInjector().getProvider(EnvironmentVariables.class).get();
        }
        return this.environmentVariables;
    }

    private void configureEnvironmentVariables() {
        Locale.setDefault(Locale.ENGLISH);
        this.updateSystemProperty(ThucydidesSystemProperty.THUCYDIDES_PROJECT_KEY.getPropertyName(), this.projectKey, Serenity.getDefaultProjectKey());
        this.updateSystemProperty(ThucydidesSystemProperty.THUCYDIDES_TEST_REQUIREMENTS_BASEDIR.toString(), this.requirementsBaseDir);
    }

    private void updateSystemProperty(String key, String value, String defaultValue) {
        if (value != null) {
            this.getEnvironmentVariables().setProperty(key, value);
        } else {
            this.getEnvironmentVariables().setProperty(key, defaultValue);
        }
    }

    private void updateSystemProperty(String key, String value) {
        if (value != null) {
            this.getEnvironmentVariables().setProperty(key, value);
        }
    }

    protected void setReporter(HtmlAggregateStoryReporter reporter) {
        this.reporter = reporter;
    }

    public void execute() throws MojoExecutionException {
        this.prepareExecution();
        try {
            this.generateHtmlStoryReports();
        }
        catch (IOException e) {
            throw new MojoExecutionException("Error generating aggregate serenity reports", (Exception)e);
        }
    }

    protected HtmlAggregateStoryReporter getReporter() {
        if (this.reporter == null) {
            this.reporter = new HtmlAggregateStoryReporter(this.projectKey);
        }
        return this.reporter;
    }

    private void generateHtmlStoryReports() throws IOException {
        this.getReporter().setSourceDirectory(this.sourceOfTestResult());
        this.getReporter().setOutputDirectory(this.outputDirectory);
        this.getReporter().setIssueTrackerUrl(this.issueTrackerUrl);
        this.getReporter().setJiraUrl(this.jiraUrl);
        this.getReporter().setJiraProject(this.jiraProject);
        this.getReporter().setJiraUsername(this.jiraUsername);
        this.getReporter().setJiraPassword(this.jiraPassword);
        this.getReporter().generateReportsForTestResultsFrom(this.sourceOfTestResult());
    }

    private File sourceOfTestResult() {
        if (this.sourceDirectory != null && this.sourceDirectory.exists()) {
            return this.sourceDirectory;
        }
        return this.outputDirectory;
    }
}

