/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.functions.hof;

import java.util.function.Supplier;
import net.sf.saxon.Configuration;
import net.sf.saxon.expr.EarlyEvaluationContext;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ItemMappingFunction;
import net.sf.saxon.expr.ItemMappingIterator;
import net.sf.saxon.expr.Literal;
import net.sf.saxon.expr.OperandRole;
import net.sf.saxon.expr.UnaryExpression;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.elab.Elaborator;
import net.sf.saxon.expr.elab.ItemEvaluator;
import net.sf.saxon.expr.elab.PullElaborator;
import net.sf.saxon.expr.elab.PullEvaluator;
import net.sf.saxon.expr.parser.ContextItemStaticInfo;
import net.sf.saxon.expr.parser.ExpressionTool;
import net.sf.saxon.expr.parser.ExpressionVisitor;
import net.sf.saxon.expr.parser.RebindingMap;
import net.sf.saxon.expr.parser.RoleDiagnostic;
import net.sf.saxon.functions.hof.CoercedFunction;
import net.sf.saxon.lib.FunctionAnnotationHandler;
import net.sf.saxon.om.FunctionItem;
import net.sf.saxon.om.GroundedValue;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.SequenceTool;
import net.sf.saxon.query.Annotation;
import net.sf.saxon.s9api.Location;
import net.sf.saxon.trace.ExpressionPresenter;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.FunctionItemType;
import net.sf.saxon.type.SpecificFunctionType;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.value.SequenceType;

public final class FunctionSequenceCoercer
extends UnaryExpression {
    private final SpecificFunctionType requiredItemType;
    private final Supplier<RoleDiagnostic> roleSupplier;

    public FunctionSequenceCoercer(Expression sequence, SpecificFunctionType requiredItemType, Supplier<RoleDiagnostic> role) {
        super(sequence);
        this.requiredItemType = requiredItemType;
        this.roleSupplier = role;
        ExpressionTool.copyLocationInfo(sequence, this);
    }

    @Override
    protected OperandRole getOperandRole() {
        return OperandRole.INSPECT;
    }

    @Override
    public Expression simplify() throws XPathException {
        this.setBaseExpression(this.getBaseExpression().simplify());
        if (this.getBaseExpression() instanceof Literal) {
            GroundedValue val = SequenceTool.toGroundedValue(this.iterate(new EarlyEvaluationContext(this.getConfiguration())));
            return Literal.makeLiteral(val, this);
        }
        return this;
    }

    @Override
    public Expression typeCheck(ExpressionVisitor visitor, ContextItemStaticInfo contextInfo) throws XPathException {
        this.getOperand().typeCheck(visitor, contextInfo);
        TypeHierarchy th = visitor.getConfiguration().getTypeHierarchy();
        if (th.isSubType(this.getBaseExpression().getItemType(), this.requiredItemType)) {
            return this.getBaseExpression();
        }
        return this;
    }

    @Override
    protected int computeSpecialProperties() {
        int p = super.computeSpecialProperties();
        return p | 0x800000;
    }

    @Override
    public Expression copy(RebindingMap rebindings) {
        FunctionSequenceCoercer fsc2 = new FunctionSequenceCoercer(this.getBaseExpression().copy(rebindings), this.requiredItemType, this.roleSupplier);
        ExpressionTool.copyLocationInfo(this, fsc2);
        return fsc2;
    }

    @Override
    public int getImplementationMethod() {
        return 2;
    }

    @Override
    public SequenceIterator iterate(XPathContext context) throws XPathException {
        return this.makeElaborator().elaborateForPull().iterate(context);
    }

    @Override
    public FunctionItem evaluateItem(XPathContext context) throws XPathException {
        return (FunctionItem)this.makeElaborator().elaborateForItem().eval(context);
    }

    @Override
    public SpecificFunctionType getItemType() {
        return this.requiredItemType;
    }

    @Override
    protected int computeCardinality() {
        return this.getBaseExpression().getCardinality();
    }

    public RoleDiagnostic getRoleSupplier() {
        return this.roleSupplier.get();
    }

    @Override
    public boolean equals(Object other) {
        return super.equals(other) && this.requiredItemType.equals(((FunctionSequenceCoercer)other).requiredItemType);
    }

    @Override
    protected int computeHashCode() {
        return super.computeHashCode() ^ this.requiredItemType.hashCode();
    }

    @Override
    public String getExpressionName() {
        return "fnCoercer";
    }

    @Override
    public void export(ExpressionPresenter destination) throws XPathException {
        destination.startElement("fnCoercer", this);
        SequenceType st = SequenceType.makeSequenceType(this.requiredItemType, 16384);
        destination.emitAttribute("to", st.toAlphaCode());
        destination.emitAttribute("diag", this.roleSupplier.get().save());
        this.getBaseExpression().export(destination);
        destination.endElement();
    }

    @Override
    public Elaborator getElaborator() {
        return new FunctionSequenceCoercerElaborator();
    }

    private static void checkAnnotations(FunctionItem item, FunctionItemType requiredItemType, Configuration config) throws XPathException {
        for (Annotation ann : requiredItemType.getAnnotationAssertions()) {
            FunctionAnnotationHandler handler = config.getFunctionAnnotationHandler(ann.getAnnotationQName().getNamespaceUri());
            if (handler == null || handler.satisfiesAssertion(ann, item.getAnnotations())) continue;
            throw new XPathException("Supplied function does not satisfy the annotation assertions of the required function type", "XPTY0004");
        }
    }

    private static class FunctionSequenceCoercerElaborator
    extends PullElaborator {
        private FunctionSequenceCoercerElaborator() {
        }

        @Override
        public PullEvaluator elaborateForPull() {
            FunctionSequenceCoercer expr = (FunctionSequenceCoercer)this.getExpression();
            PullEvaluator base = expr.getBaseExpression().makeElaborator().elaborateForPull();
            Coercer coercer = new Coercer(expr.requiredItemType, expr.getConfiguration(), expr.getLocation());
            return context -> new ItemMappingIterator(base.iterate(context), coercer, true);
        }

        @Override
        public ItemEvaluator elaborateForItem() {
            FunctionSequenceCoercer expr = (FunctionSequenceCoercer)this.getExpression();
            ItemEvaluator base = expr.getBaseExpression().makeElaborator().elaborateForItem();
            Coercer coercer = new Coercer(expr.requiredItemType, expr.getConfiguration(), expr.getLocation());
            return context -> {
                Item item = base.eval(context);
                if (item == null) {
                    return null;
                }
                return coercer.mapItem(item);
            };
        }
    }

    public static class Coercer
    implements ItemMappingFunction {
        private final SpecificFunctionType requiredItemType;
        private final Configuration config;
        private final Location locator;

        public Coercer(SpecificFunctionType requiredItemType, Configuration config, Location locator) {
            this.requiredItemType = requiredItemType;
            this.config = config;
            this.locator = locator;
        }

        @Override
        public FunctionItem mapItem(Item item) throws XPathException {
            if (!(item instanceof FunctionItem)) {
                throw new XPathException("Function coercion attempted on an item (" + item.toShortString() + ") which is not a function", "XPTY0004", this.locator);
            }
            try {
                FunctionSequenceCoercer.checkAnnotations((FunctionItem)item, this.requiredItemType, this.config);
                return new CoercedFunction((FunctionItem)item, this.requiredItemType);
            }
            catch (XPathException err) {
                throw err.maybeWithLocation(this.locator);
            }
        }
    }
}

