/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.style;

import java.util.EnumSet;
import java.util.function.Supplier;
import net.sf.saxon.expr.CardinalityChecker;
import net.sf.saxon.expr.ContextItemExpression;
import net.sf.saxon.expr.DefaultedArgumentExpression;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ItemChecker;
import net.sf.saxon.expr.Literal;
import net.sf.saxon.expr.SuppliedParameterReference;
import net.sf.saxon.expr.UnaryExpression;
import net.sf.saxon.expr.instruct.LocalParam;
import net.sf.saxon.expr.instruct.SlotManager;
import net.sf.saxon.expr.instruct.UserFunction;
import net.sf.saxon.expr.instruct.UserFunctionParameter;
import net.sf.saxon.expr.parser.RoleDiagnostic;
import net.sf.saxon.om.SequenceTool;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.style.Compilation;
import net.sf.saxon.style.ComponentDeclaration;
import net.sf.saxon.style.SourceBinding;
import net.sf.saxon.style.StyleElement;
import net.sf.saxon.style.XSLFunction;
import net.sf.saxon.style.XSLGeneralVariable;
import net.sf.saxon.style.XSLTemplate;
import net.sf.saxon.trans.FunctionStreamability;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.linked.NodeImpl;
import net.sf.saxon.tree.util.Navigator;
import net.sf.saxon.value.SequenceType;
import net.sf.saxon.value.Whitespace;

public class XSLLocalParam
extends XSLGeneralVariable {
    private EnumSet<SourceBinding.BindingProperty> permittedAttributes = EnumSet.of(SourceBinding.BindingProperty.TUNNEL, SourceBinding.BindingProperty.REQUIRED, SourceBinding.BindingProperty.SELECT, SourceBinding.BindingProperty.AS);
    Expression conversion = null;
    private int slotNumber = -9876;
    private LocalParam compiledParam;
    private boolean prepared = false;

    @Override
    public SourceBinding getBindingInformation(StructuredQName name) {
        if (name.equals(this.sourceBinding.getVariableQName())) {
            return this.sourceBinding;
        }
        return null;
    }

    public int getSlotNumber() {
        return this.slotNumber;
    }

    @Override
    protected void prepareAttributes() {
        if (!this.prepared) {
            this.prepared = true;
            this.sourceBinding.setProperty(SourceBinding.BindingProperty.PARAM, true);
            if (this.getParent() instanceof XSLFunction) {
                this.sourceBinding.setProperty(SourceBinding.BindingProperty.REQUIRED, true);
                if (this.getCompilation().getCompilerInfo().getXsltVersion() != 40) {
                    this.permittedAttributes.remove((Object)SourceBinding.BindingProperty.SELECT);
                    this.sourceBinding.setProperty(SourceBinding.BindingProperty.DISALLOWS_CONTENT, true);
                }
            }
            this.sourceBinding.prepareAttributes(this.permittedAttributes);
            if (this.sourceBinding.hasProperty(SourceBinding.BindingProperty.TUNNEL) && !(this.getParent() instanceof XSLTemplate)) {
                this.compileError("For attribute 'tunnel' within an " + this.getParent().getDisplayName() + " parameter, the only permitted value is 'no'", "XTSE0020");
            }
            if (this.getParent() instanceof XSLFunction) {
                int pos = this.getParameterPosition();
                if (this.getCompilation().getCompilerInfo().getXsltVersion() >= 40) {
                    UserFunction uf = ((XSLFunction)this.getParent()).getCompiledFunction();
                    if (pos < uf.getParameterDefinitions().length) {
                        Expression defaultVal;
                        UserFunctionParameter ufp;
                        uf.getParameterDefinitions()[pos] = ufp = new UserFunctionParameter();
                        ufp.setRequiredType(this.getRequiredType());
                        ufp.setVariableQName(this.getVariableQName());
                        ufp.setSlotNumber(this.getSlotNumber());
                        ufp.setRequired(this.isRequiredParam());
                        if (pos == 0 && uf.getDeclaredStreamability() != FunctionStreamability.UNCLASSIFIED) {
                            ufp.setFunctionStreamability(uf.getDeclaredStreamability());
                        }
                        if ((defaultVal = this.sourceBinding.getSelectExpression()) != null && !(defaultVal instanceof Literal) && !(defaultVal instanceof ContextItemExpression)) {
                            this.compileError("The default value for a function parameter must be either a literal, or '.' (temporary Saxon restriction)");
                        }
                        if (defaultVal == null && !this.sourceBinding.hasProperty(SourceBinding.BindingProperty.REQUIRED)) {
                            defaultVal = new DefaultedArgumentExpression();
                        }
                        ufp.setDefaultValueExpression(defaultVal);
                    }
                } else if (!this.sourceBinding.hasProperty(SourceBinding.BindingProperty.REQUIRED)) {
                    this.compileError("For attribute 'required' within an " + this.getParent().getDisplayName() + " parameter, the only permitted value is 'yes'", "XTSE0020");
                }
            }
        }
    }

    private int getParameterPosition() {
        return Navigator.getNumberSimple(this, null) - 1;
    }

    public Supplier<Expression> getDefaultValueExpressionSupplier() {
        if (!this.prepared) {
            this.prepareAttributes();
        }
        return () -> {
            Expression select = this.sourceBinding.getSelectExpression();
            return select == null ? Literal.makeEmptySequence() : select;
        };
    }

    public void prepareTemplateSignatureAttributes() throws XPathException {
        if (!this.prepared) {
            this.sourceBinding.setProperty(SourceBinding.BindingProperty.PARAM, true);
            this.sourceBinding.prepareTemplateSignatureAttributes();
        }
    }

    @Override
    public void validate(ComponentDeclaration decl) throws XPathException {
        StructuredQName name = this.sourceBinding.getVariableQName();
        NodeImpl parent = this.getParent();
        boolean isFunction = this.getParent() instanceof XSLFunction;
        if (!(parent instanceof StyleElement) || !((StyleElement)parent).mayContainParam()) {
            this.compileError("xsl:param must be immediately within a template, function or stylesheet", "XTSE0010");
        }
        if (this.hasChildNodes() && isFunction && this.getCompilation().getCompilerInfo().getXsltVersion() != 40) {
            this.compileError("Function parameters cannot have a default value", "XTSE0760");
        }
        SequenceTool.supply(this.iterateAxis(11), node -> {
            if (node instanceof XSLLocalParam) {
                if (name.equals(((XSLLocalParam)node).sourceBinding.getVariableQName())) {
                    this.compileError("The name of the parameter (" + name + ") is not unique", "XTSE0580");
                }
                if (isFunction && this.isRequiredParam() && !((XSLLocalParam)node).isRequiredParam()) {
                    this.compileError("Parameter " + name + " is required, but an earlier parameter " + ((XSLLocalParam)node).sourceBinding.getVariableQName() + " is optional", "XTSE0761");
                    ((XSLLocalParam)node).sourceBinding.setProperty(SourceBinding.BindingProperty.REQUIRED, true);
                }
            } else if (node instanceof StyleElement && ((StyleElement)node).getFingerprint() != 145) {
                this.compileError("xsl:param must not be preceded by other instructions", "XTSE0010");
            } else if (!Whitespace.isAllWhite(node.getUnicodeStringValue())) {
                this.compileError("xsl:param must not be preceded by text", "XTSE0010");
            }
        });
        SlotManager p = this.getContainingSlotManager();
        if (p == null) {
            this.compileError("Local variable must be declared within a template or function", "XTSE0010");
        } else {
            this.slotNumber = p.allocateSlotNumber(name);
        }
        if (this.sourceBinding.hasProperty(SourceBinding.BindingProperty.REQUIRED)) {
            String errorCode;
            if (this.sourceBinding.getSelectExpression() != null) {
                errorCode = isFunction ? "XTSE0760" : "XTSE0010";
                this.compileError("The select attribute must be omitted when required='yes'", errorCode);
            }
            if (this.hasChildNodes()) {
                errorCode = isFunction ? "XTSE0760" : "XTSE0010";
                this.compileError("A parameter specifying required='yes' must have empty content", errorCode);
            }
        }
        super.validate(decl);
    }

    public boolean isTunnelParam() {
        return this.sourceBinding.hasProperty(SourceBinding.BindingProperty.TUNNEL);
    }

    public boolean isRequiredParam() {
        return this.sourceBinding.hasProperty(SourceBinding.BindingProperty.REQUIRED);
    }

    @Override
    protected boolean seesAvuncularVariables() {
        return !(this.getParent() instanceof XSLFunction);
    }

    @Override
    public void fixupReferences() throws XPathException {
        this.sourceBinding.fixupReferences(null);
        super.fixupReferences();
    }

    @Override
    public Expression compile(Compilation exec, ComponentDeclaration decl) throws XPathException {
        if (this.getParent() instanceof XSLFunction) {
            if (this.getCompilation().getCompilerInfo().getXsltVersion() >= 40 && !this.isRequiredParam()) {
                this.sourceBinding.handleSequenceConstructor(exec, decl);
                Expression selectExpression = this.sourceBinding.getSelectExpression();
                if (selectExpression == null) {
                    selectExpression = Literal.makeEmptySequence();
                } else {
                    Expression underlyingExpression = selectExpression;
                    while (underlyingExpression instanceof ItemChecker || underlyingExpression instanceof CardinalityChecker) {
                        underlyingExpression = ((UnaryExpression)underlyingExpression).getBaseExpression();
                    }
                    if (!(underlyingExpression instanceof Literal) && !(underlyingExpression instanceof ContextItemExpression)) {
                        this.compileError("The default value for a function parameter must be either a literal, or '.' (temporary Saxon restriction)");
                    }
                }
                int pos = this.getParameterPosition();
                ((XSLFunction)this.getParent()).getCompiledFunction().getParameterDefinitions()[pos].setDefaultValueExpression(selectExpression);
            }
            return null;
        }
        SequenceType declaredType = this.getRequiredType();
        StructuredQName name = this.sourceBinding.getVariableQName();
        int slot = this.getSlotNumber();
        if (declaredType != null) {
            SuppliedParameterReference pref = new SuppliedParameterReference(slot);
            pref.setRetainedStaticContext(this.makeRetainedStaticContext());
            pref.setLocation(this.allocateLocation());
            Supplier<RoleDiagnostic> role = () -> new RoleDiagnostic(8, name.getDisplayName(), 0, "XTTE0590");
            this.conversion = exec.getConfiguration().getTypeChecker(false).staticTypeCheck(pref, declaredType, role, this.makeExpressionVisitor());
        }
        this.sourceBinding.handleSequenceConstructor(exec, decl);
        LocalParam binding = new LocalParam();
        binding.setSelectExpression(this.sourceBinding.getSelectExpression());
        binding.setConversion(this.conversion);
        binding.setVariableQName(name);
        binding.setSlotNumber(slot);
        binding.setRequiredType(this.getRequiredType());
        binding.setRequiredParam(this.sourceBinding.hasProperty(SourceBinding.BindingProperty.REQUIRED));
        binding.setImplicitlyRequiredParam(this.sourceBinding.hasProperty(SourceBinding.BindingProperty.IMPLICITLY_REQUIRED));
        binding.setTunnel(this.sourceBinding.hasProperty(SourceBinding.BindingProperty.TUNNEL));
        this.sourceBinding.fixupBinding(binding);
        this.compiledParam = binding;
        return this.compiledParam;
    }

    public LocalParam getCompiledParam() {
        return this.compiledParam;
    }

    public SequenceType getRequiredType() {
        SequenceType declaredType = this.sourceBinding.getDeclaredType();
        if (declaredType != null) {
            return declaredType;
        }
        return SequenceType.ANY_SEQUENCE;
    }
}

