/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr;

import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.FirstItemExpression;
import net.sf.saxon.expr.Literal;
import net.sf.saxon.expr.Operand;
import net.sf.saxon.expr.OperandRole;
import net.sf.saxon.expr.SingleItemFilter;
import net.sf.saxon.expr.TailIterator;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.elab.Elaborator;
import net.sf.saxon.expr.elab.ItemElaborator;
import net.sf.saxon.expr.elab.ItemEvaluator;
import net.sf.saxon.expr.elab.PullEvaluator;
import net.sf.saxon.expr.parser.ContextItemStaticInfo;
import net.sf.saxon.expr.parser.ExpressionTool;
import net.sf.saxon.expr.parser.ExpressionVisitor;
import net.sf.saxon.expr.parser.RebindingMap;
import net.sf.saxon.om.GroundedValue;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.MemoSequence;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.SequenceTool;
import net.sf.saxon.trace.ExpressionPresenter;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.iter.GroundedIterator;
import net.sf.saxon.value.NumericValue;

public class SubscriptExpression
extends SingleItemFilter {
    private final Operand subscriptOp;

    public SubscriptExpression(Expression base, Expression subscript) {
        super(base);
        this.subscriptOp = new Operand(this, subscript, OperandRole.SINGLE_ATOMIC);
    }

    public Expression getSubscript() {
        return this.subscriptOp.getChildExpression();
    }

    public void setSubscript(Expression subscript) {
        this.subscriptOp.setChildExpression(subscript);
    }

    @Override
    public Expression typeCheck(ExpressionVisitor visitor, ContextItemStaticInfo contextInfo) throws XPathException {
        this.getOperand().typeCheck(visitor, contextInfo);
        return this;
    }

    @Override
    public Expression optimize(ExpressionVisitor visitor, ContextItemStaticInfo contextInfo) throws XPathException {
        this.getOperand().optimize(visitor, contextInfo);
        if (Literal.isConstantOne(this.getSubscript())) {
            return FirstItemExpression.makeFirstItemExpression(this.getBaseExpression());
        }
        return this;
    }

    @Override
    public Expression copy(RebindingMap rebindings) {
        SubscriptExpression exp = new SubscriptExpression(this.getBaseExpression().copy(rebindings), this.getSubscript().copy(rebindings));
        ExpressionTool.copyLocationInfo(this, exp);
        return exp;
    }

    @Override
    public Iterable<Operand> operands() {
        return this.operandList(this.getOperand(), this.subscriptOp);
    }

    public Expression getSubscriptExpression() {
        return this.getSubscript();
    }

    @Override
    public int getImplementationMethod() {
        return 1;
    }

    @Override
    public boolean equals(Object other) {
        return other instanceof SubscriptExpression && this.getBaseExpression().isEqual(((SubscriptExpression)other).getBaseExpression()) && this.getSubscript().isEqual(((SubscriptExpression)other).getSubscript());
    }

    @Override
    protected int computeHashCode() {
        return this.getBaseExpression().hashCode() ^ this.getSubscript().hashCode();
    }

    @Override
    public String getStreamerName() {
        return "SubscriptExpression";
    }

    @Override
    public Item evaluateItem(XPathContext context) throws XPathException {
        return this.makeElaborator().elaborateForItem().eval(context);
    }

    public static Item getItemAt(SequenceIterator iter, int index) throws XPathException {
        Item item;
        if (index == 1) {
            item = iter.next();
        } else if (iter instanceof MemoSequence.ProgressiveIterator) {
            MemoSequence mem = ((MemoSequence.ProgressiveIterator)iter).getMemoSequence();
            item = mem.itemAt(index - 1);
        } else if (iter instanceof GroundedIterator && ((GroundedIterator)iter).isActuallyGrounded()) {
            GroundedValue value = SequenceTool.toGroundedValue(iter);
            item = value.itemAt(index - 1);
        } else {
            SequenceIterator tail = TailIterator.make(iter, index);
            item = tail.next();
            tail.close();
        }
        return item;
    }

    @Override
    public String getExpressionName() {
        return "subscript";
    }

    @Override
    public void export(ExpressionPresenter destination) throws XPathException {
        destination.startElement("subscript", this);
        this.getBaseExpression().export(destination);
        this.getSubscript().export(destination);
        destination.endElement();
    }

    @Override
    public String toString() {
        return ExpressionTool.parenthesize(this.getBaseExpression()) + "[" + this.getSubscript() + "]";
    }

    @Override
    public String toShortString() {
        return ExpressionTool.parenthesize(this.getBaseExpression()) + "[" + this.getSubscript().toShortString() + "]";
    }

    @Override
    public Elaborator getElaborator() {
        return new SubscriptExprElaborator();
    }

    public static class SubscriptExprElaborator
    extends ItemElaborator {
        @Override
        public ItemEvaluator elaborateForItem() {
            SubscriptExpression expr = (SubscriptExpression)this.getExpression();
            PullEvaluator baseEval = expr.getBaseExpression().makeElaborator().elaborateForPull();
            ItemEvaluator indexEval = expr.getSubscriptExpression().makeElaborator().elaborateForItem();
            return context -> {
                NumericValue index = (NumericValue)indexEval.eval(context);
                if (index == null) {
                    return null;
                }
                int intIndex = index.asSubscript();
                if (intIndex != -1) {
                    SequenceIterator iter = baseEval.iterate(context);
                    return SubscriptExpression.getItemAt(iter, intIndex);
                }
                return null;
            };
        }
    }
}

