/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr.flwor;

import java.util.List;
import net.sf.saxon.event.Outputter;
import net.sf.saxon.expr.Binding;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.Literal;
import net.sf.saxon.expr.Operand;
import net.sf.saxon.expr.OperandRole;
import net.sf.saxon.expr.VariableReference;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.elab.PullEvaluator;
import net.sf.saxon.expr.flwor.Clause;
import net.sf.saxon.expr.flwor.DiagnosticClausePull;
import net.sf.saxon.expr.flwor.DiagnosticClausePush;
import net.sf.saxon.expr.flwor.FLWORExpression;
import net.sf.saxon.expr.flwor.LocalVariableBinding;
import net.sf.saxon.expr.flwor.OperandProcessor;
import net.sf.saxon.expr.flwor.TuplePull;
import net.sf.saxon.expr.flwor.TuplePush;
import net.sf.saxon.expr.parser.ContextItemStaticInfo;
import net.sf.saxon.expr.parser.ExpressionTool;
import net.sf.saxon.expr.parser.ExpressionVisitor;
import net.sf.saxon.expr.parser.PathMap;
import net.sf.saxon.expr.parser.RebindingMap;
import net.sf.saxon.trace.ExpressionPresenter;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.ItemType;

public class DiagnosticClause
extends Clause {
    private Operand sequenceOp;
    private PullEvaluator evaluator;

    @Override
    public Clause.ClauseName getClauseKey() {
        return Clause.ClauseName.DIAG;
    }

    public PullEvaluator getEvaluator() {
        if (this.evaluator == null) {
            this.evaluator = this.getSequence().makeElaborator().elaborateForPull();
        }
        return this.evaluator;
    }

    @Override
    public DiagnosticClause copy(FLWORExpression flwor, RebindingMap rebindings) {
        DiagnosticClause diag2 = new DiagnosticClause();
        diag2.setLocation(this.getLocation());
        diag2.setPackageData(this.getPackageData());
        diag2.initSequence(flwor, this.getSequence().copy(rebindings));
        return diag2;
    }

    public void initSequence(FLWORExpression flwor, Expression sequence) {
        this.sequenceOp = new Operand(flwor, sequence, this.isRepeated() ? OperandRole.REPEAT_NAVIGATE : OperandRole.NAVIGATE);
    }

    public Expression getSequence() {
        return this.sequenceOp.getChildExpression();
    }

    @Override
    public LocalVariableBinding[] getRangeVariables() {
        return new LocalVariableBinding[0];
    }

    @Override
    public TuplePull getPullStream(TuplePull base, XPathContext context) {
        return new DiagnosticClausePull(base, this);
    }

    @Override
    public TuplePush getPushStream(TuplePush destination, Outputter output, XPathContext context) {
        return new DiagnosticClausePush(output, destination, this);
    }

    @Override
    public void processOperands(OperandProcessor processor) throws XPathException {
        processor.processOperand(this.sequenceOp);
    }

    @Override
    public void typeCheck(ExpressionVisitor visitor, ContextItemStaticInfo contextInfo) throws XPathException {
    }

    @Override
    public void gatherVariableReferences(ExpressionVisitor visitor, Binding binding, List<VariableReference> references) {
        ExpressionTool.gatherVariableReferences(this.getSequence(), binding, references);
    }

    @Override
    public void refineVariableType(ExpressionVisitor visitor, List<VariableReference> references, Expression returnExpr) {
        Expression seq = this.getSequence();
        ItemType actualItemType = seq.getItemType();
        for (VariableReference ref : references) {
            ref.refineVariableType(actualItemType, this.getSequence().getCardinality(), seq instanceof Literal ? ((Literal)seq).getGroundedValue() : null, seq.getSpecialProperties());
            ExpressionTool.resetStaticProperties(returnExpr);
        }
    }

    @Override
    public void addToPathMap(PathMap pathMap, PathMap.PathMapNodeSet pathMapNodeSet) {
        PathMap.PathMapNodeSet varPath = this.getSequence().addToPathMap(pathMap, pathMapNodeSet);
    }

    @Override
    public void explain(ExpressionPresenter out) throws XPathException {
        out.startElement("trace");
        this.getSequence().export(out);
        out.endElement();
    }

    @Override
    public String toShortString() {
        StringBuilder fsb = new StringBuilder(64);
        fsb.append("trace ");
        fsb.append(this.getSequence().toShortString());
        return fsb.toString();
    }

    public String toString() {
        StringBuilder fsb = new StringBuilder(64);
        fsb.append("trace ");
        fsb.append(this.getSequence().toString());
        return fsb.toString();
    }
}

