/*
 * Decompiled with CFR 0.152.
 */
package statemap;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.PrintStream;
import java.io.Serializable;
import java.util.EmptyStackException;
import java.util.Stack;
import statemap.State;

public abstract class FSMContext
implements Serializable {
    protected transient String _name = "FSMContext";
    protected transient State _state = null;
    protected transient String _transition = "";
    protected transient State _previousState = null;
    protected transient Stack<State> _stateStack = null;
    protected transient boolean _debugFlag = false;
    protected transient PrintStream _debugStream = System.err;
    private transient PropertyChangeSupport _listeners = new PropertyChangeSupport(this);

    public String getName() {
        return this._name;
    }

    public boolean getDebugFlag() {
        return this._debugFlag && this._debugStream != null;
    }

    public PrintStream getDebugStream() {
        return this._debugStream == null ? System.err : this._debugStream;
    }

    public boolean isInTransition() {
        return this._state == null;
    }

    public State getPreviousState() throws NullPointerException {
        if (this._previousState == null) {
            throw new NullPointerException();
        }
        return this._previousState;
    }

    public String getTransition() {
        return this._transition;
    }

    public void setName(String name) {
        if (name != null && name.length() > 0 && !name.equals(this._name)) {
            this._name = name;
        }
    }

    public void setDebugFlag(boolean flag) {
        this._debugFlag = flag;
    }

    public void setDebugStream(PrintStream stream) {
        this._debugStream = stream;
    }

    public void setState(State state) {
        State previousState = this._state;
        if (this.getDebugFlag()) {
            this.getDebugStream().println("NEW STATE    : " + state.getName());
        }
        this._state = state;
        this._listeners.firePropertyChange("State", previousState, this._state);
    }

    public void clearState() {
        this._previousState = this._state;
        this._state = null;
    }

    public void pushState(State state) {
        State previousState = this._state;
        if (this._state == null) {
            throw new NullPointerException();
        }
        if (this.getDebugFlag()) {
            this.getDebugStream().println("PUSH TO STATE: " + state.getName());
        }
        if (this._stateStack == null) {
            this._stateStack = new Stack();
        }
        this._stateStack.push(this._state);
        this._state = state;
        this._listeners.firePropertyChange("State", previousState, this._state);
    }

    public void popState() throws EmptyStackException {
        if (this._stateStack == null || this._stateStack.isEmpty()) {
            if (this.getDebugFlag()) {
                this.getDebugStream().println("POPPING ON EMPTY STATE STACK.");
            }
            throw new EmptyStackException();
        }
        State previousState = this._state;
        this._state = this._stateStack.pop();
        if (this._stateStack.isEmpty()) {
            this._stateStack = null;
        }
        if (this.getDebugFlag()) {
            this.getDebugStream().println("POP TO STATE : " + this._state.getName());
        }
        this._listeners.firePropertyChange("State", previousState, this._state);
    }

    public void emptyStateStack() {
        this._stateStack.clear();
        this._stateStack = null;
    }

    public void addStateChangeListener(PropertyChangeListener listener) {
        this._listeners.addPropertyChangeListener("State", listener);
    }

    public void removeStateChangeListener(PropertyChangeListener listener) {
        this._listeners.removePropertyChangeListener("State", listener);
    }
}

