/*
 * Decompiled with CFR 0.152.
 */
package nl.martijndwars.webpush;

import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PublicKey;
import java.security.spec.InvalidKeySpecException;
import nl.martijndwars.webpush.Subscription;
import nl.martijndwars.webpush.Utils;

public class Notification {
    private final String endpoint;
    private final PublicKey userPublicKey;
    private final byte[] userAuth;
    private final byte[] payload;
    private final int ttl;

    public Notification(String endpoint, PublicKey userPublicKey, byte[] userAuth, byte[] payload, int ttl) {
        this.endpoint = endpoint;
        this.userPublicKey = userPublicKey;
        this.userAuth = userAuth;
        this.payload = payload;
        this.ttl = ttl;
    }

    public Notification(String endpoint, PublicKey userPublicKey, byte[] userAuth, byte[] payload) {
        this(endpoint, userPublicKey, userAuth, payload, 2419200);
    }

    public Notification(String endpoint, String userPublicKey, String userAuth, byte[] payload) throws NoSuchAlgorithmException, NoSuchProviderException, InvalidKeySpecException {
        this(endpoint, Utils.loadPublicKey(userPublicKey), Utils.base64Decode(userAuth), payload);
    }

    public Notification(String endpoint, String userPublicKey, String userAuth, String payload) throws NoSuchAlgorithmException, NoSuchProviderException, InvalidKeySpecException {
        this(endpoint, Utils.loadPublicKey(userPublicKey), Utils.base64Decode(userAuth), payload.getBytes(StandardCharsets.UTF_8));
    }

    public Notification(Subscription subscription, String payload) throws NoSuchAlgorithmException, NoSuchProviderException, InvalidKeySpecException {
        this(subscription.endpoint, subscription.keys.p256dh, subscription.keys.auth, payload);
    }

    public String getEndpoint() {
        return this.endpoint;
    }

    public PublicKey getUserPublicKey() {
        return this.userPublicKey;
    }

    public byte[] getUserAuth() {
        return this.userAuth;
    }

    public byte[] getPayload() {
        return this.payload;
    }

    public boolean hasPayload() {
        return this.getPayload().length > 0;
    }

    public boolean isGcm() {
        return this.getEndpoint().indexOf("https://android.googleapis.com/gcm/send") == 0;
    }

    public int getTTL() {
        return this.ttl;
    }

    public int getPadSize() {
        return 2;
    }

    public String getOrigin() throws MalformedURLException {
        URL url = new URL(this.getEndpoint());
        return url.getProtocol() + "://" + url.getHost();
    }
}

