/*
 * Decompiled with CFR 0.152.
 */
package nl.martijndwars.webpush.cli.handlers;

import com.google.common.io.BaseEncoding;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.security.InvalidAlgorithmParameterException;
import java.security.Key;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.spec.AlgorithmParameterSpec;
import nl.martijndwars.webpush.Utils;
import nl.martijndwars.webpush.cli.commands.GenerateKeyCommand;
import nl.martijndwars.webpush.cli.handlers.HandlerInterface;
import org.bouncycastle.jce.ECNamedCurveTable;
import org.bouncycastle.jce.interfaces.ECPrivateKey;
import org.bouncycastle.jce.interfaces.ECPublicKey;
import org.bouncycastle.jce.spec.ECNamedCurveParameterSpec;
import org.bouncycastle.util.io.pem.PemObject;
import org.bouncycastle.util.io.pem.PemObjectGenerator;
import org.bouncycastle.util.io.pem.PemWriter;

public class GenerateKeyHandler
implements HandlerInterface {
    private GenerateKeyCommand generateKeyCommand;

    public GenerateKeyHandler(GenerateKeyCommand generateKeyCommand) {
        this.generateKeyCommand = generateKeyCommand;
    }

    @Override
    public void run() throws InvalidAlgorithmParameterException, NoSuchAlgorithmException, NoSuchProviderException, IOException {
        KeyPair keyPair = this.generateKeyPair();
        byte[] publicKey = Utils.savePublicKey((ECPublicKey)keyPair.getPublic());
        byte[] privateKey = Utils.savePrivateKey((ECPrivateKey)keyPair.getPrivate());
        if (this.generateKeyCommand.hasPublicKeyFile().booleanValue()) {
            this.writeKey(keyPair.getPublic(), new File(this.generateKeyCommand.getPublicKeyFile()));
        }
        System.out.println("PublicKey:");
        System.out.println(BaseEncoding.base64Url().encode(publicKey));
        System.out.println("PrivateKey:");
        System.out.println(BaseEncoding.base64Url().encode(privateKey));
    }

    private KeyPair generateKeyPair() throws InvalidAlgorithmParameterException, NoSuchProviderException, NoSuchAlgorithmException {
        ECNamedCurveParameterSpec parameterSpec = ECNamedCurveTable.getParameterSpec((String)"prime256v1");
        KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance("ECDH", "BC");
        keyPairGenerator.initialize((AlgorithmParameterSpec)parameterSpec);
        return keyPairGenerator.generateKeyPair();
    }

    private void writeKey(Key key, File file) throws IOException {
        file.createNewFile();
        try (PemWriter pemWriter = new PemWriter((Writer)new OutputStreamWriter(new FileOutputStream(file)));){
            PemObject pemObject = new PemObject("Key", key.getEncoded());
            pemWriter.writeObject((PemObjectGenerator)pemObject);
        }
    }
}

